/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path.json;

import java.util.Objects;
import java.util.Set;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.sirix.api.json.JsonNodeReadOnlyTrx;
import org.sirix.api.json.JsonNodeTrx;
import org.sirix.index.path.PCRCollector;
import org.sirix.index.path.PCRValue;
import org.sirix.index.path.summary.PathSummaryReader;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class JsonPCRCollector
implements PCRCollector {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(JsonPCRCollector.class));
    private final JsonNodeReadOnlyTrx mRtx;

    public JsonPCRCollector(JsonNodeReadOnlyTrx rtx) {
        this.mRtx = Objects.requireNonNull(rtx, "The transaction must not be null.");
    }

    @Override
    public PCRValue getPCRsForPaths(Set<Path<QNm>> paths) {
        PathSummaryReader reader = this.mRtx instanceof JsonNodeTrx ? ((JsonNodeTrx)this.mRtx).getPathSummary() : this.mRtx.getResourceManager().openPathSummary(this.mRtx.getRevisionNumber());
        try {
            long maxPCR = reader.getMaxNodeKey();
            Set<Long> pathClassRecords = reader.getPCRsForPaths(paths, true);
            PCRValue pCRValue = PCRValue.getInstance(maxPCR, pathClassRecords);
            if (reader != null) {
                reader.close();
            }
            return pCRValue;
        }
        catch (Throwable throwable) {
            try {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (PathException e) {
                LOGGER.error(e.getMessage(), new Object[]{e});
                return PCRValue.getEmptyInstance();
            }
        }
    }
}

