/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.index.path.summary;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.time.Instant;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnegative;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.util.path.Path;
import org.brackit.xquery.util.path.PathException;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.access.trx.node.Move;
import org.sirix.api.Filter;
import org.sirix.api.NodeCursor;
import org.sirix.api.NodeReadOnlyTrx;
import org.sirix.api.NodeTrx;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.ResourceManager;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.filter.FilterAxis;
import org.sirix.axis.filter.PathNameFilter;
import org.sirix.exception.SirixIOException;
import org.sirix.index.path.summary.ImmutablePathNode;
import org.sirix.index.path.summary.PathNode;
import org.sirix.node.Kind;
import org.sirix.node.NullNode;
import org.sirix.node.immutable.xdm.ImmutableDocumentNode;
import org.sirix.node.interfaces.NameNode;
import org.sirix.node.interfaces.Record;
import org.sirix.node.interfaces.StructNode;
import org.sirix.node.interfaces.immutable.ImmutableNode;
import org.sirix.node.xdm.XdmDocumentRootNode;
import org.sirix.page.PageKind;
import org.sirix.page.PathSummaryPage;
import org.sirix.settings.Fixed;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.NamePageHash;
import org.slf4j.LoggerFactory;

public final class PathSummaryReader
implements NodeReadOnlyTrx,
NodeCursor {
    private final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(PathSummaryReader.class));
    private StructNode mCurrentNode;
    private final PageReadOnlyTrx mPageReadTrx;
    private final ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> mResourceManager;
    private boolean mClosed;
    private final Map<Long, StructNode> mPathNodeMapping;
    private final Map<QNm, Set<PathNode>> mQNmMapping;
    private final Map<Path<QNm>, Set<Long>> mPathCache = new HashMap<Path<QNm>, Set<Long>>();

    private PathSummaryReader(PageReadOnlyTrx pageReadTrx, ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceManager) {
        this.mPageReadTrx = pageReadTrx;
        this.mClosed = false;
        this.mResourceManager = resourceManager;
        try {
            Optional<? extends Record> node = this.mPageReadTrx.getRecord(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), PageKind.PATHSUMMARYPAGE, 0);
            if (!node.isPresent()) {
                throw new IllegalStateException("Node couldn't be fetched from persistent storage!");
            }
            this.mCurrentNode = (StructNode)node.get();
        }
        catch (SirixIOException e) {
            this.LOGWRAPPER.error(e.getMessage(), e.getCause());
        }
        this.mPathNodeMapping = new HashMap<Long, StructNode>();
        this.mQNmMapping = new HashMap<QNm, Set<PathNode>>();
        boolean first = true;
        for (long nodeKey : new DescendantAxis(this, IncludeSelf.YES)) {
            this.mPathNodeMapping.put(nodeKey, this.getStructuralNode());
            if (first) {
                first = false;
                continue;
            }
            HashSet<PathNode> pathNodes = this.mQNmMapping.get(this.getName()) == null ? new HashSet<PathNode>() : this.mQNmMapping.get(this.getName());
            pathNodes.add(this.getPathNode());
            this.mQNmMapping.put(this.getName(), pathNodes);
        }
    }

    @Override
    public PageReadOnlyTrx getPageTrx() {
        return this.mPageReadTrx;
    }

    public static final PathSummaryReader getInstance(PageReadOnlyTrx pageReadTrx, ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> resourceManager) {
        return new PathSummaryReader((PageReadOnlyTrx)Preconditions.checkNotNull((Object)pageReadTrx), (ResourceManager)Preconditions.checkNotNull(resourceManager));
    }

    void putMapping(@Nonnegative long pathNodeKey, StructNode node) {
        this.mPathNodeMapping.put(pathNodeKey, node);
    }

    StructNode removeMapping(@Nonnegative long pathNodeKey) {
        return this.mPathNodeMapping.remove(pathNodeKey);
    }

    void putQNameMapping(PathNode node, QNm name) {
        HashSet<PathNode> pathNodes = this.mQNmMapping.get(name) == null ? new HashSet<PathNode>() : this.mQNmMapping.get(name);
        pathNodes.add(node);
        this.mQNmMapping.put(name, pathNodes);
    }

    void removeQNameMapping(@Nonnegative PathNode node, QNm name) {
        HashSet pathNodes;
        Set<Object> set = pathNodes = this.mQNmMapping.get(name) == null ? new HashSet() : this.mQNmMapping.get(name);
        if (pathNodes.size() == 1) {
            this.mQNmMapping.remove(name);
        } else {
            pathNodes.remove(node);
        }
    }

    public BitSet matchDescendants(QNm name, @Nonnegative long pathNodeKey, IncludeSelf inclSelf) {
        this.assertNotClosed();
        Set<PathNode> set = this.mQNmMapping.get(name);
        if (set == null) {
            return new BitSet(0);
        }
        this.moveTo(pathNodeKey);
        BitSet matches = new BitSet();
        for (long nodeKey : new FilterAxis<PathSummaryReader>(new DescendantAxis(this, inclSelf), new PathNameFilter(this, name.toString()), new Filter[0])) {
            matches.set((int)nodeKey);
        }
        return matches;
    }

    public BitSet match(QNm name, @Nonnegative int minLevel) {
        this.assertNotClosed();
        Set<PathNode> set = this.mQNmMapping.get(name);
        if (set == null) {
            return new BitSet(0);
        }
        BitSet matches = new BitSet();
        for (PathNode psn : set) {
            if (psn.getLevel() < minLevel) continue;
            matches.set((int)psn.getNodeKey());
        }
        return matches;
    }

    public Set<Long> getPCRsForPaths(Collection<Path<QNm>> expressions, boolean useCache) throws PathException {
        this.assertNotClosed();
        HashSet<Long> pcrs = new HashSet<Long>();
        for (Path<QNm> path : expressions) {
            Set<Long> pcrsForPath = this.getPCRsForPath(path, useCache);
            pcrs.addAll(pcrsForPath);
        }
        return pcrs;
    }

    public PathNode getPathNodeForPathNodeKey(@Nonnegative long pathNodeKey) {
        this.assertNotClosed();
        if (pathNodeKey <= 0L) {
            throw new IllegalArgumentException("Key not supported.");
        }
        return (PathNode)this.mPathNodeMapping.get(pathNodeKey);
    }

    @Override
    public ImmutableNode getNode() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof XdmDocumentRootNode) {
            return ImmutableDocumentNode.of((XdmDocumentRootNode)this.mCurrentNode);
        }
        return ImmutablePathNode.of((PathNode)this.mCurrentNode);
    }

    public Set<Long> getPCRsForPath(Path<QNm> path, boolean useCache) throws PathException {
        HashSet<Long> pcrSet;
        if (useCache) {
            if (this.mPathCache.containsKey(path) && this.mPathCache.get(path) != null) {
                return this.mPathCache.get(path);
            }
            pcrSet = new HashSet();
        } else {
            pcrSet = new HashSet<Long>();
        }
        boolean isAttributePattern = path.isAttribute();
        int pathLength = path.getLength();
        long nodeKey = this.mCurrentNode.getNodeKey();
        this.moveToDocumentRoot();
        DescendantAxis axis = new DescendantAxis(this);
        while (axis.hasNext()) {
            axis.next();
            PathNode node = this.getPathNode();
            if (node == null || node.getLevel() < pathLength || isAttributePattern ^ node.getPathKind() == Kind.ATTRIBUTE || !path.matches(node.getPath(this))) continue;
            pcrSet.add(node.getNodeKey());
        }
        this.moveTo(nodeKey);
        if (useCache) {
            this.mPathCache.put(path, pcrSet);
        }
        return pcrSet;
    }

    @Override
    public boolean hasChildren() {
        this.assertNotClosed();
        return this.getStructuralNode().getChildCount() > 0L;
    }

    public PathNode getPathNode() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof PathNode) {
            return (PathNode)this.mCurrentNode;
        }
        return null;
    }

    public Move<? extends PathSummaryReader> moveTo(long nodeKey) {
        Optional<Object> newNode;
        this.assertNotClosed();
        StructNode oldNode = this.mCurrentNode;
        try {
            Optional<? extends Record> node = this.mPageReadTrx.getRecord(nodeKey, PageKind.PATHSUMMARYPAGE, 0);
            newNode = node;
        }
        catch (SirixIOException e) {
            newNode = Optional.empty();
        }
        if (newNode.isPresent()) {
            this.mCurrentNode = (StructNode)newNode.get();
            return Move.moved(this);
        }
        this.mCurrentNode = oldNode;
        return Move.notMoved();
    }

    public Move<? extends PathSummaryReader> moveToParent() {
        this.assertNotClosed();
        return this.moveTo(this.getStructuralNode().getParentKey());
    }

    public Move<? extends PathSummaryReader> moveToFirstChild() {
        this.assertNotClosed();
        if (!this.getStructuralNode().hasFirstChild()) {
            return Move.notMoved();
        }
        return this.moveTo(this.getStructuralNode().getFirstChildKey());
    }

    public Move<? extends PathSummaryReader> moveToLeftSibling() {
        this.assertNotClosed();
        if (!this.getStructuralNode().hasLeftSibling()) {
            return Move.notMoved();
        }
        return this.moveTo(this.getStructuralNode().getLeftSiblingKey());
    }

    public Move<? extends PathSummaryReader> moveToRightSibling() {
        this.assertNotClosed();
        if (!this.getStructuralNode().hasRightSibling()) {
            return Move.notMoved();
        }
        return this.moveTo(this.getStructuralNode().getRightSiblingKey());
    }

    @Override
    public void close() {
        if (!this.mClosed) {
            this.mCurrentNode = null;
            this.mClosed = true;
            if (this.mPageReadTrx != null && !this.mPageReadTrx.isClosed()) {
                this.mPageReadTrx.close();
            }
        }
    }

    final void assertNotClosed() {
        if (this.mClosed) {
            throw new IllegalStateException("Path summary is already closed.");
        }
    }

    public Move<? extends PathSummaryReader> moveToDocumentRoot() {
        return this.moveTo(Fixed.DOCUMENT_NODE_KEY.getStandardProperty());
    }

    private StructNode getStructuralNode() {
        if (this.mCurrentNode instanceof StructNode) {
            return this.mCurrentNode;
        }
        return new NullNode(this.mCurrentNode);
    }

    @Override
    public long getId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRevisionNumber() {
        this.assertNotClosed();
        return this.mPageReadTrx.getRevisionNumber();
    }

    @Override
    public Instant getRevisionTimestamp() {
        this.assertNotClosed();
        return Instant.ofEpochMilli(this.mPageReadTrx.getActualRevisionRootPage().getRevisionTimestamp());
    }

    @Override
    public long getMaxNodeKey() {
        this.assertNotClosed();
        return ((PathSummaryPage)this.mPageReadTrx.getActualRevisionRootPage().getPathSummaryPageReference().getPage()).getMaxNodeKey(0);
    }

    public Move<? extends PathSummaryReader> moveToNextFollowing() {
        this.assertNotClosed();
        while (!this.getStructuralNode().hasRightSibling() && this.mCurrentNode.hasParent()) {
            this.moveToParent();
        }
        return this.moveToRightSibling();
    }

    @Override
    public QNm getName() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            int uriKey = ((NameNode)((Object)this.mCurrentNode)).getURIKey();
            String uri = uriKey == -1 ? "" : this.mPageReadTrx.getName(((NameNode)((Object)this.mCurrentNode)).getURIKey(), Kind.NAMESPACE);
            int prefixKey = ((NameNode)((Object)this.mCurrentNode)).getPrefixKey();
            String prefix = prefixKey == -1 ? "" : this.mPageReadTrx.getName(prefixKey, ((PathNode)this.mCurrentNode).getPathKind());
            int localNameKey = ((NameNode)((Object)this.mCurrentNode)).getLocalNameKey();
            String localName = localNameKey == -1 ? "" : this.mPageReadTrx.getName(localNameKey, ((PathNode)this.mCurrentNode).getPathKind());
            return new QNm(uri, prefix, localName);
        }
        return null;
    }

    @Override
    public int keyForName(String pName) {
        this.assertNotClosed();
        return NamePageHash.generateHashForString(pName);
    }

    @Override
    public String nameForKey(int key) {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof PathNode) {
            PathNode node = (PathNode)this.mCurrentNode;
            return this.mPageReadTrx.getName(key, node.getPathKind());
        }
        return "";
    }

    @Override
    public boolean isClosed() {
        return this.mClosed;
    }

    @Override
    public ResourceManager<? extends NodeReadOnlyTrx, ? extends NodeTrx> getResourceManager() {
        this.assertNotClosed();
        return this.mResourceManager;
    }

    public Move<? extends PathSummaryReader> moveToLastChild() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasFirstChild()) {
            this.moveToFirstChild();
            while (this.getStructuralNode().hasRightSibling()) {
                this.moveToRightSibling();
            }
            return Move.moved(this);
        }
        return Move.notMoved();
    }

    public Path<QNm> getPath() {
        PathNode node = this.getPathNode();
        long nodeKey = this.getNodeKey();
        this.moveTo(node.getNodeKey());
        PathNode[] paths = new PathNode[node.getLevel()];
        for (int i = node.getLevel() - 1; i >= 0; --i) {
            paths[i] = node;
            node = this.moveToParent().trx().getPathNode();
        }
        Path path = new Path();
        for (PathNode pathNode : paths) {
            this.moveTo(pathNode.getNodeKey());
            if (pathNode.getPathKind() == Kind.ELEMENT) {
                path.child((Object)this.getName());
                continue;
            }
            path.attribute((Object)this.getName());
        }
        this.moveTo(nodeKey);
        return path;
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        if (this.mCurrentNode instanceof PathNode) {
            PathNode node = (PathNode)this.mCurrentNode;
            helper.add("uri", (Object)this.mPageReadTrx.getName(node.getURIKey(), node.getPathKind()));
            helper.add("prefix", (Object)this.mPageReadTrx.getName(node.getPrefixKey(), node.getPathKind()));
            helper.add("localName", (Object)this.mPageReadTrx.getName(node.getLocalNameKey(), node.getPathKind()));
        }
        helper.add("node", (Object)this.mCurrentNode);
        return helper.toString();
    }

    public int getLevel() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof PathNode) {
            return this.getPathNode().getLevel();
        }
        return 0;
    }

    @Override
    public boolean hasNode(@Nonnegative long key) {
        this.assertNotClosed();
        long currNodeKey = this.mCurrentNode.getNodeKey();
        boolean retVal = this.moveTo(key).hasMoved();
        boolean movedBack = this.moveTo(currNodeKey).hasMoved();
        assert (movedBack) : "moveTo(currNodeKey) must succeed!";
        return retVal;
    }

    @Override
    public boolean hasParent() {
        this.assertNotClosed();
        return this.mCurrentNode.hasParent();
    }

    @Override
    public boolean hasFirstChild() {
        this.assertNotClosed();
        return this.getStructuralNode().hasFirstChild();
    }

    @Override
    public boolean hasLastChild() {
        this.assertNotClosed();
        long nodeKey = this.mCurrentNode.getNodeKey();
        boolean retVal = this.moveToLastChild() != null;
        this.moveTo(nodeKey);
        return retVal;
    }

    @Override
    public boolean hasLeftSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasLeftSibling();
    }

    @Override
    public boolean hasRightSibling() {
        this.assertNotClosed();
        return this.getStructuralNode().hasRightSibling();
    }

    @Override
    public long getNodeKey() {
        this.assertNotClosed();
        return this.mCurrentNode.getNodeKey();
    }

    @Override
    public long getLeftSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getLeftSiblingKey();
    }

    @Override
    public long getRightSiblingKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getRightSiblingKey();
    }

    @Override
    public long getFirstChildKey() {
        this.assertNotClosed();
        return this.getStructuralNode().getFirstChildKey();
    }

    @Override
    public long getLastChildKey() {
        this.assertNotClosed();
        if (this.getStructuralNode().hasFirstChild()) {
            this.moveToFirstChild();
            while (this.getStructuralNode().hasRightSibling()) {
                this.moveToRightSibling();
            }
            return this.mCurrentNode.getNodeKey();
        }
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public long getParentKey() {
        this.assertNotClosed();
        return this.mCurrentNode.getParentKey();
    }

    @Override
    public Kind getKind() {
        this.assertNotClosed();
        return Kind.PATH;
    }

    @Override
    public long getPathNodeKey() {
        this.assertNotClosed();
        return -1L;
    }

    @Override
    public Kind getPathKind() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof PathNode) {
            return ((PathNode)this.mCurrentNode).getPathKind();
        }
        return Kind.NULL;
    }

    @Override
    public long getChildCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getChildCount();
    }

    @Override
    public long getDescendantCount() {
        this.assertNotClosed();
        return this.getStructuralNode().getDescendantCount();
    }

    @Override
    public Kind getFirstChildKind() {
        this.assertNotClosed();
        return Kind.PATH;
    }

    @Override
    public Kind getLastChildKind() {
        this.assertNotClosed();
        return Kind.PATH;
    }

    @Override
    public Kind getLeftSiblingKind() {
        this.assertNotClosed();
        return Kind.PATH;
    }

    @Override
    public Kind getParentKind() {
        this.assertNotClosed();
        if (this.mCurrentNode.getParentKey() == Fixed.DOCUMENT_NODE_KEY.getStandardProperty()) {
            return Kind.XDM_DOCUMENT;
        }
        if (this.mCurrentNode.getParentKey() == Fixed.NULL_NODE_KEY.getStandardProperty()) {
            return Kind.UNKNOWN;
        }
        return Kind.PATH;
    }

    @Override
    public Kind getRightSiblingKind() {
        this.assertNotClosed();
        return Kind.PATH;
    }

    public int getReferences() {
        this.assertNotClosed();
        if (this.mCurrentNode.getKind() == Kind.XDM_DOCUMENT) {
            return 1;
        }
        return this.getPathNode().getReferences();
    }

    @Override
    public boolean isDocumentRoot() {
        this.assertNotClosed();
        return this.mCurrentNode.getKind() == Kind.XDM_DOCUMENT;
    }

    public Move<? extends PathSummaryReader> moveToPrevious() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasLeftSibling()) {
            Move<? extends PathSummaryReader> leftSiblMove = this.moveTo(node.getLeftSiblingKey());
            while (leftSiblMove.trx().hasFirstChild()) {
                leftSiblMove = leftSiblMove.trx().moveToLastChild();
            }
            return leftSiblMove;
        }
        return this.moveTo(node.getParentKey());
    }

    public Move<? extends PathSummaryReader> moveToNext() {
        this.assertNotClosed();
        StructNode node = this.getStructuralNode();
        if (node.hasRightSibling()) {
            return this.moveTo(node.getRightSiblingKey());
        }
        return this.moveToNextFollowing();
    }

    @Override
    public CommitCredentials getCommitCredentials() {
        this.assertNotClosed();
        return this.mPageReadTrx.getCommitCredentials();
    }

    public boolean isNameNode() {
        this.assertNotClosed();
        return this.mCurrentNode instanceof NameNode;
    }

    public int getLocalNameKey() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            return ((NameNode)((Object)this.mCurrentNode)).getLocalNameKey();
        }
        return -1;
    }

    public int getPrefixKey() {
        this.assertNotClosed();
        if (this.mCurrentNode instanceof NameNode) {
            return ((NameNode)((Object)this.mCurrentNode)).getPrefixKey();
        }
        return -1;
    }

    @Override
    public long getHash() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue() {
        throw new UnsupportedOperationException();
    }
}

