/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.io.bytepipe;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sirix.io.bytepipe.ByteHandler;

public final class ByteHandlePipeline
implements ByteHandler {
    private final List<ByteHandler> mParts;

    public ByteHandlePipeline(ByteHandlePipeline pipeline) {
        this.mParts = new ArrayList<ByteHandler>(pipeline.mParts.size());
        for (ByteHandler handler : pipeline.mParts) {
            this.mParts.add(handler.getInstance());
        }
    }

    public ByteHandlePipeline(ByteHandler ... parts) {
        this.mParts = new ArrayList<ByteHandler>();
        if (parts != null) {
            for (ByteHandler part : parts) {
                this.mParts.add(part);
            }
        }
    }

    @Override
    public OutputStream serialize(OutputStream toSerialize) {
        OutputStream pipeData = toSerialize;
        for (ByteHandler part : this.mParts) {
            pipeData = part.serialize(pipeData);
        }
        return pipeData;
    }

    @Override
    public InputStream deserialize(InputStream toDeserialize) {
        InputStream pipeData = toDeserialize;
        for (ByteHandler part : this.mParts) {
            pipeData = part.deserialize(pipeData);
        }
        return pipeData;
    }

    public List<ByteHandler> getComponents() {
        return Collections.unmodifiableList(this.mParts);
    }

    @Override
    public ByteHandler getInstance() {
        return new ByteHandlePipeline(new ByteHandler[0]);
    }
}

