/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnegative;
import org.brackit.xquery.atomic.Atomic;
import org.brackit.xquery.atomic.QNm;
import org.brackit.xquery.xdm.Type;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.index.AtomicUtil;
import org.sirix.index.avltree.AVLNode;
import org.sirix.index.avltree.keyvalue.CASValue;
import org.sirix.index.avltree.keyvalue.NodeReferences;
import org.sirix.index.path.summary.PathNode;
import org.sirix.node.DeletedNode;
import org.sirix.node.DeweyIDMappingNode;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.Utils;
import org.sirix.node.delegates.NameNodeDelegate;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.interfaces.NodePersistenter;
import org.sirix.node.interfaces.Record;
import org.sirix.node.json.ArrayNode;
import org.sirix.node.json.BooleanNode;
import org.sirix.node.json.JsonDocumentRootNode;
import org.sirix.node.json.NullNode;
import org.sirix.node.json.NumberNode;
import org.sirix.node.json.ObjectNode;
import org.sirix.node.json.ObjectRecordNode;
import org.sirix.node.json.StringNode;
import org.sirix.node.xdm.AttributeNode;
import org.sirix.node.xdm.CommentNode;
import org.sirix.node.xdm.ElementNode;
import org.sirix.node.xdm.NamespaceNode;
import org.sirix.node.xdm.PINode;
import org.sirix.node.xdm.TextNode;
import org.sirix.node.xdm.XdmDocumentRootNode;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.settings.Constants;
import org.sirix.settings.Fixed;

public abstract class Kind
extends Enum<Kind>
implements NodePersistenter {
    public static final /* enum */ Kind ELEMENT = new Kind(1, ElementNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            NameNodeDelegate nameDel = Kind.deserializeNameDelegate(nodeDel, source);
            int attrCount = source.readInt();
            ArrayList<Long> attrKeys = new ArrayList<Long>(attrCount);
            HashBiMap attrs = HashBiMap.create();
            for (int i = 0; i < attrCount; ++i) {
                long nodeKey = source.readLong();
                attrKeys.add(nodeKey);
                attrs.put((Object)source.readLong(), (Object)nodeKey);
            }
            int nsCount = source.readInt();
            ArrayList<Long> namespKeys = new ArrayList<Long>(nsCount);
            for (int i = 0; i < nsCount; ++i) {
                namespKeys.add(source.readLong());
            }
            String uri = pageReadTrx.getName(nameDel.getURIKey(), NAMESPACE);
            int prefixKey = nameDel.getPrefixKey();
            String prefix = prefixKey == -1 ? "" : pageReadTrx.getName(prefixKey, ELEMENT);
            int localNameKey = nameDel.getLocalNameKey();
            String localName = localNameKey == -1 ? "" : pageReadTrx.getName(localNameKey, ELEMENT);
            return new ElementNode(structDel, nameDel, attrKeys, (BiMap<Long, Long>)attrs, namespKeys, new QNm(uri, prefix, localName));
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            int i;
            ElementNode node = (ElementNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
            Kind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            sink.writeInt(node.getAttributeCount());
            int attCount = node.getAttributeCount();
            for (i = 0; i < attCount; ++i) {
                long key = node.getAttributeKey(i);
                sink.writeLong(key);
                sink.writeLong(node.getAttributeNameKey(key).get());
            }
            sink.writeInt(node.getNamespaceCount());
            int nspCount = node.getNamespaceCount();
            for (i = 0; i < nspCount; ++i) {
                sink.writeLong(node.getNamespaceKey(i));
            }
        }
    };
    public static final /* enum */ Kind ATTRIBUTE = new Kind(2, AttributeNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            NameNodeDelegate nameDel = Kind.deserializeNameDelegate(nodeDel, source);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.readFully(vals, 0, vals.length);
            ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, vals, isCompressed);
            String uri = pageReadTrx.getName(nameDel.getURIKey(), NAMESPACE);
            int prefixKey = nameDel.getPrefixKey();
            String prefix = prefixKey == -1 ? "" : pageReadTrx.getName(prefixKey, ATTRIBUTE);
            int localNameKey = nameDel.getLocalNameKey();
            String localName = localNameKey == -1 ? "" : pageReadTrx.getName(localNameKey, ATTRIBUTE);
            QNm name = new QNm(uri, prefix, localName);
            return new AttributeNode(nodeDel, nameDel, valDel, name);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            AttributeNode node = (AttributeNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            Kind.serializeValDelegate(node.getValNodeDelegate(), sink);
        }
    };
    public static final /* enum */ Kind NAMESPACE = new Kind(13, NamespaceNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            NameNodeDelegate nameDel = Kind.deserializeNameDelegate(nodeDel, source);
            String uri = pageReadTrx.getName(nameDel.getURIKey(), NAMESPACE);
            int prefixKey = nameDel.getPrefixKey();
            String prefix = prefixKey == -1 ? "" : pageReadTrx.getName(prefixKey, ELEMENT);
            int localNameKey = nameDel.getLocalNameKey();
            String localName = localNameKey == -1 ? "" : pageReadTrx.getName(localNameKey, ELEMENT);
            QNm name = new QNm(uri, prefix, localName);
            return new NamespaceNode(nodeDel, nameDel, name);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            NamespaceNode node = (NamespaceNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
        }
    };
    public static final /* enum */ Kind TEXT = new Kind(3, TextNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.readFully(vals, 0, vals.length);
            ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, vals, isCompressed);
            long nodeKey = nodeDel.getNodeKey();
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), nodeKey - Utils.getVarLong(source), nodeKey - Utils.getVarLong(source), 0L, 0L);
            return new TextNode(valDel, structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            TextNode node = (TextNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeValDelegate(node.getValNodeDelegate(), sink);
            StructNodeDelegate del = node.getStructNodeDelegate();
            long nodeKey = node.getNodeKey();
            Utils.putVarLong(sink, nodeKey - del.getRightSiblingKey());
            Utils.putVarLong(sink, nodeKey - del.getLeftSiblingKey());
        }
    };
    public static final /* enum */ Kind PROCESSING_INSTRUCTION = new Kind(7, PINode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            NameNodeDelegate nameDel = Kind.deserializeNameDelegate(nodeDel, source);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.readFully(vals, 0, vals.length);
            ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, vals, isCompressed);
            return new PINode(structDel, nameDel, valDel, pageReadTrx);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            PINode node = (PINode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
            Kind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            Kind.serializeValDelegate(node.getValNodeDelegate(), sink);
        }
    };
    public static final /* enum */ Kind COMMENT = new Kind(8, CommentNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.readFully(vals, 0, vals.length);
            ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, vals, isCompressed);
            long nodeKey = nodeDel.getNodeKey();
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Fixed.NULL_NODE_KEY.getStandardProperty(), nodeKey - Utils.getVarLong(source), nodeKey - Utils.getVarLong(source), 0L, 0L);
            return new CommentNode(valDel, structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            CommentNode node = (CommentNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeValDelegate(node.getValNodeDelegate(), sink);
            StructNodeDelegate del = node.getStructNodeDelegate();
            long nodeKey = node.getNodeKey();
            Utils.putVarLong(sink, nodeKey - del.getRightSiblingKey());
            Utils.putVarLong(sink, nodeKey - del.getLeftSiblingKey());
        }
    };
    public static final /* enum */ Kind XDM_DOCUMENT = new Kind(9, XdmDocumentRootNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), source.readLong(), Utils.getVarLong(source), SirixDeweyID.newRootID());
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Utils.getVarLong(source), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), source.readByte() == 0 ? 0L : 1L, source.readLong());
            return new XdmDocumentRootNode(nodeDel, structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            XdmDocumentRootNode node = (XdmDocumentRootNode)record;
            sink.writeLong(node.getHash());
            Utils.putVarLong(sink, node.getRevision());
            Utils.putVarLong(sink, node.getFirstChildKey());
            sink.writeByte(node.hasFirstChild() ? 1 : 0);
            sink.writeLong(node.getDescendantCount());
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            return null;
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        }
    };
    public static final /* enum */ Kind WHITESPACE = new Kind(4, null){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            return null;
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        }
    };
    public static final /* enum */ Kind DELETE = new Kind(5, DeletedNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) {
            NodeDelegate delegate = new NodeDelegate(recordID, 0L, 0L, 0L, null);
            return new DeletedNode(delegate);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) {
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            return Optional.empty();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        }
    };
    public static final /* enum */ Kind NULL = new Kind(6, NullNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(DataOutput ink, Record record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            return null;
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        }
    };
    public static final /* enum */ Kind DUMB = new Kind(20, DumbNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) {
            return new DumbNode(recordID);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind ATOMIC = new Kind(15, AtomicValue.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind PATH = new Kind(16, PathNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            NameNodeDelegate nameDel = Kind.deserializeNameDelegate(nodeDel, source);
            return new PathNode(nodeDel, structDel, nameDel, Kind.getKind(source.readByte()), source.readInt(), source.readInt());
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            PathNode node = (PathNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
            Kind.serializeNameDelegate(node.getNameNodeDelegate(), sink);
            sink.writeByte(node.getPathKind().getId());
            sink.writeInt(node.getReferences());
            sink.writeInt(node.getLevel());
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind CASAVL = new Kind(17, AVLNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            int valueSize = source.readInt();
            byte[] value = new byte[valueSize];
            source.readFully(value, 0, valueSize);
            int typeSize = source.readInt();
            byte[] type = new byte[typeSize];
            source.readFully(type, 0, typeSize);
            int keySize = source.readInt();
            HashSet<Long> nodeKeys = new HashSet<Long>(keySize);
            long key = Utils.getVarLong(source);
            nodeKeys.add(key);
            for (int i = 1; i < keySize; ++i) {
                if (i + 1 >= keySize) continue;
                nodeKeys.add(key += Utils.getVarLong(source));
            }
            Type atomicType = this.resolveType(new String(type, Constants.DEFAULT_ENCODING));
            NodeDelegate nodeDel = Kind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            long leftChild = Utils.getVarLong(source);
            long rightChild = Utils.getVarLong(source);
            long pathNodeKey = Utils.getVarLong(source);
            boolean isChanged = source.readBoolean();
            Atomic atomic = AtomicUtil.fromBytes(value, atomicType);
            AVLNode<CASValue, NodeReferences> node = new AVLNode<CASValue, NodeReferences>(new CASValue(atomic, atomicType, pathNodeKey), new NodeReferences(nodeKeys), nodeDel);
            node.setLeftChildKey(leftChild);
            node.setRightChildKey(rightChild);
            node.setChanged(isChanged);
            return node;
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            AVLNode node = (AVLNode)record;
            CASValue key = (CASValue)node.getKey();
            byte[] textValue = key.getValue();
            sink.writeInt(textValue.length);
            sink.write(textValue);
            byte[] type = key.getType().toString().getBytes(Constants.DEFAULT_ENCODING);
            sink.writeInt(type.length);
            sink.write(type);
            NodeReferences value = (NodeReferences)node.getValue();
            Set<Long> nodeKeys = value.getNodeKeys();
            ArrayList<Long> listNodeKeys = new ArrayList<Long>(nodeKeys);
            Collections.sort(listNodeKeys);
            sink.writeInt(listNodeKeys.size());
            Utils.putVarLong(sink, (Long)listNodeKeys.get(0));
            for (int i = 0; i < listNodeKeys.size(); ++i) {
                if (i + 1 >= listNodeKeys.size()) continue;
                long diff = (Long)listNodeKeys.get(i + 1) - (Long)listNodeKeys.get(i);
                Utils.putVarLong(sink, diff);
            }
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Utils.putVarLong(sink, node.getLeftChildKey());
            Utils.putVarLong(sink, node.getRightChildKey());
            Utils.putVarLong(sink, key.getPathNodeKey());
            sink.writeBoolean(node.isChanged());
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        private Type resolveType(String s) {
            QNm name = new QNm("http://www.w3.org/2001/XMLSchema", "xs", s.substring("xs".length() + 1));
            for (Type type : Type.builtInTypes) {
                if (!type.getName().getLocalName().equals(name.getLocalName())) continue;
                return type;
            }
            throw new IllegalStateException("Unknown content type: " + name);
        }
    };
    public static final /* enum */ Kind PATHAVL = new Kind(18, AVLNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            long key = Utils.getVarLong(source);
            int keySize = source.readInt();
            HashSet<Long> nodeKeys = new HashSet<Long>(keySize);
            for (int i = 0; i < keySize; ++i) {
                nodeKeys.add(source.readLong());
            }
            NodeDelegate nodeDel = Kind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            long leftChild = Utils.getVarLong(source);
            long rightChild = Utils.getVarLong(source);
            boolean isChanged = source.readBoolean();
            AVLNode<Long, NodeReferences> node = new AVLNode<Long, NodeReferences>(key, new NodeReferences(nodeKeys), nodeDel);
            node.setLeftChildKey(leftChild);
            node.setRightChildKey(rightChild);
            node.setChanged(isChanged);
            return node;
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            AVLNode node = (AVLNode)record;
            Utils.putVarLong(sink, (Long)node.getKey());
            NodeReferences value = (NodeReferences)node.getValue();
            Set<Long> nodeKeys = value.getNodeKeys();
            sink.writeInt(nodeKeys.size());
            for (long nodeKey : nodeKeys) {
                sink.writeLong(nodeKey);
            }
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Utils.putVarLong(sink, node.getLeftChildKey());
            Utils.putVarLong(sink, node.getRightChildKey());
            sink.writeBoolean(node.isChanged());
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind NAMEAVL = new Kind(19, AVLNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            byte[] nspBytes = new byte[source.readInt()];
            source.readFully(nspBytes);
            byte[] prefixBytes = new byte[source.readInt()];
            source.readFully(prefixBytes);
            byte[] localNameBytes = new byte[source.readInt()];
            source.readFully(localNameBytes);
            QNm name = new QNm(new String(nspBytes, Constants.DEFAULT_ENCODING), new String(prefixBytes, Constants.DEFAULT_ENCODING), new String(localNameBytes, Constants.DEFAULT_ENCODING));
            int keySize = source.readInt();
            HashSet<Long> nodeKeys = new HashSet<Long>(keySize);
            for (int i = 0; i < keySize; ++i) {
                nodeKeys.add(source.readLong());
            }
            NodeDelegate nodeDel = Kind.deserializeNodeDelegateWithoutIDs(source, recordID, pageReadTrx);
            long leftChild = Utils.getVarLong(source);
            long rightChild = Utils.getVarLong(source);
            boolean isChanged = source.readBoolean();
            AVLNode<QNm, NodeReferences> node = new AVLNode<QNm, NodeReferences>(name, new NodeReferences(nodeKeys), nodeDel);
            node.setLeftChildKey(leftChild);
            node.setRightChildKey(rightChild);
            node.setChanged(isChanged);
            return node;
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            AVLNode node = (AVLNode)record;
            byte[] nspBytes = ((QNm)node.getKey()).getNamespaceURI().getBytes();
            sink.writeInt(nspBytes.length);
            sink.write(nspBytes);
            byte[] prefixBytes = ((QNm)node.getKey()).getPrefix().getBytes();
            sink.writeInt(prefixBytes.length);
            sink.write(prefixBytes);
            byte[] localNameBytes = ((QNm)node.getKey()).getLocalName().getBytes();
            sink.writeInt(localNameBytes.length);
            sink.write(localNameBytes);
            NodeReferences value = (NodeReferences)node.getValue();
            Set<Long> nodeKeys = value.getNodeKeys();
            sink.writeInt(nodeKeys.size());
            for (long nodeKey : nodeKeys) {
                sink.writeLong(nodeKey);
            }
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Utils.putVarLong(sink, node.getLeftChildKey());
            Utils.putVarLong(sink, node.getRightChildKey());
            sink.writeBoolean(node.isChanged());
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind DEWEYIDMAPPING = new Kind(23, DeweyIDMappingNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind OBJECT = new Kind(24, ObjectNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            return new ObjectNode(structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            ObjectNode node = (ObjectNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind ARRAY = new Kind(25, ArrayNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            long pathNodeKey = source.readLong();
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            return new ArrayNode(structDel, pathNodeKey);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            ArrayNode node = (ArrayNode)record;
            sink.writeLong(node.getPathNodeKey());
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind OBJECT_RECORD = new Kind(26, ObjectRecordNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            int nameKey = source.readInt();
            long pathNodeKey = Utils.getVarLong(source);
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            String name = nameKey == -1 ? "" : pageReadTrx.getName(nameKey, OBJECT_RECORD);
            return new ObjectRecordNode(structDel, nameKey, name, pathNodeKey);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            ObjectRecordNode node = (ObjectRecordNode)record;
            sink.writeInt(node.getNameKey());
            Utils.putVarLong(sink, node.getPathNodeKey());
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind STRING_VALUE = new Kind(30, StringNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            boolean isCompressed = source.readByte() == 1;
            byte[] vals = new byte[source.readInt()];
            source.readFully(vals, 0, vals.length);
            ValNodeDelegate valDel = new ValNodeDelegate(nodeDel, vals, isCompressed);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            return new StringNode(valDel, structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            StringNode node = (StringNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeValDelegate(node.getValNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind BOOLEAN_VALUE = new Kind(27, BooleanNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            boolean boolValue = source.readBoolean();
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            return new BooleanNode(boolValue, structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            BooleanNode node = (BooleanNode)record;
            sink.writeBoolean(node.getValue());
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind NUMBER_VALUE = new Kind(28, NumberNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            Number number;
            byte valueType = source.readByte();
            switch (valueType) {
                case 0: {
                    number = source.readDouble();
                    break;
                }
                case 1: {
                    number = Float.valueOf(source.readFloat());
                    break;
                }
                case 2: {
                    number = source.readInt();
                    break;
                }
                case 3: {
                    number = source.readLong();
                    break;
                }
                case 4: {
                    number = this.deserializeBigInteger(source);
                    break;
                }
                case 5: {
                    BigInteger bigInt = this.deserializeBigInteger(source);
                    int scale = source.readInt();
                    number = new BigDecimal(bigInt, scale);
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Type not known.");
                }
            }
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            return new NumberNode(number, structDel);
        }

        private BigInteger deserializeBigInteger(DataInput source) throws IOException {
            byte[] bytes = new byte[source.readInt()];
            source.readFully(bytes);
            return new BigInteger(bytes);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            NumberNode node = (NumberNode)record;
            Number number = node.getValue();
            if (number instanceof Double) {
                sink.writeByte(0);
                sink.writeDouble(number.doubleValue());
            } else if (number instanceof Float) {
                sink.writeByte(1);
                sink.writeFloat(number.floatValue());
            } else if (number instanceof Integer) {
                sink.writeByte(2);
                sink.writeInt(number.intValue());
            } else if (number instanceof Long) {
                sink.writeByte(3);
                sink.writeLong(number.longValue());
            } else if (number instanceof BigInteger) {
                sink.writeByte(4);
                this.serializeBigInteger(sink, (BigInteger)number);
            } else if (number instanceof BigDecimal) {
                sink.writeByte(5);
                BigDecimal value = (BigDecimal)number;
                BigInteger bigInt = value.unscaledValue();
                int scale = value.scale();
                this.serializeBigInteger(sink, bigInt);
                sink.writeInt(scale);
            } else {
                throw new AssertionError((Object)"Type not known.");
            }
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        private void serializeBigInteger(DataOutput sink, BigInteger bigInteger) throws IOException {
            byte[] bytes = bigInteger.toByteArray();
            sink.writeInt(bytes.length);
            sink.write(bytes);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind NULL_VALUE = new Kind(29, NullNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = Kind.deserializeNodeDelegate(source, recordID, deweyID, pageReadTrx);
            StructNodeDelegate structDel = Kind.deserializeStructDel(nodeDel, source);
            return new NullNode(structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            NullNode node = (NullNode)record;
            Kind.serializeDelegate(node.getNodeDelegate(), sink);
            Kind.serializeStructDelegate(node.getStructNodeDelegate(), sink);
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    public static final /* enum */ Kind JSON_DOCUMENT = new Kind(31, JsonDocumentRootNode.class){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            NodeDelegate nodeDel = new NodeDelegate(Fixed.DOCUMENT_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), source.readLong(), Utils.getVarLong(source), null);
            StructNodeDelegate structDel = new StructNodeDelegate(nodeDel, Utils.getVarLong(source), Fixed.NULL_NODE_KEY.getStandardProperty(), Fixed.NULL_NODE_KEY.getStandardProperty(), source.readByte() == 0 ? 0L : 1L, source.readLong());
            return new JsonDocumentRootNode(nodeDel, structDel);
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            JsonDocumentRootNode node = (JsonDocumentRootNode)record;
            sink.writeLong(node.getHash());
            Utils.putVarLong(sink, node.getRevision());
            Utils.putVarLong(sink, node.getFirstChildKey());
            sink.writeByte(node.hasFirstChild() ? 1 : 0);
            sink.writeLong(node.getDescendantCount());
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            return null;
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        }
    };
    public static final /* enum */ Kind UNKNOWN = new Kind(22, null){

        @Override
        public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID prevDeweyID, ResourceConfiguration resourceConfig) throws IOException {
            throw new UnsupportedOperationException();
        }
    };
    private final byte mId;
    private final Class<? extends Record> mClass;
    private static final Map<Byte, Kind> INSTANCEFORID;
    private static final Map<Class<? extends Record>, Kind> INSTANCEFORCLASS;
    private static final /* synthetic */ Kind[] $VALUES;

    public static Kind[] values() {
        return (Kind[])$VALUES.clone();
    }

    public static Kind valueOf(String name) {
        return Enum.valueOf(Kind.class, name);
    }

    private Kind(byte id, Class<? extends Record> clazz) {
        this.mId = id;
        this.mClass = clazz;
    }

    public byte getId() {
        return this.mId;
    }

    public Class<? extends Record> getNodeClass() {
        return this.mClass;
    }

    public static Kind getKind(byte id) {
        return INSTANCEFORID.get(id);
    }

    public static Kind getKind(Class<? extends Record> clazz) {
        return INSTANCEFORCLASS.get(clazz);
    }

    @Override
    public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        if (resourceConfig.areDeweyIDsStored) {
            if (previousDeweyID != null) {
                byte[] previousDeweyIDBytes = previousDeweyID.toBytes();
                byte cutOffSize = source.readByte();
                byte size = source.readByte();
                byte[] deweyIDBytes = new byte[size];
                source.readFully(deweyIDBytes);
                byte[] bytes = new byte[cutOffSize + deweyIDBytes.length];
                ByteBuffer target = ByteBuffer.wrap(bytes);
                target.put(Arrays.copyOfRange(previousDeweyIDBytes, 0, (int)cutOffSize));
                target.put(deweyIDBytes);
                return Optional.of(new SirixDeweyID(bytes));
            }
            byte deweyIDLength = source.readByte();
            byte[] deweyIDBytes = new byte[deweyIDLength];
            source.readFully(deweyIDBytes, 0, deweyIDLength);
            return Optional.of(new SirixDeweyID(deweyIDBytes));
        }
        return Optional.empty();
    }

    @Override
    public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID nextDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        if (resourceConfig.areDeweyIDsStored) {
            if (nextDeweyID != null) {
                int i;
                byte[] deweyIDBytes = deweyID.toBytes();
                byte[] nextDeweyIDBytes = nextDeweyID.toBytes();
                assert (deweyIDBytes.length <= nextDeweyIDBytes.length);
                for (i = 0; i < deweyIDBytes.length && deweyIDBytes[i] == nextDeweyIDBytes[i]; ++i) {
                }
                Kind.writeDeweyID(sink, nextDeweyIDBytes, i);
            } else {
                byte[] deweyIDBytes = deweyID.toBytes();
                sink.writeByte(deweyIDBytes.length);
                sink.write(deweyIDBytes);
            }
        }
    }

    private static final NodeDelegate deserializeNodeDelegateWithoutIDs(DataInput source, @Nonnegative long recordID, PageReadOnlyTrx pageReadTrx) throws IOException {
        long nodeKey = recordID;
        long parentKey = nodeKey - Utils.getVarLong(source);
        long hash = source.readLong();
        long revision = Utils.getVarLong(source);
        return new NodeDelegate(nodeKey, parentKey, hash, revision, null);
    }

    private static final NodeDelegate deserializeNodeDelegate(DataInput source, @Nonnegative long recordID, SirixDeweyID id, PageReadOnlyTrx pageReadTrx) throws IOException {
        long nodeKey = recordID;
        long parentKey = nodeKey - Utils.getVarLong(source);
        long hash = source.readLong();
        long revision = Utils.getVarLong(source);
        return new NodeDelegate(nodeKey, parentKey, hash, revision, id);
    }

    private static final void serializeDelegate(NodeDelegate nodeDel, DataOutput sink) throws IOException {
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getParentKey());
        sink.writeLong(nodeDel.getHash());
        Utils.putVarLong(sink, nodeDel.getRevision());
    }

    private static void writeDeweyID(DataOutput sink, byte[] deweyID, @Nonnegative int i) throws IOException {
        sink.writeByte(i);
        sink.writeByte(deweyID.length - i);
        sink.write(Arrays.copyOfRange(deweyID, i, deweyID.length));
    }

    private static final void serializeStructDelegate(StructNodeDelegate nodeDel, DataOutput sink) throws IOException {
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getRightSiblingKey());
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getLeftSiblingKey());
        Utils.putVarLong(sink, nodeDel.getNodeKey() - nodeDel.getFirstChildKey());
        Utils.putVarLong(sink, nodeDel.getChildCount());
        Utils.putVarLong(sink, nodeDel.getDescendantCount() - nodeDel.getChildCount());
    }

    private static final StructNodeDelegate deserializeStructDel(NodeDelegate nodeDel, DataInput source) throws IOException {
        long currKey = nodeDel.getNodeKey();
        long rightSibl = currKey - Utils.getVarLong(source);
        long leftSibl = currKey - Utils.getVarLong(source);
        long firstChild = currKey - Utils.getVarLong(source);
        long childCount = Utils.getVarLong(source);
        long descendantCount = Utils.getVarLong(source) + childCount;
        return new StructNodeDelegate(nodeDel, firstChild, rightSibl, leftSibl, childCount, descendantCount);
    }

    private static final NameNodeDelegate deserializeNameDelegate(NodeDelegate nodeDel, DataInput source) throws IOException {
        int uriKey = source.readInt();
        int prefixKey = source.readInt();
        int localNameKey = source.readInt();
        return new NameNodeDelegate(nodeDel, uriKey, prefixKey, localNameKey, Utils.getVarLong(source));
    }

    private static final void serializeNameDelegate(NameNodeDelegate nameDel, DataOutput sink) throws IOException {
        sink.writeInt(nameDel.getURIKey());
        sink.writeInt(nameDel.getPrefixKey());
        sink.writeInt(nameDel.getLocalNameKey());
        Utils.putVarLong(sink, nameDel.getPathNodeKey());
    }

    private static final void serializeValDelegate(ValNodeDelegate valueDel, DataOutput sink) throws IOException {
        boolean isCompressed = valueDel.isCompressed();
        sink.writeByte(isCompressed ? 1 : 0);
        byte[] value = isCompressed ? valueDel.getCompressed() : valueDel.getRawValue();
        sink.writeInt(value.length);
        sink.write(value);
    }

    static {
        $VALUES = new Kind[]{ELEMENT, ATTRIBUTE, NAMESPACE, TEXT, PROCESSING_INSTRUCTION, COMMENT, XDM_DOCUMENT, WHITESPACE, DELETE, NULL, DUMB, ATOMIC, PATH, CASAVL, PATHAVL, NAMEAVL, DEWEYIDMAPPING, OBJECT, ARRAY, OBJECT_RECORD, STRING_VALUE, BOOLEAN_VALUE, NUMBER_VALUE, NULL_VALUE, JSON_DOCUMENT, UNKNOWN};
        INSTANCEFORID = new HashMap<Byte, Kind>();
        INSTANCEFORCLASS = new HashMap<Class<? extends Record>, Kind>();
        for (Kind node : Kind.values()) {
            INSTANCEFORID.put(node.mId, node);
            INSTANCEFORCLASS.put(node.mClass, node);
        }
    }

    public static class DumbNode
    implements Record {
        private final long mNodeKey;

        public DumbNode(long nodeKey) {
            this.mNodeKey = nodeKey;
        }

        @Override
        public long getNodeKey() {
            return this.mNodeKey;
        }

        @Override
        public Kind getKind() {
            return NULL;
        }

        @Override
        public long getRevision() {
            return 0L;
        }
    }
}

