/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Optional;
import javax.annotation.Nonnegative;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.interfaces.NodePersistenter;
import org.sirix.node.interfaces.Record;

public final class NodePersistenterImpl
implements NodePersistenter {
    @Override
    public Record deserialize(DataInput source, @Nonnegative long recordID, SirixDeweyID deweyID, PageReadOnlyTrx pageReadTrx) throws IOException {
        byte id = source.readByte();
        Kind enumKind = Kind.getKind(id);
        return enumKind.deserialize(source, recordID, deweyID, pageReadTrx);
    }

    @Override
    public void serialize(DataOutput sink, Record record, PageReadOnlyTrx pageReadTrx) throws IOException {
        Kind nodeKind = (Kind)record.getKind();
        byte id = nodeKind.getId();
        sink.writeByte(id);
        nodeKind.serialize(sink, record, pageReadTrx);
    }

    @Override
    public Optional<SirixDeweyID> deserializeDeweyID(DataInput source, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        byte id = source.readByte();
        Kind enumKind = Kind.getKind(id);
        return enumKind.deserializeDeweyID(source, previousDeweyID, resourceConfig);
    }

    @Override
    public void serializeDeweyID(DataOutput sink, Kind nodeKind, SirixDeweyID deweyID, SirixDeweyID previousDeweyID, ResourceConfiguration resourceConfig) throws IOException {
        byte id = nodeKind.getId();
        sink.writeByte(id);
        nodeKind.serializeDeweyID(sink, nodeKind, deweyID, previousDeweyID, resourceConfig);
    }
}

