/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node;

import java.util.Arrays;
import org.sirix.exception.SirixException;
import org.sirix.node.interfaces.SimpleDeweyID;

public class SirixDeweyID
implements Comparable<SirixDeweyID>,
SimpleDeweyID {
    private static final String divisionSeparator = ".";
    private static final int rootNodeDivisionValue = 1;
    private static final String rootNodeDivisionValueStr;
    private static final int attributeRootDivisionValue = 1;
    private static int distanceToSibling;
    private static final int namespaceRootDivisionValue = 0;
    private final int[] divisionValues;
    private final int level;
    private static final byte[] divisionLengthArray;
    private static final boolean[][] bitStringAsBoolean;
    private static final int[] maxDivisionValue;
    private static final int[] completeDivisionLengthArray;
    private static final int[] binaryTreeSuffixInit;
    private static final byte[] binaryTreeSearchArray;

    private final int[] parseDivisionValues(String divisionPart) throws SirixException {
        if (((String)divisionPart).charAt(((String)divisionPart).length() - 1) != '.') {
            divisionPart = (String)divisionPart + divisionSeparator;
        }
        String[] divisions = ((String)divisionPart).split("\\.");
        int[] divisionValues = new int[divisions.length];
        int i = 0;
        for (String division : divisions) {
            try {
                divisionValues[i] = Integer.parseInt(division);
                ++i;
            }
            catch (NumberFormatException e) {
                throw new SirixException("Division " + i + " has an invalid value: " + division, e);
            }
        }
        return divisionValues;
    }

    private int calcLevel(int[] divisionValues) {
        int level = 0;
        for (int i = 0; i < divisionValues.length; ++i) {
            if (divisionValues[i] % 2 != 1) continue;
            ++level;
        }
        return level;
    }

    public SirixDeweyID(byte[] deweyIDbytes) {
        int division = 1;
        int currentLevel = 1;
        int[] tempDivision = new int[10];
        int tempDivisionLength = 0;
        tempDivision[tempDivisionLength++] = 1;
        int binaryTreeSearchIndex = 0;
        boolean prefixBit = true;
        int suffixlength = 0;
        int suffix = 0;
        for (int bitIndex = 0; bitIndex < 8 * deweyIDbytes.length; ++bitIndex) {
            int helpFindingBit;
            switch (bitIndex % 8) {
                case 0: {
                    helpFindingBit = 128;
                    break;
                }
                case 1: {
                    helpFindingBit = 64;
                    break;
                }
                case 2: {
                    helpFindingBit = 32;
                    break;
                }
                case 3: {
                    helpFindingBit = 16;
                    break;
                }
                case 4: {
                    helpFindingBit = 8;
                    break;
                }
                case 5: {
                    helpFindingBit = 4;
                    break;
                }
                case 6: {
                    helpFindingBit = 2;
                    break;
                }
                default: {
                    helpFindingBit = 1;
                }
            }
            if (prefixBit) {
                binaryTreeSearchIndex = (deweyIDbytes[bitIndex / 8] & helpFindingBit) == helpFindingBit ? (binaryTreeSearchIndex << 1) + 2 : (binaryTreeSearchIndex << 1) + 1;
                if (binaryTreeSearchArray.length <= binaryTreeSearchIndex || binaryTreeSearchArray[binaryTreeSearchIndex] == 0) continue;
                prefixBit = false;
                suffixlength = binaryTreeSearchArray[binaryTreeSearchIndex];
                suffix = binaryTreeSuffixInit[binaryTreeSearchIndex];
                continue;
            }
            if ((deweyIDbytes[bitIndex / 8] & helpFindingBit) == helpFindingBit) {
                suffix += 1 << suffixlength - 1;
            }
            if (--suffixlength != 0) continue;
            if (suffix != -1) {
                ++division;
                if (tempDivisionLength == tempDivision.length) {
                    int[] newTempDivision = new int[tempDivisionLength + 5];
                    System.arraycopy(tempDivision, 0, newTempDivision, 0, tempDivisionLength);
                    tempDivision = newTempDivision;
                }
                tempDivision[tempDivisionLength++] = suffix;
                if (suffix % 2 == 1) {
                    ++currentLevel;
                }
            }
            prefixBit = true;
            binaryTreeSearchIndex = 0;
        }
        this.level = currentLevel;
        this.divisionValues = new int[division];
        System.arraycopy(tempDivision, 0, this.divisionValues, 0, division);
    }

    public SirixDeweyID(byte[] deweyIDbytes, int offset, int length) {
        int division = 1;
        int currentLevel = 1;
        int[] tempDivision = new int[10];
        int tempDivisionLength = 0;
        tempDivision[tempDivisionLength++] = 1;
        int binaryTreeSearchIndex = 0;
        boolean prefixBit = true;
        int suffixlength = 0;
        int suffix = 0;
        int end = 8 * length;
        for (int bitIndex = 0; bitIndex < end; ++bitIndex) {
            int helpFindingBit;
            switch (bitIndex % 8) {
                case 0: {
                    helpFindingBit = 128;
                    break;
                }
                case 1: {
                    helpFindingBit = 64;
                    break;
                }
                case 2: {
                    helpFindingBit = 32;
                    break;
                }
                case 3: {
                    helpFindingBit = 16;
                    break;
                }
                case 4: {
                    helpFindingBit = 8;
                    break;
                }
                case 5: {
                    helpFindingBit = 4;
                    break;
                }
                case 6: {
                    helpFindingBit = 2;
                    break;
                }
                default: {
                    helpFindingBit = 1;
                }
            }
            if (prefixBit) {
                binaryTreeSearchIndex = (deweyIDbytes[offset + bitIndex / 8] & helpFindingBit) == helpFindingBit ? 2 * binaryTreeSearchIndex + 2 : 2 * binaryTreeSearchIndex + 1;
                if (binaryTreeSearchArray.length <= binaryTreeSearchIndex || binaryTreeSearchArray[binaryTreeSearchIndex] == 0) continue;
                prefixBit = false;
                suffixlength = binaryTreeSearchArray[binaryTreeSearchIndex];
                suffix = binaryTreeSuffixInit[binaryTreeSearchIndex];
                continue;
            }
            if ((deweyIDbytes[offset + bitIndex / 8] & helpFindingBit) == helpFindingBit) {
                suffix += 1 << suffixlength - 1;
            }
            if (--suffixlength != 0) continue;
            if (suffix != -1) {
                ++division;
                if (tempDivisionLength == tempDivision.length) {
                    int[] newTempDivision = new int[tempDivisionLength + 5];
                    System.arraycopy(tempDivision, 0, newTempDivision, 0, tempDivisionLength);
                    tempDivision = newTempDivision;
                }
                tempDivision[tempDivisionLength++] = suffix;
                if (suffix % 2 == 1) {
                    ++currentLevel;
                }
            }
            prefixBit = true;
            binaryTreeSearchIndex = 0;
        }
        this.level = currentLevel;
        this.divisionValues = new int[division];
        System.arraycopy(tempDivision, 0, this.divisionValues, 0, division);
    }

    public SirixDeweyID(int[] divisionValues) {
        this.divisionValues = Arrays.copyOf(divisionValues, divisionValues.length);
        this.level = this.calcLevel(this.divisionValues);
    }

    public SirixDeweyID(int[] divisionValues, int level) {
        this.divisionValues = Arrays.copyOf(divisionValues, divisionValues.length);
        this.level = level;
    }

    public SirixDeweyID(int length, int[] divisionValues) {
        this.divisionValues = Arrays.copyOf(divisionValues, length);
        this.level = this.calcLevel(this.divisionValues);
    }

    public SirixDeweyID(int length, int[] divisionValues, int level) {
        this.divisionValues = Arrays.copyOf(divisionValues, length);
        this.level = level;
    }

    public SirixDeweyID(SirixDeweyID deweyID, int extraDivisionValue) {
        this.divisionValues = new int[deweyID.divisionValues.length + 1];
        this.level = deweyID.level + 1;
        System.arraycopy(deweyID.divisionValues, 0, this.divisionValues, 0, deweyID.divisionValues.length);
        this.divisionValues[this.divisionValues.length - 1] = extraDivisionValue;
    }

    public SirixDeweyID(String deweyID) throws SirixException {
        this.divisionValues = this.parseDivisionValues(deweyID);
        this.level = this.calcLevel(this.divisionValues);
    }

    public int getLevel() {
        return this.level - 1;
    }

    @Override
    public int getNumberOfDivisions() {
        return this.divisionValues.length;
    }

    @Override
    public int[] getDivisionValues() {
        return this.divisionValues;
    }

    public int getDivisionValue(int division) throws SirixException {
        if (division >= this.divisionValues.length) {
            throw new SirixException("Invalid division: " + division);
        }
        return this.divisionValues[division];
    }

    private int getDivisionBits(int division) {
        if (this.divisionValues[division] <= maxDivisionValue[0]) {
            return completeDivisionLengthArray[0];
        }
        if (this.divisionValues[division] <= maxDivisionValue[1]) {
            return completeDivisionLengthArray[1];
        }
        if (this.divisionValues[division] <= maxDivisionValue[2]) {
            return completeDivisionLengthArray[2];
        }
        if (this.divisionValues[division] <= maxDivisionValue[3]) {
            return completeDivisionLengthArray[3];
        }
        if (this.divisionValues[division] <= maxDivisionValue[4]) {
            return completeDivisionLengthArray[4];
        }
        if (this.divisionValues[division] <= maxDivisionValue[5]) {
            return completeDivisionLengthArray[5];
        }
        if (this.divisionValues[division] <= maxDivisionValue[6]) {
            return completeDivisionLengthArray[6];
        }
        if (this.divisionValues[division] <= maxDivisionValue[7]) {
            return completeDivisionLengthArray[7];
        }
        return completeDivisionLengthArray[8];
    }

    private final int setDivisionBitArray(int[] divisionValues, byte[] byteArray, int division, int bitIndex) {
        int i;
        int suffix;
        boolean[] prefix;
        byte prefixLength;
        int divisionSize = this.getDivisionBits(division);
        if (divisionValues[division] <= maxDivisionValue[0]) {
            prefixLength = divisionLengthArray[0];
            prefix = bitStringAsBoolean[0];
            suffix = divisionValues[division] + 1;
        } else if (divisionValues[division] <= maxDivisionValue[1]) {
            prefixLength = divisionLengthArray[1];
            prefix = bitStringAsBoolean[1];
            suffix = divisionValues[division] - maxDivisionValue[0] - 1;
        } else if (divisionValues[division] <= maxDivisionValue[2]) {
            prefixLength = divisionLengthArray[2];
            prefix = bitStringAsBoolean[2];
            suffix = divisionValues[division] - maxDivisionValue[1] - 1;
        } else if (divisionValues[division] <= maxDivisionValue[3]) {
            prefixLength = divisionLengthArray[3];
            prefix = bitStringAsBoolean[3];
            suffix = divisionValues[division] - maxDivisionValue[2] - 1;
        } else if (divisionValues[division] <= maxDivisionValue[4]) {
            prefixLength = divisionLengthArray[4];
            prefix = bitStringAsBoolean[4];
            suffix = divisionValues[division] - maxDivisionValue[3] - 1;
        } else if (divisionValues[division] <= maxDivisionValue[5]) {
            prefixLength = divisionLengthArray[5];
            prefix = bitStringAsBoolean[5];
            suffix = divisionValues[division] - maxDivisionValue[4] - 1;
        } else if (divisionValues[division] <= maxDivisionValue[6]) {
            prefixLength = divisionLengthArray[6];
            prefix = bitStringAsBoolean[6];
            suffix = divisionValues[division] - maxDivisionValue[5] - 1;
        } else if (divisionValues[division] <= maxDivisionValue[7]) {
            prefixLength = divisionLengthArray[7];
            prefix = bitStringAsBoolean[7];
            suffix = divisionValues[division] - maxDivisionValue[6] - 1;
        } else {
            prefixLength = divisionLengthArray[8];
            prefix = bitStringAsBoolean[8];
            suffix = divisionValues[division] - maxDivisionValue[7] - 1;
        }
        for (i = 0; i < prefix.length; ++i) {
            if (prefix[i]) {
                switch (bitIndex % 8) {
                    case 0: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x80);
                        break;
                    }
                    case 1: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x40);
                        break;
                    }
                    case 2: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x20);
                        break;
                    }
                    case 3: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x10);
                        break;
                    }
                    case 4: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 8);
                        break;
                    }
                    case 5: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 4);
                        break;
                    }
                    case 6: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 2);
                        break;
                    }
                    case 7: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 1);
                    }
                }
            }
            ++bitIndex;
        }
        for (i = 1; i <= divisionSize - prefix.length; ++i) {
            int k = 1;
            if (suffix >= (k <<= divisionSize - prefix.length - i)) {
                suffix -= k;
                switch (bitIndex % 8) {
                    case 0: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x80);
                        break;
                    }
                    case 1: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x40);
                        break;
                    }
                    case 2: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x20);
                        break;
                    }
                    case 3: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 0x10);
                        break;
                    }
                    case 4: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 8);
                        break;
                    }
                    case 5: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 4);
                        break;
                    }
                    case 6: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 2);
                        break;
                    }
                    case 7: {
                        int n = bitIndex / 8;
                        byteArray[n] = (byte)(byteArray[n] | 1);
                    }
                }
            }
            ++bitIndex;
        }
        return bitIndex;
    }

    public byte[] toBytes() {
        return this.toBytes(this.divisionValues);
    }

    public byte[] toAttributeRootBytes() {
        int[] attRootDivisions = Arrays.copyOf(this.divisionValues, this.divisionValues.length + 1);
        attRootDivisions[attRootDivisions.length - 1] = 1;
        return this.toBytes(attRootDivisions);
    }

    private byte[] toBytes(int[] divisionValues) {
        int numberOfDivisionBits = 0;
        for (int i = 1; i < divisionValues.length; ++i) {
            if (divisionValues[i] <= maxDivisionValue[0]) {
                numberOfDivisionBits += completeDivisionLengthArray[0];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[1]) {
                numberOfDivisionBits += completeDivisionLengthArray[1];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[2]) {
                numberOfDivisionBits += completeDivisionLengthArray[2];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[3]) {
                numberOfDivisionBits += completeDivisionLengthArray[3];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[4]) {
                numberOfDivisionBits += completeDivisionLengthArray[4];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[5]) {
                numberOfDivisionBits += completeDivisionLengthArray[5];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[6]) {
                numberOfDivisionBits += completeDivisionLengthArray[6];
                continue;
            }
            if (divisionValues[i] <= maxDivisionValue[7]) {
                numberOfDivisionBits += completeDivisionLengthArray[7];
                continue;
            }
            numberOfDivisionBits += completeDivisionLengthArray[8];
        }
        byte[] deweyIDbytes = numberOfDivisionBits % 8 == 0 ? new byte[numberOfDivisionBits / 8] : new byte[numberOfDivisionBits / 8 + 1];
        int bitIndex = 0;
        for (int i = 1; i < this.divisionValues.length; ++i) {
            bitIndex = this.setDivisionBitArray(divisionValues, deweyIDbytes, i, bitIndex);
        }
        return deweyIDbytes;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < this.divisionValues.length; ++i) {
            if (i != 0) {
                out.append(divisionSeparator);
            }
            out.append(this.divisionValues[i]);
        }
        return out.toString();
    }

    @Override
    public int compareTo(SirixDeweyID deweyID) {
        if (this == deweyID) {
            return 0;
        }
        int[] myD = this.divisionValues;
        int myLen = myD.length;
        int[] oD = deweyID.divisionValues;
        int oLen = oD.length;
        int len = myLen <= oLen ? myLen : oLen;
        int pos = -1;
        while (++pos < len) {
            if (myD[pos] == oD[pos]) continue;
            return myD[pos] - oD[pos];
        }
        return myLen == oLen ? 0 : (myLen < oLen ? -1 : 1);
    }

    public boolean equals(Object object) {
        return object instanceof SirixDeweyID && this.compareTo((SirixDeweyID)object) == 0;
    }

    public static int compare(byte[] deweyID1, byte[] deweyID2) {
        int length1 = deweyID1.length;
        int length2 = deweyID2.length;
        int length = length1 <= length2 ? length1 : length2;
        int pos = -1;
        while (++pos < length) {
            int v1 = deweyID1[pos] & 0xFF;
            int v2 = deweyID2[pos] & 0xFF;
            if (v1 == v2) continue;
            return v1 - v2;
        }
        return length1 - length2;
    }

    public static int compareAsPrefix(byte[] deweyID1, byte[] deweyID2) {
        int length1 = deweyID1.length;
        int length2 = deweyID2.length;
        int length = length1 <= length2 ? length1 : length2;
        int pos = -1;
        while (++pos < length) {
            int v1 = deweyID1[pos] & 0xFF;
            int v2 = deweyID2[pos] & 0xFF;
            if (v1 == v2) continue;
            return v1 - v2;
        }
        return length1 <= length2 ? 0 : 1;
    }

    public boolean isSelfOf(SirixDeweyID deweyID) {
        return this.compareTo(deweyID) == 0;
    }

    public boolean isAttributeOf(SirixDeweyID deweyID) {
        int[] oD = deweyID.divisionValues;
        int oLen = oD.length;
        int[] myD = this.divisionValues;
        int myLen = myD.length;
        if (oLen != myLen - 2) {
            return false;
        }
        int len = oLen;
        int pos = -1;
        while (++pos < len) {
            if (myD[pos] == oD[pos]) continue;
            return false;
        }
        return myD[myLen - 2] == 1 && myD[myLen - 1] % 2 != 0;
    }

    public boolean isAncestorOf(SirixDeweyID deweyID) {
        int[] myD = this.divisionValues;
        int myLen = myD.length;
        int[] oD = deweyID.divisionValues;
        int oLen = oD.length;
        if (myLen >= oLen) {
            return false;
        }
        int len = myLen;
        int pos = -1;
        while (++pos < len) {
            if (myD[pos] == oD[pos]) continue;
            return false;
        }
        return true;
    }

    public boolean isAncestorOrSelfOf(SirixDeweyID deweyID) {
        int[] myD = this.divisionValues;
        int myLen = myD.length;
        int[] oD = deweyID.divisionValues;
        int oLen = oD.length;
        if (myLen > oLen) {
            return false;
        }
        int len = myLen;
        int pos = -1;
        while (++pos < len) {
            if (myD[pos] == oD[pos]) continue;
            return false;
        }
        return true;
    }

    public boolean isParentOf(SirixDeweyID deweyID) {
        int[] myD = this.divisionValues;
        int myLen = myD.length;
        int[] oD = deweyID.divisionValues;
        int oLen = oD.length;
        if (myLen - oLen != -1 && (myLen != oLen - 2 || oD[oLen - 2] != 1)) {
            return false;
        }
        int len = myLen;
        int pos = -1;
        while (++pos < len) {
            if (myD[pos] == oD[pos]) continue;
            return false;
        }
        return true;
    }

    public boolean isPrecedingSiblingOf(SirixDeweyID deweyID) {
        if (!this.isSiblingOf(deweyID)) {
            return false;
        }
        int myLen = this.divisionValues.length;
        int oLen = deweyID.divisionValues.length;
        int checkPos = Math.min(myLen - 1, oLen - 1);
        return this.divisionValues[checkPos] < deweyID.divisionValues[checkPos];
    }

    public boolean isPrecedingOf(SirixDeweyID deweyID) {
        return this.compareTo(deweyID) < 0 && !this.isAncestorOf(deweyID);
    }

    public boolean isSiblingOf(SirixDeweyID deweyID) {
        int oP;
        if (this.level == 0 || deweyID.level == 0 || this.level != deweyID.level) {
            return false;
        }
        int[] myD = this.divisionValues;
        int[] oD = deweyID.divisionValues;
        int myP = 0;
        for (oP = 0; myP < myD.length - 1 && oP < oD.length - 1; ++myP, ++oP) {
            if (myD[myP] == oD[oP]) {
                continue;
            }
            if (myD[myP] % 2 == 0 || oD[oP] % 2 == 0) {
                while (myD[myP] % 2 == 0) {
                    ++myP;
                }
                while (oD[oP] % 2 == 0) {
                    ++oP;
                }
                int rLenDiff = myD.length - myP - (oD.length - oP);
                return rLenDiff == 0;
            }
            return false;
        }
        return myD[myP] != 1 && oD[oP] != 1 && myD[myP] != oD[oP];
    }

    public boolean isFollowingSiblingOf(SirixDeweyID deweyID) {
        if (!this.isSiblingOf(deweyID)) {
            return false;
        }
        int myLen = this.divisionValues.length;
        int oLen = deweyID.divisionValues.length;
        int checkPos = Math.min(myLen - 1, oLen - 1);
        return this.divisionValues[checkPos] > deweyID.divisionValues[checkPos];
    }

    public boolean isFollowingOf(SirixDeweyID deweyID) {
        return this.compareTo(deweyID) > 0 && !this.isAncestorOf(deweyID) && !deweyID.isAncestorOf(this);
    }

    public boolean isChildOf(SirixDeweyID deweyID) {
        return deweyID.isParentOf(this);
    }

    public boolean isDescendantOf(SirixDeweyID deweyID) {
        return deweyID.isAncestorOf(this);
    }

    public boolean isDescendantOrSelfOf(SirixDeweyID deweyID) {
        return deweyID.isAncestorOrSelfOf(this);
    }

    @Override
    public boolean isAttribute() {
        return this.level > 1 && this.divisionValues.length > 2 && this.divisionValues[this.divisionValues.length - 2] == 1;
    }

    public boolean isAttributeRoot() {
        return this.level > 1 && this.divisionValues.length > 1 && this.divisionValues[this.divisionValues.length - 1] == 1;
    }

    public SirixDeweyID getAncestor(int level) {
        if (this.level == level) {
            return this;
        }
        if (this.level < level) {
            return null;
        }
        int currDivision = 0;
        for (int i = 0; i < level; ++i) {
            while (this.divisionValues[currDivision] % 2 == 0) {
                ++currDivision;
            }
            ++currDivision;
        }
        SirixDeweyID newID = new SirixDeweyID(Arrays.copyOf(this.divisionValues, currDivision), level);
        return newID;
    }

    public SirixDeweyID getAncestor(int level, SirixDeweyID requiredPrefix) {
        if (this.level < level) {
            return null;
        }
        int currDivision = 0;
        for (int i = 0; i < level; ++i) {
            while (this.divisionValues[currDivision] % 2 == 0) {
                if (currDivision < requiredPrefix.divisionValues.length && this.divisionValues[currDivision] != requiredPrefix.divisionValues[currDivision]) {
                    return null;
                }
                ++currDivision;
            }
            if (currDivision < requiredPrefix.divisionValues.length && this.divisionValues[currDivision] != requiredPrefix.divisionValues[currDivision]) {
                return null;
            }
            ++currDivision;
        }
        if (this.level == level) {
            return this;
        }
        return new SirixDeweyID(Arrays.copyOf(this.divisionValues, currDivision), level);
    }

    public SirixDeweyID[] getAncestors() {
        if (this.level == 0) {
            return null;
        }
        SirixDeweyID id = this;
        SirixDeweyID[] ancestors = new SirixDeweyID[this.level];
        for (int i = this.level; i > 0; --i) {
            ancestors[i - 1] = id.getParent();
            id = id.getParent();
        }
        return ancestors;
    }

    public SirixDeweyID[] getAncestors(SirixDeweyID lca) {
        if (!lca.isAncestorOf(this)) {
            return null;
        }
        SirixDeweyID id = this;
        SirixDeweyID[] ancestors = new SirixDeweyID[this.level - lca.getLevel() - 1];
        for (int i = ancestors.length; i > 0; --i) {
            ancestors[i - 1] = id.getParent();
            id = id.getParent();
        }
        return ancestors;
    }

    public boolean isLCA(SirixDeweyID id) {
        return this.getLCA(id).compareTo(id) == 0;
    }

    public SirixDeweyID getLCA(SirixDeweyID id) {
        int common_length = 0;
        int length = Math.min(this.divisionValues.length, id.divisionValues.length);
        for (int i = 0; i < length && id.divisionValues[i] == this.divisionValues[i]; ++i) {
            ++common_length;
        }
        while (this.divisionValues[common_length - 1] % 2 == 0) {
            --common_length;
        }
        return new SirixDeweyID(Arrays.copyOf(this.divisionValues, common_length));
    }

    public int calcLCALevel(SirixDeweyID id) {
        int lcaLevel = 0;
        int a = this.divisionValues.length;
        int b = id.divisionValues.length;
        int maxPos = a <= b ? a : b;
        for (int i = 0; i < maxPos && id.divisionValues[i] == this.divisionValues[i]; ++i) {
            if (this.divisionValues[i] % 2 == 0) continue;
            ++lcaLevel;
        }
        return lcaLevel;
    }

    public SirixDeweyID getParent() {
        int i;
        if (this.level == 0) {
            return null;
        }
        for (i = this.divisionValues.length - 2; i >= 0 && this.divisionValues[i] % 2 == 0; --i) {
        }
        SirixDeweyID parent = new SirixDeweyID(Arrays.copyOf(this.divisionValues, i + 1), this.level - 1);
        return parent;
    }

    public int hashCode() {
        return Arrays.hashCode(this.divisionValues);
    }

    public static SirixDeweyID newBetween(SirixDeweyID deweyID1, SirixDeweyID deweyID2) throws SirixException {
        int j;
        int[] divisionValues;
        if (deweyID1 == null && deweyID2 != null) {
            int j2;
            int[] divisionValues2;
            int divisions;
            int i;
            for (i = deweyID2.divisionValues.length - 2; i >= 0 && deweyID2.divisionValues[i] % 2 == 0; --i) {
            }
            ++i;
            while (deweyID2.divisionValues[i] == 2) {
                ++i;
            }
            if (deweyID2.divisionValues[i] % 2 == 1 && deweyID2.divisionValues[i] > 3) {
                divisions = deweyID2.getNumberOfDivisions();
                divisionValues2 = new int[divisions];
                for (j2 = 0; j2 < divisions - 1; ++j2) {
                    divisionValues2[j2] = deweyID2.divisionValues[j2];
                }
                divisionValues2[divisions - 1] = deweyID2.divisionValues[divisions - 1] / 2;
                if (divisionValues2[divisions - 1] % 2 == 0) {
                    int n = divisions - 1;
                    divisionValues2[n] = divisionValues2[n] + 1;
                }
            } else if (deweyID2.divisionValues[i] == 3) {
                divisions = deweyID2.getNumberOfDivisions() + 1;
                divisionValues2 = new int[divisions];
                for (j2 = 0; j2 < divisions - 1; ++j2) {
                    divisionValues2[j2] = deweyID2.divisionValues[j2];
                }
                divisionValues2[i] = 2;
                divisionValues2[i + 1] = distanceToSibling + 1;
            } else {
                divisions = i + 1;
                divisionValues2 = new int[divisions];
                for (j2 = 0; j2 < divisions - 1; ++j2) {
                    divisionValues2[j2] = deweyID2.divisionValues[j2];
                }
                divisionValues2[i] = deweyID2.divisionValues[i] / 2;
                if (divisionValues2[i] % 2 == 0) {
                    int n = i;
                    divisionValues2[n] = divisionValues2[n] + 1;
                }
            }
            SirixDeweyID newID = new SirixDeweyID(Arrays.copyOf(divisionValues2, divisions), deweyID2.level);
            return newID;
        }
        if (deweyID1 != null && deweyID2 == null) {
            int[] tmp = Arrays.copyOf(deweyID1.divisionValues, deweyID1.divisionValues.length);
            int n = tmp.length - 1;
            tmp[n] = tmp[n] + distanceToSibling;
            SirixDeweyID newID = new SirixDeweyID(tmp, deweyID1.level);
            return newID;
        }
        if (deweyID1.compareTo(deweyID2) >= 0) {
            throw new SirixException("XTCdeweyID [newBetween]: deweyID1 is greater or equal to deweyID2");
        }
        if (deweyID1.getParent().compareTo(deweyID2.getParent()) != 0) {
            throw new SirixException("XTCdeweyID [newBetween]: deweyID1 and deweyID2 are no siblings");
        }
        int i = 0;
        while (deweyID1.divisionValues[i] == deweyID2.divisionValues[i]) {
            ++i;
        }
        if (deweyID2.divisionValues[i] - deweyID1.divisionValues[i] > 2) {
            int divisions = i + 1;
            divisionValues = new int[divisions];
            for (j = 0; j < divisions - 1; ++j) {
                divisionValues[j] = deweyID1.divisionValues[j];
            }
            divisionValues[divisions - 1] = deweyID1.divisionValues[divisions - 1] + (deweyID2.divisionValues[divisions - 1] - deweyID1.divisionValues[divisions - 1]) / 2;
            if (divisionValues[divisions - 1] % 2 == 0) {
                int n = divisions - 1;
                divisionValues[n] = divisionValues[n] - 1;
            }
        } else if (deweyID2.divisionValues[i] - deweyID1.divisionValues[i] == 2) {
            if (deweyID2.divisionValues[i] % 2 == 0) {
                int divisions = i + 1;
                divisionValues = new int[divisions];
                for (j = 0; j < divisions - 1; ++j) {
                    divisionValues[j] = deweyID1.divisionValues[j];
                }
                divisionValues[divisions - 1] = deweyID1.divisionValues[divisions - 1] + 1;
            } else {
                int divisions = i + 2;
                divisionValues = new int[divisions];
                for (j = 0; j < divisions - 1; ++j) {
                    divisionValues[j] = deweyID1.divisionValues[j];
                }
                int n = divisions - 2;
                divisionValues[n] = divisionValues[n] + 1;
                divisionValues[divisions - 1] = distanceToSibling + 1;
            }
        } else if (deweyID1.divisionValues[i] % 2 == 1) {
            ++i;
            while (deweyID2.divisionValues[i] == 2) {
                ++i;
            }
            if (deweyID2.divisionValues[i] == 3) {
                int divisions = i + 2;
                divisionValues = new int[divisions];
                for (j = 0; j < divisions - 2; ++j) {
                    divisionValues[j] = deweyID2.divisionValues[j];
                }
                divisionValues[divisions - 2] = 2;
                divisionValues[divisions - 1] = distanceToSibling + 1;
            } else {
                int divisions = i + 1;
                divisionValues = new int[divisions];
                for (j = 0; j < divisions; ++j) {
                    divisionValues[j] = deweyID2.divisionValues[j];
                }
                int n = divisions - 1;
                divisionValues[n] = divisionValues[n] / 2;
                if (divisionValues[divisions - 1] % 2 == 0) {
                    int n2 = divisions - 1;
                    divisionValues[n2] = divisionValues[n2] + 1;
                }
            }
        } else {
            int divisions = ++i + 1;
            divisionValues = new int[divisions];
            for (j = 0; j < divisions; ++j) {
                divisionValues[j] = deweyID1.divisionValues[j];
            }
            if (deweyID1.divisionValues[i] % 2 == 1) {
                int n = divisions - 1;
                divisionValues[n] = divisionValues[n] + distanceToSibling;
            } else {
                int n = divisions - 1;
                divisionValues[n] = divisionValues[n] + (distanceToSibling - 1);
            }
        }
        SirixDeweyID newID = new SirixDeweyID(divisionValues, deweyID1.level);
        return newID;
    }

    public static final SirixDeweyID newRootID() {
        return new SirixDeweyID(new int[]{1}, 1);
    }

    public final SirixDeweyID getNewChildID() {
        return this.level > 0 ? new SirixDeweyID(this, distanceToSibling + 1) : new SirixDeweyID(this, 1);
    }

    public final SirixDeweyID getNewChildID(int division) {
        return new SirixDeweyID(this, division);
    }

    public final SirixDeweyID getNewAttributeID() {
        int[] childDivisions = Arrays.copyOf(this.divisionValues, this.divisionValues.length + 2);
        childDivisions[this.divisionValues.length] = 1;
        childDivisions[this.divisionValues.length + 1] = distanceToSibling + 1;
        SirixDeweyID newID = new SirixDeweyID(childDivisions, this.level + 1);
        return newID;
    }

    public final SirixDeweyID getNewNamespaceID() {
        int[] childDivisions = Arrays.copyOf(this.divisionValues, this.divisionValues.length + 2);
        childDivisions[this.divisionValues.length] = 0;
        childDivisions[this.divisionValues.length + 1] = distanceToSibling + 1;
        SirixDeweyID newID = new SirixDeweyID(childDivisions, this.level + 1);
        return newID;
    }

    public final SirixDeweyID getAttributeRootID() {
        return new SirixDeweyID(this, 1);
    }

    public static String getDivisionLengths() {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < divisionLengthArray.length; ++i) {
            output.append(divisionLengthArray[i] + " ");
        }
        return new String(output);
    }

    public static String getPrefixes() {
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < bitStringAsBoolean.length; ++i) {
            for (int j = 0; j < bitStringAsBoolean[i].length; ++j) {
                output.append(bitStringAsBoolean[i][j] + " ");
            }
            output.append(";");
        }
        return new String(output);
    }

    public StringBuffer list() {
        StringBuffer output = new StringBuffer();
        output.append(this.toString());
        output.append("\t");
        byte[] byteArray = this.toBytes();
        for (int i = 0; i < byteArray.length; ++i) {
            output.append(byteArray[i] + "\t");
        }
        output.append("");
        for (int bitIndex = 0; bitIndex < 8 * byteArray.length; ++bitIndex) {
            int helpFindingBit;
            switch (bitIndex % 8) {
                case 0: {
                    helpFindingBit = 128;
                    break;
                }
                case 1: {
                    helpFindingBit = 64;
                    break;
                }
                case 2: {
                    helpFindingBit = 32;
                    break;
                }
                case 3: {
                    helpFindingBit = 16;
                    break;
                }
                case 4: {
                    helpFindingBit = 8;
                    break;
                }
                case 5: {
                    helpFindingBit = 4;
                    break;
                }
                case 6: {
                    helpFindingBit = 2;
                    break;
                }
                default: {
                    helpFindingBit = 1;
                }
            }
            if ((byteArray[bitIndex / 8] & helpFindingBit) != helpFindingBit) continue;
        }
        return output;
    }

    public boolean equals(SirixDeweyID other) {
        return this.compareTo(other) == 0;
    }

    public boolean isRoot() {
        return this.level == 1;
    }

    public boolean isDocument() {
        return this.level == 0;
    }

    public boolean isPrefixOf(SirixDeweyID other) {
        if (other.divisionValues.length < this.divisionValues.length) {
            return false;
        }
        for (int i = 0; i < this.divisionValues.length; ++i) {
            if (this.divisionValues[i] == other.divisionValues[i]) continue;
            return false;
        }
        return true;
    }

    public int compareReduced(SirixDeweyID deweyID) {
        if (this == deweyID) {
            return 0;
        }
        int[] myD = this.divisionValues;
        int myLen = myD.length;
        int[] oD = deweyID.divisionValues;
        int oLen = oD.length;
        int len = myLen <= oLen ? myLen : oLen;
        int pos = -1;
        while (++pos < len) {
            if (myD[pos] == oD[pos]) continue;
            return myD[pos] - oD[pos];
        }
        return myLen == oLen ? 0 : (myLen < oLen ? -1 : 1);
    }

    public int compareParentTo(SirixDeweyID other) {
        int parentLength = this.divisionValues.length - 1;
        while (this.divisionValues[parentLength - 1] % 2 == 0) {
            --parentLength;
        }
        int upperBound = Math.min(parentLength, other.divisionValues.length);
        for (int i = 0; i < upperBound; ++i) {
            if (this.divisionValues[i] == other.divisionValues[i]) continue;
            return this.divisionValues[i] < other.divisionValues[i] ? -1 : 1;
        }
        return Integer.signum(parentLength - other.divisionValues.length);
    }

    public boolean isPrefixOrGreater(SirixDeweyID other) {
        int upperBound = this.divisionValues.length <= other.divisionValues.length ? this.divisionValues.length : other.divisionValues.length;
        for (int i = 0; i < upperBound; ++i) {
            if (this.divisionValues[i] == other.divisionValues[i]) continue;
            return this.divisionValues[i] > other.divisionValues[i];
        }
        return true;
    }

    public boolean isPrefixOrGreater(int extraDivision, SirixDeweyID other) {
        boolean isShorter = this.divisionValues.length < other.divisionValues.length;
        int upperBound = isShorter ? this.divisionValues.length : other.divisionValues.length;
        for (int i = 0; i < upperBound; ++i) {
            if (this.divisionValues[i] == other.divisionValues[i]) continue;
            return this.divisionValues[i] > other.divisionValues[i];
        }
        if (isShorter && extraDivision != other.divisionValues[upperBound]) {
            return extraDivision > other.divisionValues[upperBound];
        }
        return true;
    }

    static {
        int i;
        rootNodeDivisionValueStr = Integer.toString(1);
        distanceToSibling = 2;
        divisionLengthArray = new byte[]{7, 14, 21, 28, 31};
        bitStringAsBoolean = new boolean[][]{{false}, {true, false}, {true, true, false}, {true, true, true, false}, {true, true, true, true}};
        maxDivisionValue = new int[divisionLengthArray.length];
        completeDivisionLengthArray = new int[divisionLengthArray.length];
        for (int i2 = 0; i2 < divisionLengthArray.length; ++i2) {
            SirixDeweyID.maxDivisionValue[i2] = 1 << divisionLengthArray[i2];
            if (i2 == 0) {
                int n = i2;
                maxDivisionValue[n] = maxDivisionValue[n] - 1;
            }
            if (i2 == 0) {
                int n = i2;
                maxDivisionValue[n] = maxDivisionValue[n] - 1;
            }
            if (i2 == 0) continue;
            if (maxDivisionValue[i2] < 0) {
                SirixDeweyID.maxDivisionValue[i2] = Integer.MAX_VALUE;
                continue;
            }
            int n = i2;
            maxDivisionValue[n] = maxDivisionValue[n] + maxDivisionValue[i2 - 1];
        }
        if (maxDivisionValue[divisionLengthArray.length - 1] != Integer.MAX_VALUE) {
            System.out.println("XTCdeweyID[static]: it is not possible to handle all positive Integer values with the given divisionLengthArray!");
        }
        if (bitStringAsBoolean.length != divisionLengthArray.length) {
            System.out.println("XTCdeweyID[static]: bitStringAsBoolean and divisionLengthArray must have equal rows!");
        }
        int maxBitStringLength = 0;
        for (int i3 = 0; i3 < bitStringAsBoolean.length; ++i3) {
            if (bitStringAsBoolean[i3].length <= maxBitStringLength) continue;
            maxBitStringLength = bitStringAsBoolean[i3].length;
        }
        int index = 0;
        for (i = 0; i < maxBitStringLength; ++i) {
            index = 2 * index + 2;
        }
        binaryTreeSuffixInit = new int[index + 1];
        binaryTreeSearchArray = new byte[index + 1];
        for (i = 0; i < bitStringAsBoolean.length; ++i) {
            index = 0;
            for (int j = 0; j < bitStringAsBoolean[i].length; ++j) {
                index = bitStringAsBoolean[i][j] ? 2 * index + 2 : 2 * index + 1;
                if (binaryTreeSuffixInit[index] == 0) continue;
                System.out.println("XTCdeweyID[static]: The bitStringAsBoolean is not prefixfree!");
            }
            if (i == 0) {
                SirixDeweyID.binaryTreeSuffixInit[index] = 0;
                int n = index;
                binaryTreeSuffixInit[n] = binaryTreeSuffixInit[n] - 1;
            } else {
                SirixDeweyID.binaryTreeSuffixInit[index] = maxDivisionValue[i - 1] + 1;
            }
            SirixDeweyID.binaryTreeSearchArray[index] = divisionLengthArray[i];
        }
        for (i = 0; i < bitStringAsBoolean.length; ++i) {
            SirixDeweyID.completeDivisionLengthArray[i] = bitStringAsBoolean[i].length + divisionLengthArray[i];
        }
    }
}

