/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.node.xdm;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.delegates.NodeDelegate;
import org.sirix.node.delegates.StructNodeDelegate;
import org.sirix.node.delegates.ValNodeDelegate;
import org.sirix.node.immutable.xdm.ImmutableComment;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.node.xdm.AbstractStructForwardingNode;
import org.sirix.settings.Constants;
import org.sirix.settings.Fixed;

public final class CommentNode
extends AbstractStructForwardingNode
implements ValueNode,
ImmutableXmlNode {
    private final StructNodeDelegate mStructNodeDel;
    private final ValNodeDelegate mValDel;
    private byte[] mValue;

    public CommentNode(ValNodeDelegate valDel, StructNodeDelegate structDel) {
        this.mStructNodeDel = (StructNodeDelegate)Preconditions.checkNotNull((Object)structDel);
        this.mValDel = (ValNodeDelegate)Preconditions.checkNotNull((Object)valDel);
    }

    @Override
    public Kind getKind() {
        return Kind.COMMENT;
    }

    @Override
    public byte[] getRawValue() {
        if (this.mValue == null) {
            this.mValue = this.mValDel.getRawValue();
        }
        return this.mValue;
    }

    @Override
    public void setValue(byte[] value) {
        this.mValue = null;
        this.mValDel.setValue(value);
    }

    @Override
    public long getFirstChildKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        return visitor.visit(ImmutableComment.of(this));
    }

    @Override
    public void decrementChildCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementChildCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getDescendantCount() {
        return 0L;
    }

    @Override
    public void decrementDescendantCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void incrementDescendantCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDescendantCount(long descendantCount) {
        throw new UnsupportedOperationException();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mStructNodeDel.getNodeDelegate(), this.mValDel});
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof CommentNode) {
            CommentNode other = (CommentNode)obj;
            return Objects.equal((Object)this.mStructNodeDel.getNodeDelegate(), (Object)other.getNodeDelegate()) && this.mValDel.equals(other.mValDel);
        }
        return false;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("node delegate", (Object)this.mStructNodeDel.getNodeDelegate()).add("value delegate", (Object)this.mValDel).toString();
    }

    public ValNodeDelegate getValNodeDelegate() {
        return this.mValDel;
    }

    @Override
    protected NodeDelegate delegate() {
        return this.mStructNodeDel.getNodeDelegate();
    }

    @Override
    protected StructNodeDelegate structDelegate() {
        return this.mStructNodeDel;
    }

    @Override
    public String getValue() {
        return new String(this.mValDel.getRawValue(), Constants.DEFAULT_ENCODING);
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        return this.mStructNodeDel.getNodeDelegate().getDeweyID();
    }

    @Override
    public int getTypeKey() {
        return this.mStructNodeDel.getNodeDelegate().getTypeKey();
    }
}

