/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.index.name.Names;
import org.sirix.node.Kind;
import org.sirix.page.AbstractForwardingPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.PageUtils;
import org.sirix.page.SerializationType;
import org.sirix.page.delegates.PageDelegate;
import org.sirix.page.interfaces.Page;

public final class NamePage
extends AbstractForwardingPage {
    private final Names mAttributes;
    private final Names mElements;
    private final Names mNamespaces;
    private final Names mPIs;
    private final Names mJSONObjectKeys;
    private final PageDelegate mDelegate;
    private int mNumberOfArrays;
    private final Map<Integer, Long> mMaxNodeKeys;
    private final Map<Integer, Integer> mCurrentMaxLevelsOfIndirectPages;

    public NamePage() {
        this.mDelegate = new PageDelegate(512);
        this.mMaxNodeKeys = new HashMap<Integer, Long>();
        this.mAttributes = Names.getInstance();
        this.mElements = Names.getInstance();
        this.mNamespaces = Names.getInstance();
        this.mPIs = Names.getInstance();
        this.mJSONObjectKeys = Names.getInstance();
        this.mCurrentMaxLevelsOfIndirectPages = new HashMap<Integer, Integer>();
        this.mNumberOfArrays = 0;
    }

    protected NamePage(DataInput in, SerializationType type) throws IOException {
        this.mDelegate = new PageDelegate(512, in, type);
        int size = in.readInt();
        this.mMaxNodeKeys = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            this.mMaxNodeKeys.put(i, in.readLong());
        }
        this.mElements = Names.clone(in);
        this.mNamespaces = Names.clone(in);
        this.mAttributes = Names.clone(in);
        this.mPIs = Names.clone(in);
        this.mJSONObjectKeys = Names.clone(in);
        this.mNumberOfArrays = in.readInt();
        int currentMaxLevelOfIndirectPages = in.readInt();
        this.mCurrentMaxLevelsOfIndirectPages = new HashMap<Integer, Integer>(currentMaxLevelOfIndirectPages);
        for (int i = 0; i < currentMaxLevelOfIndirectPages; ++i) {
            this.mCurrentMaxLevelsOfIndirectPages.put(i, in.readByte() & 0xFF);
        }
    }

    public byte[] getRawName(int key, Kind nodeKind) {
        byte[] rawName;
        switch (nodeKind) {
            case ELEMENT: {
                rawName = this.mElements.getRawName(key);
                break;
            }
            case NAMESPACE: {
                rawName = this.mNamespaces.getRawName(key);
                break;
            }
            case ATTRIBUTE: {
                rawName = this.mAttributes.getRawName(key);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                rawName = this.mPIs.getRawName(key);
                break;
            }
            case OBJECT_RECORD: {
                rawName = this.mJSONObjectKeys.getRawName(key);
                break;
            }
            default: {
                throw new IllegalStateException("No other node types supported!");
            }
        }
        return rawName;
    }

    public String getName(int key, @Nonnull Kind nodeKind) {
        String name;
        switch (nodeKind) {
            case ELEMENT: {
                name = this.mElements.getName(key);
                break;
            }
            case NAMESPACE: {
                name = this.mNamespaces.getName(key);
                break;
            }
            case ATTRIBUTE: {
                name = this.mAttributes.getName(key);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                name = this.mPIs.getName(key);
                break;
            }
            case OBJECT_RECORD: {
                name = this.mJSONObjectKeys.getName(key);
                break;
            }
            case ARRAY: {
                name = "array";
                break;
            }
            default: {
                throw new IllegalStateException("No other node types supported!");
            }
        }
        return name;
    }

    public int getCount(int key, @Nonnull Kind nodeKind) {
        int count;
        switch (nodeKind) {
            case ELEMENT: {
                count = this.mElements.getCount(key);
                break;
            }
            case NAMESPACE: {
                count = this.mNamespaces.getCount(key);
                break;
            }
            case ATTRIBUTE: {
                count = this.mAttributes.getCount(key);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                count = this.mPIs.getCount(key);
                break;
            }
            case OBJECT_RECORD: {
                count = this.mJSONObjectKeys.getCount(key);
                break;
            }
            case ARRAY: {
                count = this.mNumberOfArrays;
                break;
            }
            default: {
                throw new IllegalStateException("No other node types supported!");
            }
        }
        return count;
    }

    public void setName(int key, String name, Kind nodeKind) {
        switch (nodeKind) {
            case ELEMENT: {
                this.mElements.setName(key, name);
                break;
            }
            case NAMESPACE: {
                this.mNamespaces.setName(key, name);
                break;
            }
            case ATTRIBUTE: {
                this.mAttributes.setName(key, name);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.mPIs.setName(key, name);
                break;
            }
            case OBJECT_RECORD: {
                this.mJSONObjectKeys.setName(key, name);
                break;
            }
            case ARRAY: {
                break;
            }
            default: {
                throw new IllegalStateException("No other node types supported!");
            }
        }
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        super.serialize(out, type);
        int size = this.mMaxNodeKeys.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            long keys = this.mMaxNodeKeys.get(i);
            out.writeLong(keys);
        }
        this.mElements.serialize(out);
        this.mNamespaces.serialize(out);
        this.mAttributes.serialize(out);
        this.mPIs.serialize(out);
        this.mJSONObjectKeys.serialize(out);
        out.writeInt(this.mNumberOfArrays);
        int currentMaxLevelOfIndirectPages = this.mMaxNodeKeys.size();
        out.writeInt(currentMaxLevelOfIndirectPages);
        for (int i = 0; i < currentMaxLevelOfIndirectPages; ++i) {
            out.writeByte(this.mCurrentMaxLevelsOfIndirectPages.get(i));
        }
    }

    public int getCurrentMaxLevelOfIndirectPages(int index) {
        return this.mCurrentMaxLevelsOfIndirectPages.get(index);
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages(int index) {
        return this.mCurrentMaxLevelsOfIndirectPages.merge(index, 1, (previousValue, value) -> previousValue + value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("elements", (Object)this.mElements).add("attributes", (Object)this.mAttributes).add("URIs", (Object)this.mNamespaces).add("PIs", (Object)this.mPIs).toString();
    }

    public void removeName(int key, Kind nodeKind) {
        switch (nodeKind) {
            case ELEMENT: {
                this.mElements.removeName(key);
                break;
            }
            case NAMESPACE: {
                this.mNamespaces.removeName(key);
                break;
            }
            case ATTRIBUTE: {
                this.mAttributes.removeName(key);
                break;
            }
            case PROCESSING_INSTRUCTION: {
                this.mPIs.removeName(key);
                break;
            }
            case OBJECT_RECORD: {
                this.mJSONObjectKeys.removeName(key);
                break;
            }
            default: {
                throw new IllegalStateException("No other node types supported!");
            }
        }
    }

    public void createNameIndexTree(PageReadOnlyTrx pageReadTrx, int index, TransactionIntentLog log) {
        PageReference reference = this.getReference(index);
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15 && reference.getPersistentLogKey() == -15L) {
            PageUtils.createTree(reference, PageKind.NAMEPAGE, index, pageReadTrx, log);
            if (this.mMaxNodeKeys.get(index) == null) {
                this.mMaxNodeKeys.put(index, 0L);
            } else {
                this.mMaxNodeKeys.put(index, this.mMaxNodeKeys.get(index) + 1L);
            }
            if (this.mCurrentMaxLevelsOfIndirectPages.get(index) == null) {
                this.mCurrentMaxLevelsOfIndirectPages.put(index, 1);
            } else {
                this.mCurrentMaxLevelsOfIndirectPages.put(index, this.mCurrentMaxLevelsOfIndirectPages.get(index) + 1);
            }
        }
    }

    public PageReference getIndirectPageReference(int offset) {
        return this.getReference(offset);
    }

    public long getMaxNodeKey(int indexNo) {
        return this.mMaxNodeKeys.get(indexNo);
    }

    public long incrementAndGetMaxNodeKey(int indexNo) {
        long newMaxNodeKey = this.mMaxNodeKeys.get(indexNo) + 1L;
        this.mMaxNodeKeys.put(indexNo, newMaxNodeKey);
        return newMaxNodeKey;
    }

    @Override
    protected Page delegate() {
        return this.mDelegate;
    }
}

