/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import javax.annotation.Nonnull;
import org.sirix.access.DatabaseType;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.PageContainer;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.interfaces.Record;
import org.sirix.page.IndirectPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.UnorderedKeyValuePage;
import org.sirix.settings.Fixed;

public final class PageUtils {
    private PageUtils() {
        throw new AssertionError((Object)"May never be instantiated!");
    }

    public static void createTree(@Nonnull PageReference reference, PageKind pageKind, int index, PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        IndirectPage page = new IndirectPage();
        log.put(reference, PageContainer.getInstance(page, page));
        reference = page.getReference(0);
        UnorderedKeyValuePage ndp = new UnorderedKeyValuePage(Fixed.ROOT_PAGE_KEY.getStandardProperty(), pageKind, -15L, pageReadTrx);
        SirixDeweyID id = pageReadTrx.getResourceManager().getResourceConfig().areDeweyIDsStored ? SirixDeweyID.newRootID() : null;
        DatabaseType dbType = pageReadTrx.getResourceManager().getDatabase().getDatabaseConfig().getDatabaseType();
        ndp.setEntry(0L, (Record)dbType.getDocumentNode(id));
        log.put(reference, PageContainer.getInstance(ndp, ndp));
    }
}

