/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import com.google.common.base.MoreObjects;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.page.AbstractForwardingPage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.PageUtils;
import org.sirix.page.SerializationType;
import org.sirix.page.delegates.PageDelegate;
import org.sirix.page.interfaces.Page;

public final class PathPage
extends AbstractForwardingPage {
    private final PageDelegate mDelegate;
    private final Map<Integer, Long> mMaxNodeKeys;
    private final Map<Integer, Integer> mCurrentMaxLevelsOfIndirectPages;

    public PathPage() {
        this.mDelegate = new PageDelegate(512);
        this.mMaxNodeKeys = new HashMap<Integer, Long>();
        this.mCurrentMaxLevelsOfIndirectPages = new HashMap<Integer, Integer>();
    }

    public PageReference getIndirectPageReference(int offset) {
        return this.getReference(offset);
    }

    protected PathPage(DataInput in, SerializationType type) throws IOException {
        this.mDelegate = new PageDelegate(512, in, type);
        int size = in.readInt();
        this.mMaxNodeKeys = new HashMap<Integer, Long>(size);
        for (int i = 0; i < size; ++i) {
            this.mMaxNodeKeys.put(i, in.readLong());
        }
        int currentMaxLevelOfIndirectPages = in.readInt();
        this.mCurrentMaxLevelsOfIndirectPages = new HashMap<Integer, Integer>(currentMaxLevelOfIndirectPages);
        for (int i = 0; i < currentMaxLevelOfIndirectPages; ++i) {
            this.mCurrentMaxLevelsOfIndirectPages.put(i, in.readByte() & 0xFF);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mDelegate", (Object)this.mDelegate).toString();
    }

    @Override
    protected Page delegate() {
        return this.mDelegate;
    }

    public void createPathIndexTree(PageReadOnlyTrx pageReadTrx, int index, TransactionIntentLog log) {
        PageReference reference = this.getReference(index);
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15 && reference.getPersistentLogKey() == -15L) {
            PageUtils.createTree(reference, PageKind.PATHPAGE, index, pageReadTrx, log);
            if (this.mMaxNodeKeys.get(index) == null) {
                this.mMaxNodeKeys.put(index, 0L);
            } else {
                this.mMaxNodeKeys.put(index, this.mMaxNodeKeys.get(index) + 1L);
            }
            if (this.mCurrentMaxLevelsOfIndirectPages.get(index) == null) {
                this.mCurrentMaxLevelsOfIndirectPages.put(index, 1);
            } else {
                this.mCurrentMaxLevelsOfIndirectPages.put(index, this.mCurrentMaxLevelsOfIndirectPages.get(index) + 1);
            }
        }
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        super.serialize(out, type);
        int size = this.mMaxNodeKeys.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            out.writeLong(this.mMaxNodeKeys.get(i));
        }
        int currentMaxLevelOfIndirectPages = this.mMaxNodeKeys.size();
        out.writeInt(currentMaxLevelOfIndirectPages);
        for (int i = 0; i < currentMaxLevelOfIndirectPages; ++i) {
            out.writeByte(this.mCurrentMaxLevelsOfIndirectPages.get(i));
        }
    }

    public int getCurrentMaxLevelOfIndirectPages(int index) {
        return this.mCurrentMaxLevelsOfIndirectPages.get(index);
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages(int index) {
        return this.mCurrentMaxLevelsOfIndirectPages.merge(index, 1, (previousValue, value) -> previousValue + value);
    }

    public long getMaxNodeKey(int indexNo) {
        return this.mMaxNodeKeys.get(indexNo);
    }

    public long incrementAndGetMaxNodeKey(int indexNo) {
        long newMaxNodeKey = this.mMaxNodeKeys.get(indexNo) + 1L;
        this.mMaxNodeKeys.put(indexNo, newMaxNodeKey);
        return newMaxNodeKey;
    }
}

