/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.sirix.access.trx.node.CommitCredentials;
import org.sirix.api.PageReadOnlyTrx;
import org.sirix.api.PageTrx;
import org.sirix.cache.TransactionIntentLog;
import org.sirix.node.interfaces.Record;
import org.sirix.page.AbstractForwardingPage;
import org.sirix.page.CASPage;
import org.sirix.page.NamePage;
import org.sirix.page.PageKind;
import org.sirix.page.PageReference;
import org.sirix.page.PageUtils;
import org.sirix.page.PathPage;
import org.sirix.page.PathSummaryPage;
import org.sirix.page.SerializationType;
import org.sirix.page.delegates.PageDelegate;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;
import org.sirix.settings.Constants;

public final class RevisionRootPage
extends AbstractForwardingPage {
    private static final int INDIRECT_REFERENCE_OFFSET = 0;
    private static final int PATH_SUMMARY_REFERENCE_OFFSET = 1;
    private static final int NAME_REFERENCE_OFFSET = 2;
    private static final int CAS_REFERENCE_OFFSET = 3;
    private static final int PATH_REFERENCE_OFFSET = 4;
    private long mMaxNodeKey;
    private long mRevisionTimestamp;
    private final PageDelegate mDelegate;
    private final int mRevision;
    private String mCommitMessage;
    private int mCurrentMaxLevelOfIndirectPages;

    public RevisionRootPage() {
        this.mDelegate = new PageDelegate(5);
        this.getReference(1).setPage(new PathSummaryPage());
        this.getReference(2).setPage(new NamePage());
        this.getReference(3).setPage(new CASPage());
        this.getReference(4).setPage(new PathPage());
        this.mRevision = 0;
        this.mMaxNodeKey = -1L;
        this.mCurrentMaxLevelOfIndirectPages = 1;
    }

    protected RevisionRootPage(DataInput in, SerializationType type) throws IOException {
        this.mDelegate = new PageDelegate(5, in, type);
        this.mRevision = in.readInt();
        this.mMaxNodeKey = in.readLong();
        this.mRevisionTimestamp = in.readLong();
        if (in.readBoolean()) {
            byte[] commitMessage = new byte[in.readInt()];
            in.readFully(commitMessage);
            this.mCommitMessage = new String(commitMessage, Constants.DEFAULT_ENCODING);
        }
        this.mCurrentMaxLevelOfIndirectPages = in.readByte() & 0xFF;
    }

    public RevisionRootPage(RevisionRootPage committedRevisionRootPage, @Nonnegative int representRev) {
        this.mDelegate = new PageDelegate(committedRevisionRootPage, committedRevisionRootPage.mDelegate.getBitmap());
        this.mRevision = representRev;
        this.mMaxNodeKey = committedRevisionRootPage.mMaxNodeKey;
        this.mRevisionTimestamp = committedRevisionRootPage.mRevisionTimestamp;
        this.mCurrentMaxLevelOfIndirectPages = committedRevisionRootPage.mCurrentMaxLevelOfIndirectPages;
    }

    public PageReference getPathSummaryPageReference() {
        return this.getReference(1);
    }

    public PageReference getCASPageReference() {
        return this.getReference(3);
    }

    public PageReference getNamePageReference() {
        return this.getReference(2);
    }

    public PageReference getPathPageReference() {
        return this.getReference(4);
    }

    public PageReference getIndirectPageReference() {
        return this.getReference(0);
    }

    public long getRevisionTimestamp() {
        return this.mRevisionTimestamp;
    }

    public long getMaxNodeKey() {
        return this.mMaxNodeKey;
    }

    public long incrementAndGetMaxNodeKey() {
        return ++this.mMaxNodeKey;
    }

    public void setMaxNodeKey(@Nonnegative long maxNodeKey) {
        this.mMaxNodeKey = maxNodeKey;
    }

    @Override
    public <K extends Comparable<? super K>, V extends Record, S extends KeyValuePage<K, V>> void commit(@Nonnull PageTrx<K, V, S> pageWriteTrx) {
        if (this.mRevision == pageWriteTrx.getUberPage().getRevision()) {
            super.commit(pageWriteTrx);
        }
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) throws IOException {
        this.mRevisionTimestamp = Instant.now().toEpochMilli();
        this.mDelegate.serialize((DataOutput)Preconditions.checkNotNull((Object)out), (SerializationType)((Object)Preconditions.checkNotNull((Object)((Object)type))));
        out.writeInt(this.mRevision);
        out.writeLong(this.mMaxNodeKey);
        out.writeLong(this.mRevisionTimestamp);
        out.writeBoolean(this.mCommitMessage != null);
        if (this.mCommitMessage != null) {
            byte[] commitMessage = this.mCommitMessage.getBytes(Constants.DEFAULT_ENCODING);
            out.writeInt(commitMessage.length);
            out.write(commitMessage);
        }
        out.writeByte(this.mCurrentMaxLevelOfIndirectPages);
    }

    public int getCurrentMaxLevelOfIndirectPages() {
        return this.mCurrentMaxLevelOfIndirectPages;
    }

    public int incrementAndGetCurrentMaxLevelOfIndirectPages() {
        return ++this.mCurrentMaxLevelOfIndirectPages;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("revisionTimestamp", this.mRevisionTimestamp).add("maxNodeKey", this.mMaxNodeKey).add("delegate", (Object)this.mDelegate).add("namePage", (Object)this.getReference(2)).add("pathSummaryPage", (Object)this.getReference(1)).add("pathPage", (Object)this.getReference(4)).add("CASPage", (Object)this.getReference(3)).add("nodePage", (Object)this.getReference(0)).toString();
    }

    @Override
    protected Page delegate() {
        return this.mDelegate;
    }

    public void createNodeTree(PageReadOnlyTrx pageReadTrx, TransactionIntentLog log) {
        PageReference reference = this.getIndirectPageReference();
        if (reference.getPage() == null && reference.getKey() == -15L && reference.getLogKey() == -15 && reference.getPersistentLogKey() == -15L) {
            PageUtils.createTree(reference, PageKind.RECORDPAGE, -1, pageReadTrx, log);
            this.incrementAndGetMaxNodeKey();
        }
    }

    public int getRevision() {
        return this.mRevision;
    }

    public void setCommitMessage(String commitMessage) {
        this.mCommitMessage = commitMessage;
    }

    public CommitCredentials getCommitCredentials() {
        return new CommitCredentials(null, this.mCommitMessage);
    }
}

