/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.page.delegates;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.BitSet;
import java.util.List;
import javax.annotation.Nonnegative;
import org.magicwerk.brownies.collections.GapList;
import org.sirix.api.PageTrx;
import org.sirix.node.interfaces.Record;
import org.sirix.page.DeserializedTuple;
import org.sirix.page.PageReference;
import org.sirix.page.SerializationType;
import org.sirix.page.interfaces.KeyValuePage;
import org.sirix.page.interfaces.Page;

public final class PageDelegate
implements Page {
    private final List<PageReference> mReferences;
    private final BitSet mBitmap;

    public PageDelegate(@Nonnegative int referenceCount) {
        Preconditions.checkArgument((referenceCount >= 0 ? 1 : 0) != 0);
        int initialSize = referenceCount == 512 || referenceCount == 512 || referenceCount == 512 ? referenceCount >> 6 : referenceCount;
        this.mReferences = new GapList(initialSize);
        this.mBitmap = new BitSet(referenceCount);
    }

    public PageDelegate(@Nonnegative int referenceCount, DataInput in, SerializationType type) {
        DeserializedTuple tuple = type.deserialize(referenceCount, in);
        this.mReferences = tuple.getReferences();
        this.mBitmap = tuple.getBitmap();
    }

    public PageDelegate(Page commitedPage, BitSet bitSet) {
        this.mBitmap = (BitSet)bitSet.clone();
        int length = commitedPage.getReferences().size();
        this.mReferences = new GapList(length);
        for (int offset = 0; offset < length; ++offset) {
            PageReference reference = new PageReference();
            reference.setKey(commitedPage.getReferences().get(offset).getKey());
            this.mReferences.add(offset, reference);
        }
    }

    @Override
    public List<PageReference> getReferences() {
        return this.mReferences;
    }

    public BitSet getBitmap() {
        return (BitSet)this.mBitmap.clone();
    }

    @Override
    public PageReference getReference(@Nonnegative int offset) {
        if (this.mBitmap.get(offset)) {
            int index = this.index(offset);
            return this.mReferences.get(index);
        }
        return this.createNewReference(offset);
    }

    @Override
    public void setReference(int offset, PageReference pageReference) {
        int index = this.index(offset);
        this.mReferences.set(index, pageReference);
        this.mBitmap.set(offset, true);
    }

    private PageReference createNewReference(int offset) {
        int index = this.index(offset);
        PageReference pageReference = new PageReference();
        this.mReferences.add(index, pageReference);
        this.mBitmap.set(offset, true);
        return pageReference;
    }

    private int index(int offset) {
        BitSet offsetBitmap = new BitSet(this.mBitmap.size());
        offsetBitmap.set(offset);
        offsetBitmap.flip(0, offset + 1);
        offsetBitmap.and(this.mBitmap);
        return offsetBitmap.cardinality();
    }

    @Override
    public final <K extends Comparable<? super K>, V extends Record, S extends KeyValuePage<K, V>> void commit(PageTrx<K, V, S> pageWriteTrx) {
        for (PageReference reference : this.mReferences) {
            if (reference.getLogKey() == -15 && reference.getPersistentLogKey() == -15L) continue;
            pageWriteTrx.commit(reference);
        }
    }

    @Override
    public void serialize(DataOutput out, SerializationType type) {
        assert (out != null);
        assert (type != null);
        type.serialize(out, this.mReferences, this.mBitmap);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)this);
        for (PageReference ref : this.mReferences) {
            helper.add("reference", (Object)ref);
        }
        helper.add("bitmap", (Object)PageDelegate.dumpBitmap(this.mBitmap));
        return helper.toString();
    }

    private static String dumpBitmap(BitSet bitmap) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bitmap.length(); ++i) {
            s.append(bitmap.get(i) ? 1 : 0);
        }
        return s.toString();
    }
}

