/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.serialize;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.Database;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.node.Kind;
import org.sirix.service.AbstractSerializer;
import org.sirix.service.xml.serialize.XmlSerializerProperties;
import org.sirix.settings.CharsForSerializing;
import org.sirix.settings.Constants;
import org.sirix.utils.LogWrapper;
import org.sirix.utils.SirixFiles;
import org.sirix.utils.XMLToken;
import org.slf4j.LoggerFactory;

public final class XmlSerializer
extends AbstractSerializer<XmlNodeReadOnlyTrx, XmlNodeTrx> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(XmlSerializer.class));
    private static final int ASCII_OFFSET = 48;
    private static final long[] LONG_POWERS = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    private final OutputStream mOut;
    private final boolean mIndent;
    private final boolean mSerializeXMLDeclaration;
    private final boolean mSerializeRest;
    private final boolean mSerializeRestSequence;
    private final boolean mSerializeId;
    private final int mIndentSpaces;
    private final boolean mWithInitialIndent;
    private final boolean mEmitXQueryResultSequence;
    private final boolean mSerializeTimestamp;

    private XmlSerializer(XmlResourceManager resourceMgr, @Nonnegative long nodeKey, XmlSerializerBuilder builder, boolean initialIndent, @Nonnegative int revision, int ... revsions) {
        super(resourceMgr, nodeKey, revision, revsions);
        this.mOut = new BufferedOutputStream(builder.mStream, 4096);
        this.mIndent = builder.mIndent;
        this.mSerializeXMLDeclaration = builder.mDeclaration;
        this.mSerializeRest = builder.mREST;
        this.mSerializeRestSequence = builder.mRESTSequence;
        this.mSerializeId = builder.mID;
        this.mIndentSpaces = builder.mIndentSpaces;
        this.mWithInitialIndent = builder.mInitialIndent;
        this.mEmitXQueryResultSequence = builder.mEmitXQueryResultSequence;
        this.mSerializeTimestamp = builder.mSerializeTimestamp;
    }

    @Override
    protected void emitNode(XmlNodeReadOnlyTrx rtx) {
        try {
            switch (rtx.getKind()) {
                case XDM_DOCUMENT: {
                    break;
                }
                case ELEMENT: {
                    int index;
                    this.indent();
                    this.mOut.write(CharsForSerializing.OPEN.getBytes());
                    this.writeQName(rtx);
                    long key = rtx.getNodeKey();
                    int nspCount = rtx.getNamespaceCount();
                    for (index = 0; index < nspCount; ++index) {
                        rtx.moveToNamespace(index);
                        if (rtx.getPrefixKey() == -1) {
                            this.mOut.write(CharsForSerializing.XMLNS.getBytes());
                            this.write(rtx.nameForKey(rtx.getURIKey()));
                            this.mOut.write(CharsForSerializing.QUOTE.getBytes());
                        } else {
                            this.mOut.write(CharsForSerializing.XMLNS_COLON.getBytes());
                            this.write(rtx.nameForKey(rtx.getPrefixKey()));
                            this.mOut.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                            this.write(rtx.nameForKey(rtx.getURIKey()));
                            this.mOut.write(CharsForSerializing.QUOTE.getBytes());
                        }
                        rtx.moveTo(key);
                    }
                    if (this.mSerializeId) {
                        if (this.mSerializeRest) {
                            this.mOut.write(CharsForSerializing.REST_PREFIX.getBytes());
                        } else if (this.mRevisions.length > 1 || this.mRevisions.length == 1 && this.mRevisions[0] == -1) {
                            this.mOut.write(CharsForSerializing.SID_PREFIX.getBytes());
                        } else {
                            this.mOut.write(CharsForSerializing.SPACE.getBytes());
                        }
                        this.mOut.write(CharsForSerializing.ID.getBytes());
                        this.mOut.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                        this.write(rtx.getNodeKey());
                        this.mOut.write(CharsForSerializing.QUOTE.getBytes());
                    }
                    int attCount = rtx.getAttributeCount();
                    for (index = 0; index < attCount; ++index) {
                        rtx.moveToAttribute(index);
                        this.mOut.write(CharsForSerializing.SPACE.getBytes());
                        this.writeQName(rtx);
                        this.mOut.write(CharsForSerializing.EQUAL_QUOTE.getBytes());
                        this.mOut.write(XMLToken.escapeAttribute(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                        this.mOut.write(CharsForSerializing.QUOTE.getBytes());
                        rtx.moveTo(key);
                    }
                    if (rtx.hasFirstChild()) {
                        this.mOut.write(CharsForSerializing.CLOSE.getBytes());
                    } else {
                        this.mOut.write(CharsForSerializing.SLASH_CLOSE.getBytes());
                    }
                    if (this.mIndent && (rtx.getFirstChildKind() != Kind.TEXT || rtx.getChildCount() != 1L)) {
                        this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    break;
                }
                case COMMENT: {
                    this.indent();
                    this.mOut.write(CharsForSerializing.OPENCOMMENT.getBytes());
                    this.mOut.write(XMLToken.escapeContent(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                    if (this.mIndent) {
                        this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    this.mOut.write(CharsForSerializing.CLOSECOMMENT.getBytes());
                    break;
                }
                case TEXT: {
                    if (rtx.hasRightSibling() || rtx.hasLeftSibling()) {
                        this.indent();
                    }
                    this.mOut.write(XMLToken.escapeContent(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                    if (this.mIndent && (rtx.hasRightSibling() || rtx.hasLeftSibling())) {
                        this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    break;
                }
                case PROCESSING_INSTRUCTION: {
                    this.indent();
                    this.mOut.write(CharsForSerializing.OPENPI.getBytes());
                    this.writeQName(rtx);
                    this.mOut.write(CharsForSerializing.SPACE.getBytes());
                    this.mOut.write(XMLToken.escapeContent(rtx.getValue()).getBytes(Constants.DEFAULT_ENCODING));
                    if (this.mIndent) {
                        this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                    }
                    this.mOut.write(CharsForSerializing.CLOSEPI.getBytes());
                    break;
                }
                default: {
                    throw new IllegalStateException("Node kind not known!");
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndNode(XmlNodeReadOnlyTrx rtx) {
        try {
            if (this.mIndent && (rtx.getFirstChildKind() != Kind.TEXT || rtx.getChildCount() != 1L)) {
                this.indent();
            }
            this.mOut.write(CharsForSerializing.OPEN_SLASH.getBytes());
            this.writeQName(rtx);
            this.mOut.write(CharsForSerializing.CLOSE.getBytes());
            if (this.mIndent) {
                this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private void writeQName(XmlNodeReadOnlyTrx rtx) throws IOException {
        if (rtx.getPrefixKey() != -1) {
            this.mOut.write(rtx.rawNameForKey(rtx.getPrefixKey()));
            this.mOut.write(CharsForSerializing.COLON.getBytes());
        }
        this.mOut.write(rtx.rawNameForKey(rtx.getLocalNameKey()));
    }

    @Override
    protected void emitStartDocument() {
        try {
            int length;
            if (this.mSerializeXMLDeclaration) {
                this.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
                if (this.mIndent) {
                    this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                }
            }
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (this.mSerializeRestSequence || length > 1) {
                if (this.mSerializeRestSequence) {
                    this.write("<rest:sequence xmlns:rest=\"https://sirix.io/rest\">");
                } else {
                    this.write("<sdb:sirix xmlns:sdb=\"https://sirix.io/rest\">");
                }
                if (this.mIndent) {
                    this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                    this.mStack.push(-15L);
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitEndDocument() {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (this.mSerializeRestSequence || length > 1) {
                if (this.mIndent) {
                    this.mStack.pop();
                }
                this.indent();
                if (this.mSerializeRestSequence) {
                    this.write("</rest:sequence>");
                } else {
                    this.write("</sdb:sirix>");
                }
            }
            this.mOut.flush();
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionStartNode(@Nonnull XmlNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (this.mSerializeRest || length > 1) {
                this.indent();
                if (this.mSerializeRest) {
                    this.write("<rest:item");
                } else {
                    this.write("<sdb:sirix-item");
                }
                if (length > 1 || this.mEmitXQueryResultSequence) {
                    if (this.mSerializeRest) {
                        this.write(" rest:revision=\"");
                    } else {
                        this.write(" sdb:revision=\"");
                    }
                    this.write(Integer.toString(rtx.getRevisionNumber()));
                    this.write("\"");
                    if (this.mSerializeTimestamp) {
                        if (this.mSerializeRest) {
                            this.write(" rest:revisionTimestamp=\"");
                        } else {
                            this.write(" sdb:revisionTimestamp=\"");
                        }
                        this.write(DateTimeFormatter.ISO_INSTANT.withZone(ZoneOffset.UTC).format(rtx.getRevisionTimestamp()));
                        this.write("\"");
                    }
                    this.write(">");
                } else if (this.mSerializeRest) {
                    this.write(">");
                }
                if (rtx.hasFirstChild()) {
                    this.mStack.push(-15L);
                }
                if (this.mIndent) {
                    this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
                }
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    @Override
    protected void emitRevisionEndNode(@Nonnull XmlNodeReadOnlyTrx rtx) {
        try {
            int length;
            int n = length = this.mRevisions.length == 1 && this.mRevisions[0] < 0 ? this.mResMgr.getMostRecentRevisionNumber() : this.mRevisions.length;
            if (this.mSerializeRest || length > 1) {
                if (rtx.moveToDocumentRoot().trx().hasFirstChild()) {
                    this.mStack.pop();
                }
                this.indent();
                if (this.mSerializeRest) {
                    this.write("</rest:item>");
                } else {
                    this.write("</sdb:sirix-item>");
                }
            }
            if (this.mIndent) {
                this.mOut.write(CharsForSerializing.NEWLINE.getBytes());
            }
        }
        catch (IOException e) {
            LOGWRAPPER.error(e.getMessage(), e);
        }
    }

    private void indent() throws IOException {
        if (this.mIndent) {
            int indentSpaces = this.mWithInitialIndent ? (this.mStack.size() + 1) * this.mIndentSpaces : this.mStack.size() * this.mIndentSpaces;
            for (int i = 0; i < indentSpaces; ++i) {
                this.mOut.write(" ".getBytes(Constants.DEFAULT_ENCODING));
            }
        }
    }

    protected void write(String value) throws UnsupportedEncodingException, IOException {
        this.mOut.write(value.getBytes(Constants.DEFAULT_ENCODING));
    }

    private void write(long value) throws IOException {
        int length = (int)Math.log10(value);
        byte digit = 0;
        long remainder = value;
        for (int i = length; i >= 0; --i) {
            digit = (byte)(remainder / LONG_POWERS[i]);
            this.mOut.write((byte)(digit + 48));
            remainder -= (long)digit * LONG_POWERS[i];
        }
    }

    public static void main(String ... args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            throw new IllegalArgumentException("Usage: XMLSerializer input-TT output.xml");
        }
        LOGWRAPPER.info("Serializing '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path target = Paths.get(args[1], new String[0]);
        SirixFiles.recursiveRemove(target);
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.createFile(target, new FileAttribute[0]);
        Path databaseFile = Paths.get(args[0], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(databaseFile);
        Databases.createXmlDatabase(config);
        try (Database<XmlResourceManager> db = Databases.openXmlDatabase(databaseFile);){
            db.createResource(new ResourceConfiguration.Builder("shredded").build());
            try (XmlResourceManager resMgr = db.openResourceManager("shredded");
                 FileOutputStream outputStream = new FileOutputStream(target.toFile());){
                XmlSerializer serializer = XmlSerializer.newBuilder(resMgr, outputStream, new int[0]).emitXMLDeclaration().build();
                serializer.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + "ms].", new Object[0]);
    }

    public static XmlSerializerBuilder newBuilder(XmlResourceManager resMgr, OutputStream stream, int ... revisions) {
        return new XmlSerializerBuilder(resMgr, stream, revisions);
    }

    public static XmlSerializerBuilder newBuilder(XmlResourceManager resMgr, @Nonnegative long nodeKey, OutputStream stream, XmlSerializerProperties properties, int ... revisions) {
        return new XmlSerializerBuilder(resMgr, nodeKey, stream, properties, revisions);
    }

    public static final class XmlSerializerBuilder {
        public boolean mRESTSequence;
        private boolean mIndent;
        private boolean mREST;
        private boolean mDeclaration;
        private boolean mID;
        private int mIndentSpaces = 2;
        private final OutputStream mStream;
        private final XmlResourceManager mResourceMgr;
        private int[] mVersions;
        private int mVersion;
        private long mNodeKey;
        private boolean mInitialIndent;
        private boolean mEmitXQueryResultSequence;
        private boolean mSerializeTimestamp;

        public XmlSerializerBuilder(XmlResourceManager resourceMgr, OutputStream stream, int ... revisions) {
            this.mNodeKey = 0L;
            this.mResourceMgr = (XmlResourceManager)Preconditions.checkNotNull((Object)resourceMgr);
            this.mStream = (OutputStream)Preconditions.checkNotNull((Object)stream);
            if (revisions == null || revisions.length == 0) {
                this.mVersion = this.mResourceMgr.getMostRecentRevisionNumber();
            } else {
                this.mVersion = revisions[0];
                this.mVersions = new int[revisions.length - 1];
                for (int i = 0; i < revisions.length - 1; ++i) {
                    this.mVersions[i] = revisions[i + 1];
                }
            }
        }

        public XmlSerializerBuilder(XmlResourceManager resourceMgr, @Nonnegative long nodeKey, OutputStream stream, XmlSerializerProperties properties, int ... revisions) {
            Preconditions.checkArgument((nodeKey >= 0L ? 1 : 0) != 0, (Object)"pNodeKey must be >= 0!");
            this.mResourceMgr = (XmlResourceManager)Preconditions.checkNotNull((Object)resourceMgr);
            this.mNodeKey = nodeKey;
            this.mStream = (OutputStream)Preconditions.checkNotNull((Object)stream);
            if (revisions == null || revisions.length == 0) {
                this.mVersion = this.mResourceMgr.getMostRecentRevisionNumber();
            } else {
                this.mVersion = revisions[0];
                this.mVersions = new int[revisions.length - 1];
                for (int i = 0; i < revisions.length - 1; ++i) {
                    this.mVersions[i] = revisions[i + 1];
                }
            }
            ConcurrentMap map = (ConcurrentMap)Preconditions.checkNotNull(properties.getProps());
            this.mIndent = (Boolean)Preconditions.checkNotNull((Object)((Boolean)map.get(XmlSerializerProperties.S_INDENT[0])));
            this.mREST = (Boolean)Preconditions.checkNotNull((Object)((Boolean)map.get(XmlSerializerProperties.S_REST[0])));
            this.mID = (Boolean)Preconditions.checkNotNull((Object)((Boolean)map.get(XmlSerializerProperties.S_ID[0])));
            this.mIndentSpaces = (Integer)Preconditions.checkNotNull((Object)((Integer)map.get(XmlSerializerProperties.S_INDENT_SPACES[0])));
            this.mDeclaration = (Boolean)Preconditions.checkNotNull((Object)((Boolean)map.get(XmlSerializerProperties.S_XMLDECL[0])));
        }

        public XmlSerializerBuilder startNodeKey(long nodeKey) {
            this.mNodeKey = nodeKey;
            return this;
        }

        public XmlSerializerBuilder withInitialIndent() {
            this.mInitialIndent = true;
            return this;
        }

        public XmlSerializerBuilder isXQueryResultSequence() {
            this.mEmitXQueryResultSequence = true;
            return this;
        }

        public XmlSerializerBuilder serializeTimestamp(boolean serializeTimestamp) {
            this.mSerializeTimestamp = serializeTimestamp;
            return this;
        }

        public XmlSerializerBuilder prettyPrint() {
            this.mIndent = true;
            return this;
        }

        public XmlSerializerBuilder emitRESTful() {
            this.mREST = true;
            return this;
        }

        public XmlSerializerBuilder emitRESTSequence() {
            this.mRESTSequence = true;
            return this;
        }

        public XmlSerializerBuilder emitXMLDeclaration() {
            this.mDeclaration = true;
            return this;
        }

        public XmlSerializerBuilder emitIDs() {
            this.mID = true;
            return this;
        }

        public XmlSerializerBuilder revisions(int[] revisions) {
            Preconditions.checkNotNull((Object)revisions);
            this.mVersion = revisions[0];
            this.mVersions = new int[revisions.length - 1];
            for (int i = 0; i < revisions.length - 1; ++i) {
                this.mVersions[i] = revisions[i + 1];
            }
            return this;
        }

        public XmlSerializer build() {
            return new XmlSerializer(this.mResourceMgr, this.mNodeKey, this, this.mInitialIndent, this.mVersion, this.mVersions);
        }
    }
}

