/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.serialize;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class XmlSerializerProperties {
    private static final LogWrapper LOGGER = new LogWrapper(LoggerFactory.getLogger(XmlSerializerProperties.class));
    private static final boolean NO = false;
    public static final Object[] S_ID = new Object[]{"serialize-id", false};
    public static final Object[] S_INDENT = new Object[]{"indent", false};
    public static final Object[] S_INDENT_SPACES = new Object[]{"indent-spaces", 2};
    public static final Object[] S_REST = new Object[]{"serialize-rest", false};
    public static final Object[] S_XMLDECL = new Object[]{"xmldecl", false};
    private String mFilePath;
    private final ConcurrentMap<String, Object> mProps = new ConcurrentHashMap<String, Object>();

    public XmlSerializerProperties() {
        try {
            for (Field f : this.getClass().getFields()) {
                Object obj = f.get(null);
                if (!(obj instanceof Object[])) continue;
                Object[] arr = (Object[])obj;
                this.mProps.put(arr[0].toString(), arr[1]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    public ConcurrentMap<String, Object> readProps(String filePath) {
        this.mFilePath = filePath;
        if (!new File(this.mFilePath).exists()) {
            throw new IllegalStateException("Properties file doesn't exist!");
        }
        try {
            BufferedReader buffReader = new BufferedReader(new FileReader(this.mFilePath));
            String line = buffReader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty()) {
                    int equals = line.indexOf(61);
                    if (equals < 0) {
                        LOGGER.error("Properties file has no '=' sign in line -- parsing error!", new Object[0]);
                    }
                    String key = line.substring(0, equals).toUpperCase();
                    String value = line.substring(equals + 1);
                    this.mProps.put(key, value);
                    buffReader.close();
                }
                line = buffReader.readLine();
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return this.mProps;
    }

    public ConcurrentMap<String, Object> getProps() {
        return this.mProps;
    }
}

