/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.shredder;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.Callable;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.brackit.xquery.atomic.QNm;
import org.sirix.access.DatabaseConfiguration;
import org.sirix.access.Databases;
import org.sirix.access.ResourceConfiguration;
import org.sirix.api.Database;
import org.sirix.api.xml.XmlNodeTrx;
import org.sirix.api.xml.XmlResourceManager;
import org.sirix.exception.SirixException;
import org.sirix.exception.SirixIOException;
import org.sirix.service.ShredderCommit;
import org.sirix.service.xml.shredder.AbstractShredder;
import org.sirix.service.xml.shredder.InsertPosition;
import org.sirix.service.xml.shredder.QueueEventReader;
import org.sirix.settings.Constants;
import org.sirix.utils.LogWrapper;
import org.slf4j.LoggerFactory;

public final class XmlShredder
extends AbstractShredder
implements Callable<Long> {
    private static final LogWrapper LOGWRAPPER = new LogWrapper(LoggerFactory.getLogger(XmlShredder.class));
    protected final XmlNodeTrx mWtx;
    protected final XMLEventReader mReader;
    private final ShredderCommit mCommit;
    protected final InsertPosition mInsert;
    private boolean mIncludeComments;
    private boolean mIncludePIs;

    private XmlShredder(Builder builder) {
        super(builder.mWtx, builder.mInsert);
        this.mWtx = builder.mWtx;
        this.mReader = builder.mReader;
        this.mInsert = builder.mInsert;
        this.mIncludeComments = builder.mIncludeComments;
        this.mIncludePIs = builder.mIncludePIs;
        this.mCommit = builder.mCommit;
    }

    @Override
    public Long call() throws SirixException {
        long revision = this.mWtx.getRevisionNumber();
        this.insertNewContent();
        this.mCommit.commit(this.mWtx);
        return revision;
    }

    protected final void insertNewContent() throws SirixException {
        try {
            boolean firstElement = true;
            int level = 0;
            QName rootElement = null;
            boolean endElemReached = false;
            StringBuilder sBuilder = new StringBuilder();
            long insertedRootNodeKey = -1L;
            while (this.mReader.hasNext() && !endElemReached) {
                XMLEvent event = this.mReader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        ++level;
                        this.addNewElement(event.asStartElement());
                        if (!firstElement) break;
                        firstElement = false;
                        insertedRootNodeKey = this.mWtx.getNodeKey();
                        rootElement = event.asStartElement().getName();
                        break;
                    }
                    case 2: {
                        if (--level == 0 && rootElement != null && rootElement.equals(event.asEndElement().getName())) {
                            endElemReached = true;
                        }
                        QName name = event.asEndElement().getName();
                        this.processEndTag(new QNm(name.getNamespaceURI(), name.getPrefix(), name.getLocalPart()));
                        break;
                    }
                    case 4: {
                        if (this.mReader.peek().getEventType() == 4) {
                            sBuilder.append(event.asCharacters().getData().trim());
                            break;
                        }
                        sBuilder.append(event.asCharacters().getData().trim());
                        this.processText(sBuilder.toString());
                        sBuilder.setLength(0);
                        break;
                    }
                    case 5: {
                        if (!this.mIncludeComments) break;
                        this.processComment(((Comment)event).getText());
                        break;
                    }
                    case 3: {
                        if (!this.mIncludePIs) break;
                        ProcessingInstruction pi = (ProcessingInstruction)event;
                        this.processPI(pi.getData(), pi.getTarget());
                        break;
                    }
                }
            }
            this.mWtx.moveTo(insertedRootNodeKey);
        }
        catch (XMLStreamException e) {
            throw new SirixIOException(e);
        }
    }

    private void addNewElement(StartElement event) throws SirixException {
        assert (event != null);
        QName qName = event.getName();
        QNm name = new QNm(qName.getNamespaceURI(), qName.getPrefix(), qName.getLocalPart());
        this.processStartTag(name);
        Iterator<Attribute> it = event.getNamespaces();
        while (it.hasNext()) {
            Namespace namespace = it.next();
            this.mWtx.insertNamespace(new QNm(namespace.getNamespaceURI(), namespace.getPrefix(), ""));
            this.mWtx.moveToParent();
        }
        it = event.getAttributes();
        while (it.hasNext()) {
            Attribute attribute = it.next();
            QName attName = attribute.getName();
            this.mWtx.insertAttribute(new QNm(attName.getNamespaceURI(), attName.getPrefix(), attName.getLocalPart()), attribute.getValue());
            this.mWtx.moveToParent();
        }
    }

    public static void main(String ... args) throws SirixException, IOException, XMLStreamException {
        if (args.length != 2 && args.length != 3) {
            throw new IllegalArgumentException("Usage: XMLShredder XMLFile Database [true/false] (shredder comment|PI)");
        }
        LOGWRAPPER.info("Shredding '" + args[0] + "' to '" + args[1] + "' ... ", new Object[0]);
        long time = System.nanoTime();
        Path target = Paths.get(args[1], new String[0]);
        DatabaseConfiguration config = new DatabaseConfiguration(target);
        Databases.removeDatabase(target);
        Databases.createXmlDatabase(config);
        try (Database<XmlResourceManager> db = Databases.openXmlDatabase(target);){
            db.createResource(new ResourceConfiguration.Builder("shredded").build());
            try (XmlResourceManager resMgr = db.openResourceManager("shredded");
                 XmlNodeTrx wtx = (XmlNodeTrx)resMgr.beginNodeTrx();
                 FileInputStream fis = new FileInputStream(Paths.get(args[0], new String[0]).toFile());){
                XMLEventReader reader = XmlShredder.createFileReader(fis);
                boolean includeCoPI = args.length == 3 ? Boolean.parseBoolean(args[2]) : false;
                XmlShredder shredder = new Builder(wtx, reader, InsertPosition.AS_FIRST_CHILD).commitAfterwards().includeComments(includeCoPI).includePIs(includeCoPI).build();
                shredder.call();
            }
        }
        LOGWRAPPER.info(" done [" + (System.nanoTime() - time) / 1000000L + " ms].", new Object[0]);
    }

    public static XMLEventReader createFileReader(FileInputStream fis) {
        Preconditions.checkNotNull((Object)fis);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XmlShredder.setProperties(factory);
        try {
            return factory.createXMLEventReader(fis);
        }
        catch (XMLStreamException e) {
            throw new SirixException(e.getMessage(), e);
        }
    }

    private static void setProperties(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.supportDTD", false);
        factory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        factory.setProperty("javax.xml.stream.isReplacingEntityReferences", true);
    }

    public static XMLEventReader createStringReader(String xmlString) {
        Preconditions.checkNotNull((Object)xmlString);
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XmlShredder.setProperties(factory);
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(xmlString.getBytes(Constants.DEFAULT_ENCODING));
            return factory.createXMLEventReader(in);
        }
        catch (XMLStreamException e) {
            throw new SirixException(e.getMessage(), e);
        }
    }

    public static XMLEventReader createQueueReader(Queue<XMLEvent> events) throws IOException, XMLStreamException {
        return new QueueEventReader((Queue)Preconditions.checkNotNull(events));
    }

    public static class Builder {
        private final XmlNodeTrx mWtx;
        private final XMLEventReader mReader;
        private final InsertPosition mInsert;
        private boolean mIncludeComments = true;
        private boolean mIncludePIs = true;
        private ShredderCommit mCommit = ShredderCommit.NOCOMMIT;

        public Builder(XmlNodeTrx wtx, XMLEventReader reader, InsertPosition insert) {
            this.mWtx = (XmlNodeTrx)Preconditions.checkNotNull((Object)wtx);
            this.mReader = (XMLEventReader)Preconditions.checkNotNull((Object)reader);
            this.mInsert = (InsertPosition)((Object)Preconditions.checkNotNull((Object)((Object)insert)));
        }

        public Builder includeComments(boolean include) {
            this.mIncludeComments = include;
            return this;
        }

        public Builder includePIs(boolean include) {
            this.mIncludePIs = include;
            return this;
        }

        public Builder commitAfterwards() {
            this.mCommit = ShredderCommit.COMMIT;
            return this;
        }

        public XmlShredder build() {
            return new XmlShredder(this);
        }
    }
}

