/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.sirix.api.visitor.VisitResult;
import org.sirix.api.visitor.XmlNodeVisitor;
import org.sirix.node.Kind;
import org.sirix.node.SirixDeweyID;
import org.sirix.node.interfaces.Node;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.node.interfaces.immutable.ImmutableXmlNode;
import org.sirix.service.xml.xpath.types.Type;
import org.sirix.settings.Constants;
import org.sirix.settings.Fixed;
import org.sirix.utils.NamePageHash;
import org.sirix.utils.TypedValue;

public final class AtomicValue
implements Node,
ValueNode,
ImmutableXmlNode {
    private byte[] mValue;
    private int mType;
    private long mItemKey;

    public AtomicValue(byte[] value, int type) {
        this.mValue = (byte[])Preconditions.checkNotNull((Object)value);
        this.mType = type;
    }

    public AtomicValue(boolean pValue) {
        this.mValue = TypedValue.getBytes(Boolean.toString(pValue));
        this.mType = NamePageHash.generateHashForString("xs:boolean");
    }

    public AtomicValue(Number pValue, Type pType) {
        this.mValue = TypedValue.getBytes(pValue.toString());
        this.mType = NamePageHash.generateHashForString(pType.getStringRepr());
    }

    public AtomicValue(String pValue, @Nonnull Type pType) {
        this.mValue = TypedValue.getBytes(pValue);
        this.mType = NamePageHash.generateHashForString(pType.getStringRepr());
    }

    public void setNodeKey(long pItemKey) {
        this.mItemKey = pItemKey;
    }

    @Override
    public long getParentKey() {
        return Fixed.NULL_NODE_KEY.getStandardProperty();
    }

    @Override
    public boolean hasParent() {
        return false;
    }

    @Override
    public long getNodeKey() {
        return this.mItemKey;
    }

    @Override
    public Kind getKind() {
        return Kind.ATOMIC;
    }

    public boolean isFullText() {
        return false;
    }

    public boolean isFullTextLeaf() {
        return false;
    }

    public boolean isFullTextRoot() {
        return false;
    }

    @Override
    public final int getTypeKey() {
        return this.mType;
    }

    public final String getType() {
        return Type.getType(this.mType).getStringRepr();
    }

    public int getInt() {
        return (int)this.getDBL();
    }

    public boolean getBool() {
        return Boolean.parseBoolean(new String(this.mValue));
    }

    public float getFLT() {
        return Float.parseFloat(new String(this.mValue));
    }

    public double getDBL() {
        return Double.parseDouble(new String(this.mValue));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Atomic Value: ");
        builder.append(new String(this.mValue));
        builder.append("\nKey: ");
        builder.append(this.mItemKey);
        return builder.toString();
    }

    @Override
    public void setHash(long pHash) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getHash() {
        return 0L;
    }

    public AtomicValue clone() {
        return this;
    }

    @Override
    public void setParentKey(long pKey) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTypeKey(int pType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public byte[] getRawValue() {
        return this.mValue;
    }

    @Override
    public void setValue(byte[] pVal) {
        this.mValue = (byte[])Preconditions.checkNotNull((Object)pVal);
    }

    @Override
    public boolean isSameItem(@Nullable Node pOther) {
        return false;
    }

    @Override
    public long getRevision() {
        return -1L;
    }

    @Override
    public void setDeweyID(SirixDeweyID id) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getValue() {
        return new String(this.mValue, Constants.DEFAULT_ENCODING);
    }

    @Override
    public Optional<SirixDeweyID> getDeweyID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VisitResult acceptVisitor(XmlNodeVisitor visitor) {
        throw new UnsupportedOperationException();
    }
}

