/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath;

import org.sirix.api.Axis;
import org.sirix.axis.AncestorAxis;
import org.sirix.axis.ChildAxis;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.FollowingAxis;
import org.sirix.axis.FollowingSiblingAxis;
import org.sirix.axis.NestedAxis;
import org.sirix.axis.ParentAxis;
import org.sirix.axis.PrecedingAxis;
import org.sirix.axis.PrecedingSiblingAxis;
import org.sirix.axis.filter.FilterAxis;
import org.sirix.service.xml.xpath.DupState;
import org.sirix.service.xml.xpath.OrdState;
import org.sirix.service.xml.xpath.expr.UnionAxis;
import org.sirix.service.xml.xpath.filter.DupFilterAxis;

public class ExpressionSingle {
    private int mNumber = 0;
    private Axis mFirstAxis;
    private Axis mExpr;
    private OrdState mOrd = OrdState.MAX1;
    private DupState mDup;

    public ExpressionSingle() {
        this.mOrd.init();
        this.mDup = DupState.MAX1;
    }

    public void add(Axis pAx) {
        Axis axis = pAx;
        if (this.isDupOrd(axis)) {
            axis = new DupFilterAxis(axis.asXdmNodeReadTrx(), axis);
            DupState.nodup = true;
        }
        switch (this.mNumber) {
            case 0: {
                this.mFirstAxis = axis;
                ++this.mNumber;
                break;
            }
            case 1: {
                this.mExpr = new NestedAxis(this.mFirstAxis, axis);
                ++this.mNumber;
                break;
            }
            default: {
                Axis cache = this.mExpr;
                this.mExpr = new NestedAxis(cache, axis);
            }
        }
    }

    public Axis getExpr() {
        return this.mNumber == 1 ? this.mFirstAxis : this.mExpr;
    }

    public int getSize() {
        return this.mNumber;
    }

    public boolean isDupOrd(Axis ax) {
        Axis axis = ax;
        while (axis instanceof FilterAxis) {
            axis = ((FilterAxis)axis).getAxis();
        }
        if (axis instanceof UnionAxis) {
            this.mOrd = this.mOrd.updateOrdUnion();
            this.mDup = this.mDup.updateUnion();
        } else if (axis instanceof ChildAxis) {
            this.mOrd = this.mOrd.updateOrdChild();
            this.mDup = this.mDup.updateDupChild();
        } else if (axis instanceof ParentAxis) {
            this.mOrd = this.mOrd.updateOrdParent();
            this.mDup = this.mDup.updateDupParent();
        } else if (axis instanceof DescendantAxis) {
            this.mOrd = this.mOrd.updateOrdDesc();
            this.mDup = this.mDup.updateDupDesc();
        } else if (axis instanceof AncestorAxis) {
            this.mOrd = this.mOrd.updateOrdAncestor();
            this.mDup = this.mDup.updateDupAncestor();
        } else if (axis instanceof FollowingAxis || axis instanceof PrecedingAxis) {
            this.mOrd = this.mOrd.updateOrdFollPre();
            this.mDup = this.mDup.updateDupFollPre();
        } else if (axis instanceof FollowingSiblingAxis || axis instanceof PrecedingSiblingAxis) {
            this.mOrd = this.mOrd.updateOrdFollPreSib();
            this.mDup = this.mDup.updateDupFollPreSib();
        }
        return !DupState.nodup;
    }

    public boolean isOrdered() {
        return this.mOrd != OrdState.UNORD && OrdState.mOrdRank == 0;
    }
}

