/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sirix.api.ItemList;
import org.sirix.service.xml.xpath.AtomicValue;

public final class ItemListImpl
implements ItemList<AtomicValue> {
    private final List<AtomicValue> mList = new ArrayList<AtomicValue>();

    @Override
    public int addItem(AtomicValue item) {
        int key = this.mList.size();
        item.setNodeKey(key);
        int itemKey = (key + 2) * -1;
        item.setNodeKey(itemKey);
        this.mList.add(item);
        return itemKey;
    }

    @Override
    public Optional<AtomicValue> getItem(long key) {
        assert (key <= Integer.MAX_VALUE);
        int index = (int)key;
        if (index < 0) {
            index *= -1;
        }
        if ((index -= 2) >= 0 && index < this.mList.size()) {
            return Optional.of(this.mList.get(index));
        }
        return Optional.empty();
    }

    @Override
    public int size() {
        return this.mList.size();
    }

    public String toString() {
        return "ItemList: " + this.mList.toString();
    }
}

