/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.expr;

import java.util.HashSet;
import java.util.Set;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.service.xml.xpath.AbstractAxis;
import org.sirix.service.xml.xpath.XPathError;

public class IntersectAxis
extends AbstractAxis {
    private final Axis mOp1;
    private final Axis mOp2;
    private final Set<Long> mDupSet;

    public IntersectAxis(XmlNodeReadOnlyTrx rtx, Axis mOperand1, Axis mOperand2) {
        super(rtx);
        this.mOp1 = mOperand1;
        this.mOp2 = mOperand2;
        this.mDupSet = new HashSet<Long>();
    }

    @Override
    public void reset(long mNodeKey) {
        super.reset(mNodeKey);
        if (this.mDupSet != null) {
            this.mDupSet.clear();
        }
        if (this.mOp1 != null) {
            this.mOp1.reset(mNodeKey);
        }
        if (this.mOp2 != null) {
            this.mOp2.reset(mNodeKey);
        }
    }

    @Override
    public boolean hasNext() {
        this.resetToLastKey();
        while (this.mOp1.hasNext()) {
            this.mKey = (Long)this.mOp1.next();
            if (this.asXdmNodeReadTrx().getNodeKey() < 0L) {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
            this.mDupSet.add(this.asXdmNodeReadTrx().getNodeKey());
        }
        while (this.mOp2.hasNext()) {
            this.mKey = (Long)this.mOp2.next();
            if (this.asXdmNodeReadTrx().getNodeKey() < 0L) {
                throw new XPathError(XPathError.ErrorType.XPTY0004);
            }
            if (this.mDupSet.add(this.asXdmNodeReadTrx().getNodeKey())) continue;
            return true;
        }
        return false;
    }
}

