/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.functions.sequences;

import java.util.List;
import org.sirix.api.Axis;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.exception.SirixXPathException;
import org.sirix.service.xml.xpath.EXPathError;
import org.sirix.service.xml.xpath.functions.AbstractFunction;
import org.sirix.service.xml.xpath.types.Type;
import org.sirix.utils.TypedValue;

public class FNBoolean
extends AbstractFunction {
    public FNBoolean(XmlNodeReadOnlyTrx rtx, List<Axis> args, int min, int max, int returnType) throws SirixXPathException {
        super(rtx, args, min, max, returnType);
    }

    @Override
    protected byte[] computeResult() throws SirixXPathException {
        Axis axis = this.getArgs().get(0);
        boolean value = false;
        if (axis.hasNext()) {
            this.mKey = (Long)axis.next();
            XmlNodeReadOnlyTrx rtx = axis.asXdmNodeReadTrx();
            if (rtx.getNodeKey() >= 0L) {
                value = true;
            } else {
                Type type = Type.getType(rtx.getTypeKey());
                if (type.derivesFrom(Type.BOOLEAN)) {
                    value = Boolean.parseBoolean(rtx.getValue());
                } else if (type.derivesFrom(Type.STRING) || type.derivesFrom(Type.ANY_URI) || type.derivesFrom(Type.UNTYPED_ATOMIC)) {
                    value = rtx.getValue().length() > 0;
                } else if (type.isNumericType()) {
                    double dValue = Double.parseDouble(rtx.getValue());
                    value = !Double.isNaN(dValue) && dValue != 0.0;
                } else {
                    throw EXPathError.FORG0006.getEncapsulatedException();
                }
                if (axis.hasNext()) {
                    throw EXPathError.FORG0006.getEncapsulatedException();
                }
            }
        } else {
            value = false;
        }
        return TypedValue.getBytes(Boolean.toString(value));
    }
}

