/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.service.xml.xpath.parser;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.sirix.api.Axis;
import org.sirix.api.Filter;
import org.sirix.api.xml.XmlNodeReadOnlyTrx;
import org.sirix.axis.AbstractAxis;
import org.sirix.axis.AncestorAxis;
import org.sirix.axis.AttributeAxis;
import org.sirix.axis.ChildAxis;
import org.sirix.axis.DescendantAxis;
import org.sirix.axis.FollowingAxis;
import org.sirix.axis.FollowingSiblingAxis;
import org.sirix.axis.IncludeSelf;
import org.sirix.axis.ParentAxis;
import org.sirix.axis.PrecedingAxis;
import org.sirix.axis.PrecedingSiblingAxis;
import org.sirix.axis.SelfAxis;
import org.sirix.axis.filter.AbstractFilter;
import org.sirix.axis.filter.FilterAxis;
import org.sirix.axis.filter.NestedFilter;
import org.sirix.axis.filter.xml.AttributeFilter;
import org.sirix.axis.filter.xml.CommentFilter;
import org.sirix.axis.filter.xml.DocumentRootNodeFilter;
import org.sirix.axis.filter.xml.ElementFilter;
import org.sirix.axis.filter.xml.ItemFilter;
import org.sirix.axis.filter.xml.NodeFilter;
import org.sirix.axis.filter.xml.PIFilter;
import org.sirix.axis.filter.xml.TextFilter;
import org.sirix.axis.filter.xml.TypeFilter;
import org.sirix.axis.filter.xml.WildcardFilter;
import org.sirix.axis.filter.xml.XdmNameFilter;
import org.sirix.exception.SirixXPathException;
import org.sirix.node.interfaces.ValueNode;
import org.sirix.service.xml.xpath.AtomicValue;
import org.sirix.service.xml.xpath.EXPathError;
import org.sirix.service.xml.xpath.PipelineBuilder;
import org.sirix.service.xml.xpath.SequenceType;
import org.sirix.service.xml.xpath.SingleType;
import org.sirix.service.xml.xpath.filter.DocumentNodeAxis;
import org.sirix.service.xml.xpath.filter.SchemaAttributeFilter;
import org.sirix.service.xml.xpath.filter.SchemaElementFilter;
import org.sirix.service.xml.xpath.parser.TokenType;
import org.sirix.service.xml.xpath.parser.XPathScanner;
import org.sirix.service.xml.xpath.parser.XPathToken;
import org.sirix.utils.TypedValue;

public final class XPathParser {
    private final XmlNodeReadOnlyTrx mRTX;
    private final XPathScanner mScanner;
    private XPathToken mToken;
    private final PipelineBuilder mPipeBuilder;

    public XPathParser(XmlNodeReadOnlyTrx rtx, String mQuery) {
        this.mRTX = rtx;
        this.mScanner = new XPathScanner(mQuery);
        this.mPipeBuilder = new PipelineBuilder();
    }

    public void parseQuery() throws SirixXPathException {
        do {
            this.mToken = this.mScanner.nextToken();
        } while (this.mToken.getType() == TokenType.SPACE);
        this.parseExpression();
        if (this.mToken.getType() != TokenType.END) {
            throw new IllegalStateException("The query has not been processed completely.");
        }
    }

    private void parseExpression() throws SirixXPathException {
        this.mPipeBuilder.addExpr();
        int no = 0;
        do {
            this.parseExprSingle();
            ++no;
        } while (this.is(TokenType.COMMA, true));
        this.mPipeBuilder.finishExpr(this.getTransaction(), no);
    }

    private void parseExprSingle() throws SirixXPathException {
        this.mPipeBuilder.addExpressionSingle();
        String tContent = this.mToken.getContent();
        if ("for".equals(tContent)) {
            this.parseForExpr();
        } else if ("some".equals(tContent) || "every".equals(tContent)) {
            this.parseQuantifiedExpr();
        } else if ("if".equals(tContent)) {
            this.parseIfExpr();
        } else {
            this.parseOrExpr();
        }
    }

    private void parseForExpr() throws SirixXPathException {
        int rangeVarNo = this.parseSimpleForClause();
        this.consume("return", true);
        this.parseExprSingle();
        this.mPipeBuilder.addForExpression(rangeVarNo);
    }

    private int parseSimpleForClause() throws SirixXPathException {
        this.consume("for", true);
        int forCondNo = 0;
        do {
            this.consume(TokenType.DOLLAR, true);
            String varName = this.parseVarName();
            this.consume("in", true);
            this.parseExprSingle();
            this.mPipeBuilder.addVariableExpr(this.getTransaction(), varName);
            ++forCondNo;
        } while (this.is(TokenType.COMMA, true));
        return forCondNo;
    }

    private void parseQuantifiedExpr() throws SirixXPathException {
        boolean isSome = this.is("some", true);
        if (!isSome) {
            this.consume("every", true);
        }
        int varNo = 0;
        do {
            this.consume(TokenType.DOLLAR, true);
            String varName = this.parseVarName();
            this.consume("in", true);
            ++varNo;
            this.parseExprSingle();
            this.mPipeBuilder.addVariableExpr(this.getTransaction(), varName);
        } while (this.is(TokenType.COMMA, true));
        this.consume("satisfies", true);
        this.parseExprSingle();
        this.mPipeBuilder.addQuantifierExpr(this.getTransaction(), isSome, varNo);
    }

    private void parseIfExpr() throws SirixXPathException {
        this.consume("if", true);
        this.consume(TokenType.OPEN_BR, true);
        this.parseExpression();
        this.consume(TokenType.CLOSE_BR, true);
        this.consume("then", true);
        this.parseExprSingle();
        this.consume("else", true);
        this.parseExprSingle();
        this.mPipeBuilder.addIfExpression(this.getTransaction());
    }

    private void parseOrExpr() throws SirixXPathException {
        this.parseAndExpr();
        while (this.is("or", true)) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseAndExpr();
            this.mPipeBuilder.addOrExpression(this.getTransaction());
        }
    }

    private void parseAndExpr() throws SirixXPathException {
        this.parseComparisionExpr();
        while (this.is("and", true)) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseComparisionExpr();
            this.mPipeBuilder.addAndExpression(this.getTransaction());
        }
    }

    private void parseComparisionExpr() throws SirixXPathException {
        this.parseRangeExpr();
        String mComp = this.mToken.getContent();
        if (this.isComp()) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseRangeExpr();
            this.mPipeBuilder.addCompExpression(this.getTransaction(), mComp);
        }
    }

    private boolean isComp() {
        return this.is(TokenType.L_SHIFT, true) || this.is(TokenType.R_SHIFT, true) || this.is(TokenType.EQ, true) || this.is(TokenType.N_EQ, true) || this.is(TokenType.COMP, true) || this.mToken.getType() == TokenType.TEXT && (this.is("ne", true) || this.is("eq", true) || this.is("lt", true) || this.is("le", true) || this.is("gt", true) || this.is("ge", true) || this.is("is", true));
    }

    private void parseRangeExpr() throws SirixXPathException {
        this.parseAdditiveExpr();
        if (this.is("to", true)) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseAdditiveExpr();
            this.mPipeBuilder.addRangeExpr(this.getTransaction());
        }
    }

    private void parseAdditiveExpr() throws SirixXPathException {
        this.parseMultiplicativeExpr();
        String op = this.mToken.getContent();
        while (this.is(TokenType.PLUS, true) || this.is(TokenType.MINUS, true)) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseMultiplicativeExpr();
            this.mPipeBuilder.addOperatorExpression(this.getTransaction(), op);
            op = this.mToken.getContent();
        }
    }

    private void parseMultiplicativeExpr() throws SirixXPathException {
        this.parseUnionExpr();
        String op = this.mToken.getContent();
        while (this.isMultiplication()) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseUnionExpr();
            this.mPipeBuilder.addOperatorExpression(this.getTransaction(), op);
            op = this.mToken.getContent();
        }
    }

    private void parseUnionExpr() throws SirixXPathException {
        this.parseIntersectExceptExpr();
        while (this.is("union", true) || this.is(TokenType.OR, true)) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseIntersectExceptExpr();
            this.mPipeBuilder.addUnionExpression(this.getTransaction());
        }
    }

    private void parseIntersectExceptExpr() throws SirixXPathException {
        this.parseInstanceOfExpr();
        boolean isIntersect = this.mToken.getContent().equals("intersect");
        while (this.is("intersect", true) || this.is("except", true)) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseInstanceOfExpr();
            this.mPipeBuilder.addIntExcExpression(this.getTransaction(), isIntersect);
            isIntersect = this.mToken.getContent().equals("intersect");
        }
    }

    private void parseInstanceOfExpr() throws SirixXPathException {
        this.parseTreatExpr();
        if (this.is("instance", true)) {
            this.consume("of", true);
            this.mPipeBuilder.addInstanceOfExpr(this.getTransaction(), this.parseSequenceType());
        }
    }

    private void parseTreatExpr() throws SirixXPathException {
        this.parseCastableExpr();
        if (this.is("treat", true)) {
            this.consume("as", true);
            this.mPipeBuilder.addTreatExpr(this.getTransaction(), this.parseSequenceType());
        }
    }

    private void parseCastableExpr() throws SirixXPathException {
        this.parseCastExpr();
        if (this.is("castable", true)) {
            this.consume("as", true);
            this.mPipeBuilder.addCastableExpr(this.getTransaction(), this.parseSingleType());
        }
    }

    private void parseCastExpr() throws SirixXPathException {
        this.parseUnaryExpr();
        if (this.is("cast", true)) {
            this.consume("as", true);
            this.mPipeBuilder.addCastExpr(this.getTransaction(), this.parseSingleType());
        }
    }

    private void parseUnaryExpr() throws SirixXPathException {
        boolean isUnaryMinus = false;
        while (this.is(TokenType.PLUS, true) || this.mToken.getType() == TokenType.MINUS) {
            if (!this.is(TokenType.MINUS, true)) continue;
            isUnaryMinus = !isUnaryMinus;
        }
        if (isUnaryMinus) {
            this.mPipeBuilder.addExpressionSingle();
            this.parseValueExpr();
            this.mPipeBuilder.addOperatorExpression(this.getTransaction(), "unary");
        } else {
            this.parseValueExpr();
        }
    }

    private void parseValueExpr() throws SirixXPathException {
        this.parsePathExpr();
    }

    private void parsePathExpr() throws SirixXPathException {
        if (this.is(TokenType.SLASH, true)) {
            this.mPipeBuilder.addStep(new DocumentNodeAxis(this.getTransaction()));
            TokenType type = this.mToken.getType();
            if (type != TokenType.END && type != TokenType.COMMA) {
                this.parseRelativePathExpr();
            }
        } else if (this.is(TokenType.DESC_STEP, true)) {
            this.mPipeBuilder.addStep(new DocumentNodeAxis(this.getTransaction()));
            DescendantAxis mAxis = new DescendantAxis(this.getTransaction(), IncludeSelf.YES);
            this.mPipeBuilder.addStep(mAxis);
            this.parseRelativePathExpr();
        } else {
            this.parseRelativePathExpr();
        }
    }

    private void parseRelativePathExpr() throws SirixXPathException {
        this.parseStepExpr();
        while (this.mToken.getType() == TokenType.SLASH || this.mToken.getType() == TokenType.DESC_STEP) {
            if (this.is(TokenType.DESC_STEP, true)) {
                DescendantAxis axis = new DescendantAxis(this.getTransaction(), IncludeSelf.YES);
                this.mPipeBuilder.addStep(axis);
            } else {
                this.consume(TokenType.SLASH, true);
            }
            this.parseStepExpr();
        }
    }

    private void parseStepExpr() throws SirixXPathException {
        if (this.isFilterExpr()) {
            this.parseFilterExpr();
        } else {
            this.parseAxisStep();
        }
    }

    private boolean isFilterExpr() {
        TokenType type = this.mToken.getType();
        return type == TokenType.DOLLAR || type == TokenType.POINT || type == TokenType.OPEN_BR || this.isFunctionCall() || this.isLiteral();
    }

    private boolean isFunctionCall() {
        return this.mToken.getType() == TokenType.TEXT && !this.isReservedKeyword() && (this.mScanner.lookUpTokens(1).getType() == TokenType.OPEN_BR || this.mScanner.lookUpTokens(1).getType() == TokenType.COLON && this.mScanner.lookUpTokens(3).getType() == TokenType.OPEN_BR);
    }

    private boolean isReservedKeyword() {
        String content = this.mToken.getContent();
        return this.isKindTest() || "item".equals(content) || "if".equals(content) || "empty-sequence".equals(content) || "typeswitch".equals(content);
    }

    private void parseAxisStep() throws SirixXPathException {
        if (this.isReverceStep()) {
            this.parseReverceStep();
        } else {
            this.parseForwardStep();
        }
        this.parsePredicateList();
    }

    private void parseForwardStep() throws SirixXPathException {
        if (this.isForwardAxis()) {
            Axis axis = this.parseForwardAxis();
            Filter<XmlNodeReadOnlyTrx> filter = this.parseNodeTest(axis.getClass() == AttributeAxis.class);
            this.mPipeBuilder.addStep(axis, filter);
        } else {
            AbstractAxis axis = this.parseAbbrevForwardStep();
            this.mPipeBuilder.addStep(axis);
        }
    }

    private Axis parseForwardAxis() throws SirixXPathException {
        AbstractAxis axis;
        if (this.is("child", true)) {
            axis = new ChildAxis(this.getTransaction());
        } else if (this.is("descendant", true)) {
            axis = new DescendantAxis(this.getTransaction());
        } else if (this.is("descendant-or-self", true)) {
            axis = new DescendantAxis(this.getTransaction(), IncludeSelf.YES);
        } else if (this.is("attribute", true)) {
            axis = new AttributeAxis(this.getTransaction());
        } else if (this.is("self", true)) {
            axis = new SelfAxis(this.getTransaction());
        } else if (this.is("following", true)) {
            axis = new FollowingAxis(this.getTransaction());
        } else if (this.is("following-sibling", true)) {
            axis = new FollowingSiblingAxis(this.getTransaction());
        } else {
            this.is("namespace", true);
            throw EXPathError.XPST0010.getEncapsulatedException();
        }
        this.consume(TokenType.COLON, true);
        this.consume(TokenType.COLON, true);
        return axis;
    }

    private boolean isForwardAxis() {
        String content = this.mToken.getContent();
        return this.mToken.getType() == TokenType.TEXT && ("child".equals(content) || "descendant".equals(content) || "descendant-or-self".equals(content) || "attribute".equals(content) || "self".equals(content) || "following".equals(content) || "following-sibling".equals(content) || "namespace".equals(content));
    }

    private AbstractAxis parseAbbrevForwardStep() {
        boolean isAttribute;
        AbstractAxis axis;
        if (this.is(TokenType.AT, true) || this.mToken.getContent().equals("attribute") || this.mToken.getContent().equals("schema-attribute")) {
            axis = new AttributeAxis(this.getTransaction());
            isAttribute = true;
        } else {
            axis = new ChildAxis(this.getTransaction());
            isAttribute = false;
        }
        Filter<XmlNodeReadOnlyTrx> filter = this.parseNodeTest(isAttribute);
        return new FilterAxis<XmlNodeReadOnlyTrx>(axis, filter, new Filter[0]);
    }

    private void parseReverceStep() {
        if (this.mToken.getType() == TokenType.PARENT) {
            AbstractAxis axis = this.parseAbbrevReverseStep();
            this.mPipeBuilder.addStep(axis);
        } else {
            AbstractAxis axis = this.parseReverceAxis();
            Filter<XmlNodeReadOnlyTrx> filter = this.parseNodeTest(axis.getClass() == AttributeAxis.class);
            this.mPipeBuilder.addStep(axis, filter);
        }
    }

    private AbstractAxis parseReverceAxis() {
        AbstractAxis axis;
        if (this.is("parent", true)) {
            axis = new ParentAxis(this.getTransaction());
        } else if (this.is("ancestor", true)) {
            axis = new AncestorAxis(this.getTransaction());
        } else if (this.is("ancestor-or-self", true)) {
            axis = new AncestorAxis(this.getTransaction(), IncludeSelf.YES);
        } else if (this.is("preceding", true)) {
            axis = new PrecedingAxis(this.getTransaction());
        } else {
            this.consume("preceding-sibling", true);
            axis = new PrecedingSiblingAxis(this.getTransaction());
        }
        this.consume(TokenType.COLON, true);
        this.consume(TokenType.COLON, true);
        return axis;
    }

    private AbstractAxis parseAbbrevReverseStep() {
        this.consume(TokenType.PARENT, true);
        return new ParentAxis(this.getTransaction());
    }

    private boolean isReverceStep() {
        TokenType type = this.mToken.getType();
        String content = this.mToken.getContent();
        return type == TokenType.PARENT || type == TokenType.TEXT && ("parent".equals(content) || "ancestor".equals(content) || "preceding".equals(content) || "preceding-sibling".equals(content) || "ancestor-or-self".equals(content));
    }

    private Filter<XmlNodeReadOnlyTrx> parseNodeTest(boolean mIsAtt) {
        Filter filter = this.isKindTest() ? this.parseKindTest() : this.parseNameTest(mIsAtt);
        return filter;
    }

    private Filter parseNameTest(boolean mIsAtt) {
        Filter filter = this.isWildcardNameTest() ? this.parseWildcard(mIsAtt) : new XdmNameFilter(this.getTransaction(), this.parseQName());
        return filter;
    }

    private boolean isWildcardNameTest() {
        return this.mToken.getType() == TokenType.STAR || this.mToken.getType() == TokenType.TEXT && this.mScanner.lookUpTokens(1).getType() == TokenType.COLON && this.mScanner.lookUpTokens(2).getType() == TokenType.STAR;
    }

    private Filter parseWildcard(boolean pIsAtt) {
        WildcardFilter.EType isName = WildcardFilter.EType.PREFIX;
        if (this.is(TokenType.STAR, true)) {
            if (this.is(TokenType.COLON, true)) {
                isName = WildcardFilter.EType.LOCALNAME;
            } else {
                return pIsAtt ? new AttributeFilter(this.getTransaction()) : new ElementFilter(this.getTransaction());
            }
        }
        WildcardFilter filter = new WildcardFilter(this.getTransaction(), this.parseNCName(), isName);
        if (isName == WildcardFilter.EType.PREFIX) {
            this.consume(TokenType.COLON, true);
            this.consume(TokenType.STAR, true);
        }
        return filter;
    }

    private void parseFilterExpr() throws SirixXPathException {
        this.parsePrimaryExpr();
        this.parsePredicateList();
    }

    private void parsePredicateList() throws SirixXPathException {
        while (this.mToken.getType() == TokenType.OPEN_SQP) {
            this.parsePredicate();
        }
    }

    private void parsePredicate() throws SirixXPathException {
        this.consume(TokenType.OPEN_SQP, true);
        this.mPipeBuilder.addExpressionSingle();
        this.parseExpression();
        this.consume(TokenType.CLOSE_SQP, true);
        this.mPipeBuilder.addPredicate(this.getTransaction());
    }

    private void parsePrimaryExpr() throws SirixXPathException {
        if (this.isLiteral()) {
            this.parseLiteral();
        } else if (this.mToken.getType() == TokenType.DOLLAR) {
            this.parseVarRef();
        } else if (this.mToken.getType() == TokenType.OPEN_BR) {
            this.parseParenthesizedExpr();
        } else if (this.mToken.getType() == TokenType.POINT) {
            this.parseContextItemExpr();
        } else if (!this.isReservedKeyword()) {
            this.parseFunctionCall();
        } else {
            throw new IllegalStateException("Found wrong token '" + this.mToken.getContent() + "'.  Token should be either a literal, a variable,a '(', a '.' or a function call.");
        }
    }

    private boolean isLiteral() {
        TokenType type = this.mToken.getType();
        return type == TokenType.SINGLE_QUOTE || type == TokenType.DBL_QUOTE || type == TokenType.VALUE;
    }

    private void parseLiteral() {
        int itemKey;
        if (this.mToken.getType() == TokenType.VALUE || this.mToken.getType() == TokenType.POINT) {
            itemKey = this.parseNumericLiteral();
        } else {
            assert (this.mToken.getType() == TokenType.DBL_QUOTE || this.mToken.getType() == TokenType.SINGLE_QUOTE);
            itemKey = this.parseStringLiteral();
        }
        this.mPipeBuilder.addLiteral(this.getTransaction(), itemKey);
    }

    private int parseNumericLiteral() {
        return this.parseIntegerLiteral();
    }

    private void parseVarRef() {
        this.consume(TokenType.DOLLAR, true);
        String varName = this.parseVarName();
        this.mPipeBuilder.addVarRefExpr(this.getTransaction(), varName);
    }

    private void parseParenthesizedExpr() throws SirixXPathException {
        this.consume(TokenType.OPEN_BR, true);
        if (this.mToken.getType() != TokenType.CLOSE_BR) {
            this.parseExpression();
        }
        this.consume(TokenType.CLOSE_BR, true);
    }

    private void parseContextItemExpr() {
        this.consume(TokenType.POINT, true);
        this.mPipeBuilder.addStep(new SelfAxis(this.getTransaction()));
    }

    private void parseFunctionCall() throws SirixXPathException {
        String funcName = this.parseQName();
        this.consume(TokenType.OPEN_BR, true);
        int num = 0;
        if (this.mToken.getType() != TokenType.CLOSE_BR) {
            do {
                this.parseExprSingle();
                ++num;
            } while (this.is(TokenType.COMMA, true));
        }
        this.consume(TokenType.CLOSE_BR, true);
        this.mPipeBuilder.addFunction(this.getTransaction(), funcName, num);
    }

    private SingleType parseSingleType() throws SirixXPathException {
        String atomicType = this.parseAtomicType();
        boolean intero = this.is(TokenType.INTERROGATION, true);
        return new SingleType(atomicType, intero);
    }

    private SequenceType parseSequenceType() {
        if (this.is("empty-sequence", true)) {
            this.consume(TokenType.OPEN_BR, true);
            this.consume(TokenType.CLOSE_BR, true);
            return new SequenceType();
        }
        Filter filter = this.parseItemType();
        if (this.isWildcard()) {
            char wildcard = this.parseOccuranceIndicator();
            return new SequenceType(filter, wildcard);
        }
        return new SequenceType(filter);
    }

    private boolean isWildcard() {
        TokenType type = this.mToken.getType();
        return type == TokenType.STAR || type == TokenType.PLUS || type == TokenType.INTERROGATION;
    }

    private char parseOccuranceIndicator() {
        int wildcard;
        if (this.is(TokenType.STAR, true)) {
            wildcard = 42;
        } else if (this.is(TokenType.PLUS, true)) {
            wildcard = 43;
        } else {
            this.consume(TokenType.INTERROGATION, true);
            wildcard = 63;
        }
        return (char)wildcard;
    }

    private Filter parseItemType() {
        AbstractFilter filter;
        if (this.isKindTest()) {
            filter = this.parseKindTest();
        } else if (this.is("item", true)) {
            this.consume(TokenType.OPEN_BR, true);
            this.consume(TokenType.CLOSE_BR, true);
            filter = new ItemFilter(this.getTransaction());
        } else {
            String atomic = this.parseAtomicType();
            filter = new TypeFilter(this.getTransaction(), atomic);
        }
        return filter;
    }

    private String parseAtomicType() {
        return this.parseQName();
    }

    private Filter<XmlNodeReadOnlyTrx> parseKindTest() {
        String test = this.mToken.getContent();
        Filter<XmlNodeReadOnlyTrx> filter = "document-node".equals(test) ? this.parseDocumentTest() : ("element".equals(test) ? this.parseElementTest() : ("attribute".equals(test) ? this.parseAttributeTest() : ("schema-element".equals(test) ? this.parseSchemaElementTest() : ("schema-attribute".equals(test) ? this.parseSchemaAttributeTest() : ("processing-instruction".equals(test) ? this.parsePITest() : ("comment".equals(test) ? this.parseCommentTest() : ("text".equals(test) ? this.parseTextTest() : this.parseAnyKindTest())))))));
        return filter;
    }

    private Filter parseAnyKindTest() {
        this.consume("node", true);
        this.consume(TokenType.OPEN_BR, true);
        this.consume(TokenType.CLOSE_BR, true);
        return new NodeFilter(this.getTransaction());
    }

    private boolean isKindTest() {
        String content = this.mToken.getContent();
        return ("node".equals(content) || "attribute".equals(content) || "schema-attribute".equals(content) || "schema-element".equals(content) || "element".equals(content) || "text".equals(content) || "comment".equals(content) || "document-node".equals(content) || "processing-instruction".equals(content)) && this.mScanner.lookUpTokens(1).getType() == TokenType.OPEN_BR;
    }

    private Filter<XmlNodeReadOnlyTrx> parseDocumentTest() {
        this.consume("document-node", true);
        this.consume(TokenType.OPEN_BR, true);
        AbstractFilter filter = new DocumentRootNodeFilter(this.getTransaction());
        if (this.mToken.getContent().equals("element")) {
            Filter<XmlNodeReadOnlyTrx> innerFilter = this.parseElementTest();
            filter = new NestedFilter(this.getTransaction(), List.of(filter, innerFilter));
        } else if (this.mToken.getContent().equals("schema-element")) {
            Filter innerFilter = this.parseSchemaElementTest();
            filter = new NestedFilter(this.getTransaction(), List.of(filter, innerFilter));
        }
        this.consume(TokenType.CLOSE_BR, true);
        return filter;
    }

    private Filter parseTextTest() {
        this.consume("text", true);
        this.consume(TokenType.OPEN_BR, true);
        this.consume(TokenType.CLOSE_BR, true);
        return new TextFilter(this.getTransaction());
    }

    private Filter parseCommentTest() {
        this.consume("comment", true);
        this.consume(TokenType.OPEN_BR, true);
        this.consume(TokenType.CLOSE_BR, true);
        return new CommentFilter(this.getTransaction());
    }

    private Filter parsePITest() {
        this.consume("processing-instruction", true);
        this.consume(TokenType.OPEN_BR, true);
        AbstractFilter filter = new PIFilter(this.getTransaction());
        if (!this.is(TokenType.CLOSE_BR, true)) {
            String stringLiteral;
            if (this.isQuote()) {
                byte[] param = ((ValueNode)this.getTransaction().getItemList().getItem(this.parseStringLiteral()).get()).getRawValue();
                stringLiteral = Arrays.toString(param);
            } else {
                stringLiteral = this.parseNCName();
            }
            this.consume(TokenType.CLOSE_BR, true);
            filter = new NestedFilter(this.getTransaction(), List.of(filter, new XdmNameFilter(this.getTransaction(), stringLiteral)));
        }
        return filter;
    }

    private boolean isQuote() {
        TokenType type = this.mToken.getType();
        return type == TokenType.SINGLE_QUOTE || type == TokenType.DBL_QUOTE;
    }

    private Filter parseAttributeTest() {
        this.consume("attribute", true);
        this.consume(TokenType.OPEN_BR, true);
        AbstractFilter filter = new AttributeFilter(this.getTransaction());
        if (this.mToken.getType() != TokenType.CLOSE_BR) {
            String name = this.parseAttributeNameOrWildcard();
            if (!name.equals("*")) {
                filter = new NestedFilter(this.getTransaction(), List.of(filter, new XdmNameFilter(this.getTransaction(), name)));
            }
            if (this.is(TokenType.COMMA, true)) {
                filter = new NestedFilter(this.getTransaction(), List.of(filter, new TypeFilter(this.getTransaction(), this.parseTypeName())));
            }
        }
        this.consume(TokenType.CLOSE_BR, true);
        return filter;
    }

    private String parseAttributeNameOrWildcard() {
        String name = this.is(TokenType.STAR, true) ? this.mToken.getContent() : this.parseAttributeName();
        return name;
    }

    private Filter parseSchemaAttributeTest() {
        this.consume("schema-attribute", true);
        this.consume(TokenType.OPEN_BR, true);
        SchemaAttributeFilter filter = new SchemaAttributeFilter(this.getTransaction());
        this.consume(TokenType.CLOSE_BR, true);
        return filter;
    }

    private Filter<XmlNodeReadOnlyTrx> parseElementTest() {
        this.consume("element", true);
        this.consume(TokenType.OPEN_BR, true);
        AbstractFilter filter = new ElementFilter(this.getTransaction());
        if (this.mToken.getType() != TokenType.CLOSE_BR) {
            String mName = this.parseElementNameOrWildcard();
            if (!mName.equals("*")) {
                filter = new NestedFilter(this.getTransaction(), List.of(filter, new XdmNameFilter(this.getTransaction(), mName)));
            }
            if (this.is(TokenType.COMMA, true)) {
                filter = new NestedFilter(this.getTransaction(), List.of(filter, new TypeFilter(this.getTransaction(), this.parseTypeName())));
                if (this.is(TokenType.INTERROGATION, true)) {
                    throw new NoSuchElementException("'?' is not supported yet.");
                }
            }
        }
        this.consume(TokenType.CLOSE_BR, true);
        return filter;
    }

    private String parseElementNameOrWildcard() {
        String name = this.is(TokenType.STAR, true) ? this.mToken.getContent() : this.parseElementName();
        return name;
    }

    private Filter parseSchemaElementTest() {
        this.consume("schema-element", true);
        this.consume(TokenType.OPEN_BR, true);
        this.consume(TokenType.CLOSE_BR, true);
        return new SchemaElementFilter(this.getTransaction());
    }

    private String parseAttributeName() {
        return this.parseQName();
    }

    private String parseElementName() {
        return this.parseQName();
    }

    private String parseTypeName() {
        return this.parseQName();
    }

    private int parseIntegerLiteral() {
        boolean isDouble;
        String value = this.mToken.getContent();
        String type = "xs:integer";
        if (this.is(TokenType.VALUE, false)) {
            if (this.mToken.getType() == TokenType.POINT) {
                isDouble = this.mScanner.lookUpTokens(2).getType() == TokenType.E_NUMBER;
                value = this.parseDecimalLiteral(value);
                String string = type = isDouble ? "xs:double" : "xs:decimal";
            }
            if (this.mToken.getType() == TokenType.E_NUMBER) {
                value = this.parseDoubleLiteral(value);
                type = "xs:double";
            }
        } else {
            isDouble = this.mScanner.lookUpTokens(2).getType() == TokenType.E_NUMBER;
            value = this.parseDecimalLiteral("");
            type = isDouble ? "xs:double" : "xs:decimal";
        }
        this.is(TokenType.SPACE, true);
        AtomicValue intLiteral = new AtomicValue(TypedValue.getBytes(value), this.getTransaction().keyForName(type));
        return this.getTransaction().getItemList().addItem(intLiteral);
    }

    private String parseDecimalLiteral(String mValue) {
        this.consume(TokenType.POINT, false);
        Object dValue = mValue;
        if (this.mToken.getType() == TokenType.VALUE) {
            dValue = mValue + "." + this.mToken.getContent();
            this.consume(TokenType.VALUE, false);
            if (this.mToken.getType() == TokenType.E_NUMBER) {
                dValue = this.parseDoubleLiteral((String)dValue);
            }
        }
        return dValue;
    }

    private String parseDoubleLiteral(String mValue) {
        StringBuilder dValue = new StringBuilder(mValue);
        if (this.is(TokenType.E_NUMBER, false)) {
            dValue.append("E");
            dValue.append(this.mToken.getContent());
        }
        if (this.is(TokenType.PLUS, false) || this.is(TokenType.MINUS, false)) {
            dValue.append(this.mToken.getContent());
        }
        this.consume(TokenType.VALUE, true);
        return dValue.toString();
    }

    private int parseStringLiteral() {
        StringBuilder mValue = new StringBuilder();
        if (this.is(TokenType.DBL_QUOTE, true)) {
            while (true) {
                if (this.mToken.getType() != TokenType.DBL_QUOTE) {
                    mValue.append(this.mToken.getContent());
                    this.mToken = this.mScanner.nextToken();
                    continue;
                }
                this.consume(TokenType.DBL_QUOTE, true);
                if (!this.is(TokenType.DBL_QUOTE, true)) break;
            }
        } else {
            this.consume(TokenType.SINGLE_QUOTE, true);
            while (true) {
                if (this.mToken.getType() != TokenType.SINGLE_QUOTE) {
                    mValue.append(this.mToken.getContent());
                    this.mToken = this.mScanner.nextToken();
                    continue;
                }
                this.consume(TokenType.SINGLE_QUOTE, true);
                if (!this.is(TokenType.SINGLE_QUOTE, true)) break;
            }
        }
        AtomicValue mStringLiteral = new AtomicValue(TypedValue.getBytes(mValue.toString()), this.getTransaction().keyForName("xs:string"));
        return this.getTransaction().getItemList().addItem(mStringLiteral);
    }

    private String parseVarName() {
        return this.parseQName();
    }

    private boolean isMultiplication() {
        return this.is(TokenType.STAR, true) || this.is("div", true) || this.is("idiv", true) || this.is("mod", true);
    }

    private String parseQName() {
        Object qName = this.parseNCName();
        if (this.is(TokenType.COLON, false)) {
            qName = (String)qName + ":";
            qName = (String)qName + this.parseNCName();
        }
        return qName;
    }

    private String parseNCName() {
        String ncName = this.mToken.getContent();
        this.consume(TokenType.TEXT, true);
        return ncName;
    }

    private void consume(TokenType mType, boolean mIgnoreWhitespace) {
        if (!this.is(mType, mIgnoreWhitespace)) {
            throw new IllegalStateException("Wrong token after " + this.mScanner.begin() + " at position " + this.mScanner.getPos() + " found " + this.mToken.getType() + " expected " + mType + ".");
        }
    }

    private void consume(String mName, boolean mIgnoreWhitespace) {
        if (!this.is(mName, mIgnoreWhitespace)) {
            throw new IllegalStateException("Wrong token after " + this.mScanner.begin() + " found " + this.mToken.getContent() + ". Expected " + mName);
        }
    }

    private boolean is(String mName, boolean mIgnoreWhitespace) {
        if (!mName.equals(this.mToken.getContent())) {
            return false;
        }
        if (this.mToken.getType() == TokenType.COMP || this.mToken.getType() == TokenType.EQ || this.mToken.getType() == TokenType.N_EQ || this.mToken.getType() == TokenType.PLUS || this.mToken.getType() == TokenType.MINUS || this.mToken.getType() == TokenType.STAR) {
            return this.is(this.mToken.getType(), mIgnoreWhitespace);
        }
        return this.is(TokenType.TEXT, mIgnoreWhitespace);
    }

    private boolean is(TokenType mType, boolean mIgnoreWhitespace) {
        if (mType != this.mToken.getType()) {
            return false;
        }
        this.mToken = this.mScanner.nextToken();
        if (mIgnoreWhitespace) {
            while (this.mToken.getType() == TokenType.SPACE) {
                this.mToken = this.mScanner.nextToken();
            }
        }
        return true;
    }

    public Axis getQueryPipeline() {
        return this.mPipeBuilder.getPipeline();
    }

    private XmlNodeReadOnlyTrx getTransaction() {
        return this.mRTX;
    }
}

