/*
 * Decompiled with CFR 0.152.
 */
package org.sirix.utils;

import org.sirix.settings.Constants;

public final class TypedValue {
    public static final byte[] EMPTY = new byte[0];

    private TypedValue() {
    }

    public static int parseInt(byte[] mBytes) {
        int position = 0;
        int value = mBytes[position++] & 0x7F;
        if ((mBytes[position - 1] & 0x80) != 0) {
            value |= (mBytes[position++] & 0x7F) << 7;
            if ((mBytes[position - 1] & 0x80) != 0) {
                value |= (mBytes[position++] & 0x7F) << 14;
                if ((mBytes[position - 1] & 0x80) != 0) {
                    value |= (mBytes[position++] & 0x7F) << 21;
                    if ((mBytes[position - 1] & 0x80) != 0) {
                        value |= (mBytes[position++] & 0xFF) << 28;
                    } else if ((mBytes[position - 1] & 0x40) != 0) {
                        value |= 0xF0000000;
                    }
                } else if ((mBytes[position - 1] & 0x40) != 0) {
                    value |= 0xFFF00000;
                }
            } else if ((mBytes[position - 1] & 0x40) != 0) {
                value |= 0xFFFFE000;
            }
        } else if ((mBytes[position - 1] & 0x40) != 0) {
            value |= 0xFFFFFFC0;
        }
        return value;
    }

    public static long parseLong(byte[] mBytes) {
        int position = 1;
        long value = mBytes[position++] & 0xFF;
        if (mBytes[position - 2] > 1) {
            value += (long)(mBytes[position++] & 0xFF) << 8;
            if (mBytes[position - 3] > 2) {
                value += (long)(mBytes[position++] & 0xFF) << 16;
                if (mBytes[position - 4] > 3) {
                    value += (long)(mBytes[position++] & 0xFF) << 24;
                    if (mBytes[position - 5] > 4) {
                        value += (long)(mBytes[position++] & 0xFF) << 32;
                        if (mBytes[position - 6] > 5) {
                            value += (long)(mBytes[position++] & 0xFF) << 40;
                            if (mBytes[position - 7] > 6) {
                                value += (long)(mBytes[position++] & 0xFF) << 48;
                                if (mBytes[position - 8] > 7) {
                                    value += (long)mBytes[position++] << 56;
                                } else if ((mBytes[position - 1] & 0x80) != 0) {
                                    value |= 0xFF000000000000L;
                                }
                            } else if ((mBytes[position - 1] & 0x80) != 0) {
                                value |= 0xFFFF000000000000L;
                            }
                        } else if ((mBytes[position - 1] & 0x80) != 0) {
                            value |= 0xFFFFFF0000000000L;
                        }
                    } else if ((mBytes[position - 1] & 0x80) != 0) {
                        value |= 0xFFFFFFFF00000000L;
                    }
                } else if ((mBytes[position - 1] & 0x80) != 0) {
                    value |= 0xFFFFFFFFFF000000L;
                }
            } else if ((mBytes[position - 1] & 0x80) != 0) {
                value |= 0xFFFFFFFFFFFF0000L;
            }
        } else if ((mBytes[position - 1] & 0x80) != 0) {
            value |= 0xFFFFFFFFFFFFFF00L;
        }
        return value;
    }

    public static byte[] getBytes(boolean mValue) {
        byte[] bytes = new byte[]{mValue ? (byte)1 : 0};
        return bytes;
    }

    public static byte[] getBytes(int mValue) {
        byte[] tmpBytes = new byte[5];
        int position = 0;
        tmpBytes[position++] = (byte)mValue;
        if (mValue > 63 || mValue < -64) {
            int n = position - 1;
            tmpBytes[n] = (byte)(tmpBytes[n] | 0x80);
            tmpBytes[position++] = (byte)(mValue >> 7);
            if (mValue > 8191 || mValue < -8192) {
                int n2 = position - 1;
                tmpBytes[n2] = (byte)(tmpBytes[n2] | 0x80);
                tmpBytes[position++] = (byte)(mValue >> 14);
                if (mValue > 1048575 || mValue < -1048576) {
                    int n3 = position - 1;
                    tmpBytes[n3] = (byte)(tmpBytes[n3] | 0x80);
                    tmpBytes[position++] = (byte)(mValue >> 21);
                    if (mValue > 0xFFFFFFF || mValue < -268435456) {
                        int n4 = position - 1;
                        tmpBytes[n4] = (byte)(tmpBytes[n4] | 0x80);
                        tmpBytes[position++] = (byte)(mValue >> 28);
                    } else {
                        int n5 = position - 1;
                        tmpBytes[n5] = (byte)(tmpBytes[n5] & 0x7F);
                    }
                } else {
                    int n6 = position - 1;
                    tmpBytes[n6] = (byte)(tmpBytes[n6] & 0x7F);
                }
            } else {
                int n7 = position - 1;
                tmpBytes[n7] = (byte)(tmpBytes[n7] & 0x7F);
            }
        } else {
            int n = position - 1;
            tmpBytes[n] = (byte)(tmpBytes[n] & 0x7F);
        }
        byte[] bytes = new byte[position];
        System.arraycopy(tmpBytes, 0, bytes, 0, position);
        return bytes;
    }

    public static byte[] getBytes(long value) {
        byte[] tmpBytes = new byte[9];
        int position = 1;
        tmpBytes[position++] = (byte)value;
        if (value > 127L || value < -128L) {
            tmpBytes[position++] = (byte)(value >> 8);
            if (value > 32767L || value < -32768L) {
                tmpBytes[position++] = (byte)(value >>> 16);
                if (value > 0x7FFFFFL || value < -8388608L) {
                    tmpBytes[position++] = (byte)(value >>> 24);
                    if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
                        tmpBytes[position++] = (byte)(value >>> 32);
                        if (value > 36L || value < -37L) {
                            tmpBytes[position++] = (byte)(value >>> 40);
                            if (value > 44L || value < -45L) {
                                tmpBytes[position++] = (byte)(value >>> 48);
                                if (value > 52L || value < -53L) {
                                    tmpBytes[position++] = (byte)(value >>> 56);
                                    tmpBytes[position - 9] = 8;
                                } else {
                                    tmpBytes[position - 8] = 7;
                                }
                            } else {
                                tmpBytes[position - 7] = 6;
                            }
                        } else {
                            tmpBytes[position - 6] = 5;
                        }
                    } else {
                        tmpBytes[position - 5] = 4;
                    }
                } else {
                    tmpBytes[position - 4] = 3;
                }
            } else {
                tmpBytes[position - 3] = 2;
            }
        } else {
            tmpBytes[position - 2] = 1;
        }
        byte[] bytes = new byte[position];
        System.arraycopy(tmpBytes, 0, bytes, 0, position);
        return bytes;
    }

    public static byte[] getBytes(String mValue) {
        byte[] bytes = null;
        try {
            if (mValue == null || mValue.length() == 0) {
                bytes = EMPTY;
            } else {
                StringBuilder builder = new StringBuilder();
                block6: for (int i = 0; i < mValue.length(); ++i) {
                    switch (mValue.charAt(i)) {
                        case '&': {
                            builder.append("&amp;");
                            continue block6;
                        }
                        case '<': {
                            builder.append("&lt;");
                            continue block6;
                        }
                        default: {
                            builder.append(mValue.charAt(i));
                        }
                    }
                }
                bytes = builder.toString().getBytes(Constants.DEFAULT_ENCODING);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not convert String to byte[]: " + e.getLocalizedMessage());
        }
        return bytes;
    }

    public static boolean equals(byte[] mValue1, byte[] mValue2) {
        if (mValue1 == null || mValue2 == null) {
            return false;
        }
        if (mValue1.length != mValue2.length) {
            return false;
        }
        int l = mValue1.length;
        for (int i = 0; i < l; ++i) {
            if (mValue1[i] == mValue2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] mValue1, String mValue2) {
        return TypedValue.equals(mValue1, TypedValue.getBytes(mValue2));
    }

    public static boolean equals(String mValue1, byte[] mValue2) {
        return TypedValue.equals(TypedValue.getBytes(mValue1), mValue2);
    }

    public static boolean equals(String mValue1, String mValue2) {
        return TypedValue.equals(TypedValue.getBytes(mValue1), TypedValue.getBytes(mValue2));
    }

    public static byte[] getBytes(Double mValue) {
        return mValue.toString().getBytes();
    }

    public static byte[] getBytes(Float mValue) {
        return mValue.toString().getBytes();
    }
}

