/*
 * Decompiled with CFR 0.152.
 */
package io.skippy.gradle;

import io.skippy.core.ClassFile;
import io.skippy.core.ClassFileCollector;
import io.skippy.core.Profiler;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;

final class GradleClassFileCollector
implements ClassFileCollector {
    private final Path projectDir;
    private final SourceSetContainer sourceSetContainer;

    GradleClassFileCollector(Path projectDir, SourceSetContainer sourceSetContainer) {
        this.projectDir = projectDir;
        this.sourceSetContainer = sourceSetContainer;
    }

    public List<ClassFile> collect() {
        return (List)Profiler.profile((String)"GradleClassFileCollector#collect", () -> {
            ArrayList<ClassFile> result = new ArrayList<ClassFile>();
            for (SourceSet sourceSet : this.sourceSetContainer) {
                result.addAll(this.collect(sourceSet));
            }
            return result;
        });
    }

    private List<ClassFile> collect(SourceSet sourceSet) {
        Set classesDirs = sourceSet.getOutput().getClassesDirs().getFiles();
        ArrayList<ClassFile> result = new ArrayList<ClassFile>();
        for (File classesDir : classesDirs) {
            result.addAll(this.sort(this.collect(classesDir, classesDir)));
        }
        return result;
    }

    private List<ClassFile> collect(File outputFolder, File directory) {
        LinkedList<ClassFile> result = new LinkedList<ClassFile>();
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    result.addAll(this.collect(outputFolder, file));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                result.add(ClassFile.fromFileSystem((Path)this.projectDir, (Path)outputFolder.toPath(), (Path)file.toPath()));
            }
        }
        return result;
    }

    private List<ClassFile> sort(List<ClassFile> input) {
        return input.stream().sorted().toList();
    }
}

