/*
 * Decompiled with CFR 0.152.
 */
package io.skippy.gradle;

import io.skippy.gradle.SkippyGradleUtils;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestDescriptor;
import org.gradle.api.tasks.testing.TestListener;
import org.gradle.api.tasks.testing.TestResult;

class SkippyAnalyzeTask
extends DefaultTask {
    @Inject
    public SkippyAnalyzeTask() {
        this.setGroup("skippy");
        TestFailedListener testFailedListener = new TestFailedListener();
        this.getProject().getTasks().withType(Test.class, testTask -> testTask.addTestListener((TestListener)testFailedListener));
        this.doLast(task -> SkippyGradleUtils.ifBuildSupportsSkippy(this.getProject(), skippyBuildApi -> {
            for (TestDescriptor failedTest : testFailedListener.failedTests) {
                skippyBuildApi.testFailed(failedTest.getClassName());
            }
            skippyBuildApi.buildFinished();
        }));
    }

    private static class TestFailedListener
    implements TestListener {
        private final List<TestDescriptor> failedTests = new ArrayList<TestDescriptor>();

        private TestFailedListener() {
        }

        public void beforeSuite(TestDescriptor testDescriptor) {
        }

        public void afterSuite(TestDescriptor testDescriptor, TestResult testResult) {
        }

        public void beforeTest(TestDescriptor testDescriptor) {
        }

        public void afterTest(TestDescriptor testDescriptor, TestResult testResult) {
            if (testResult.getResultType() == TestResult.ResultType.FAILURE) {
                this.failedTests.add(testDescriptor);
            }
        }
    }
}

