/*
 * Decompiled with CFR 0.152.
 */
package io.skippy.gradle;

import io.skippy.core.Profiler;
import io.skippy.gradle.SkippyAnalyzeTask;
import io.skippy.gradle.SkippyCleanTask;
import io.skippy.gradle.SkippyGradleUtils;
import io.skippy.gradle.SkippyPluginExtension;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.jacoco.plugins.JacocoPlugin;

final class SkippyPlugin
implements Plugin<Project> {
    SkippyPlugin() {
    }

    public void apply(Project project) {
        Profiler.clear();
        project.getPlugins().apply(JacocoPlugin.class);
        project.getExtensions().create("skippy", SkippyPluginExtension.class, new Object[0]);
        project.getTasks().register("skippyClean", SkippyCleanTask.class);
        project.getTasks().register("skippyAnalyze", SkippyAnalyzeTask.class);
        project.getTasks().withType(Test.class, testTask -> testTask.finalizedBy(new Object[]{"skippyAnalyze"}));
        project.afterEvaluate(action -> SkippyGradleUtils.ifBuildSupportsSkippy(action.getProject(), skippyBuildApi -> skippyBuildApi.buildStarted()));
    }
}

