/*
 * Decompiled with CFR 0.152.
 */
package io.skippy.junit4;

import io.skippy.core.SkippyTestApi;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

class SkipOrExecuteRule
implements TestRule {
    private final SkippyTestApi skippyTestApi;

    public SkipOrExecuteRule() {
        this(SkippyTestApi.INSTANCE);
    }

    SkipOrExecuteRule(SkippyTestApi skippyTestApi) {
        this.skippyTestApi = skippyTestApi;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (!this.executeTest(description.getTestClass())) {
                    throw new AssumptionViolatedException("Test skipped by Skippy.");
                }
                base.evaluate();
            }

            private boolean executeTest(Class<?> testClass) {
                return SkipOrExecuteRule.this.skippyTestApi.testNeedsToBeExecuted(testClass);
            }
        };
    }
}

