/*
 * Decompiled with CFR 0.152.
 */
package io.skippy.maven;

import io.skippy.core.ClassFile;
import io.skippy.core.ClassFileCollector;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.maven.project.MavenProject;

final class MavenClassFileCollector
implements ClassFileCollector {
    private final MavenProject project;

    MavenClassFileCollector(MavenProject project) {
        this.project = project;
    }

    public List<ClassFile> collect() {
        File classesDir = new File(this.project.getBuild().getOutputDirectory());
        File testClassesDir = new File(this.project.getBuild().getTestOutputDirectory());
        ArrayList<ClassFile> result = new ArrayList<ClassFile>();
        result.addAll(this.sort(this.collect(classesDir, classesDir)));
        result.addAll(this.sort(this.collect(testClassesDir, testClassesDir)));
        return result;
    }

    private List<ClassFile> collect(File outputFolder, File searchDirectory) {
        LinkedList<ClassFile> result = new LinkedList<ClassFile>();
        File[] files = searchDirectory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    result.addAll(this.collect(outputFolder, file));
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                result.add(ClassFile.fromFileSystem((Path)this.project.getBasedir().toPath(), (Path)outputFolder.toPath(), (Path)file.toPath()));
            }
        }
        return result;
    }

    private List<ClassFile> sort(List<ClassFile> input) {
        return input.stream().sorted().toList();
    }
}

