/*
 * Decompiled with CFR 0.152.
 */
package io.skippy.maven;

import io.skippy.core.ClassFileCollector;
import io.skippy.core.SkippyBuildApi;
import io.skippy.core.SkippyConfiguration;
import io.skippy.core.SkippyRepository;
import io.skippy.maven.MavenClassFileCollector;
import java.nio.file.Path;
import java.util.Optional;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="buildFinished", defaultPhase=LifecyclePhase.TEST)
public class SkippyBuildFinishedMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    MavenProject project;
    @Parameter(defaultValue="false", property="coverageForSkippedTests")
    private boolean coverageForSkippedTests;
    @Parameter(property="repository")
    private String repository;
    @Parameter(property="predictionModifier")
    private String predictionModifier;
    @Component
    private MavenSession session;

    public void execute() {
        Path projectDir = this.project.getBasedir().toPath();
        SkippyConfiguration skippyConfiguration = new SkippyConfiguration(this.coverageForSkippedTests, Optional.ofNullable(this.repository), Optional.ofNullable(this.predictionModifier));
        SkippyBuildApi skippyApi = new SkippyBuildApi(skippyConfiguration, (ClassFileCollector)new MavenClassFileCollector(this.project), SkippyRepository.getInstance((SkippyConfiguration)skippyConfiguration, (Path)projectDir, (Path)projectDir.resolve(Path.of(this.project.getBuild().getOutputDirectory(), new String[0]).getParent())));
        skippyApi.buildFinished();
    }
}

