/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob;

import io.skodjob.FmfGenerator;
import io.skodjob.MdGenerator;
import io.skodjob.common.Utils;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

@Mojo(name="test-docs-generator", defaultPhase=LifecyclePhase.COMPILE, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DocGeneratorMojo
extends AbstractMojo {
    @Parameter(property="testsPath", defaultValue="./test", required=true, readonly=false)
    String testsPath;
    @Parameter(property="docsPath", defaultValue="./test-docs", required=true, readonly=false)
    String docsPath;
    @Parameter(property="generateDirs", defaultValue="false", required=false, readonly=false)
    boolean generateDirs;
    @Parameter(property="generateFmf", defaultValue="false", readonly=false)
    boolean generateFmf;
    @Parameter(defaultValue="${project}", readonly=true)
    MavenProject project;
    @Parameter(defaultValue="${plugin}", readonly=true)
    PluginDescriptor descriptor;

    public void execute() {
        this.getLog().info((CharSequence)"Starting generator");
        ClassRealm classRealm = this.descriptor.getClassRealm();
        try {
            File classesFiles = new File(this.project.getBuild().getOutputDirectory());
            classRealm.addURL(classesFiles.toURI().toURL());
            classesFiles = new File(this.project.getBuild().getTestOutputDirectory());
            classRealm.addURL(classesFiles.toURI().toURL());
            this.addJarFilesToClassPath(new File(this.project.getBuild().getDirectory()), classRealm);
        }
        catch (MalformedURLException e) {
            this.getLog().error((Throwable)e);
        }
        this.getLog().debug((CharSequence)"Loaded files in classpath:");
        for (URL url : classRealm.getURLs()) {
            this.getLog().debug((CharSequence)url.getFile());
        }
        if (!this.docsPath.endsWith("/")) {
            this.docsPath = this.docsPath + "/";
        }
        Map<String, String> classes = Utils.getTestClassesWithTheirPath(this.testsPath, this.generateDirs);
        for (Map.Entry<String, String> entry : classes.entrySet()) {
            try {
                Class testClass = classRealm.loadClass(entry.getValue());
                String mdDirectoryName = "";
                if (this.generateFmf) {
                    mdDirectoryName = "md/";
                    FmfGenerator.generate(testClass, this.docsPath + "fmf/" + entry.getKey() + ".fmf");
                } else {
                    this.getLog().debug((CharSequence)"Skipping fmf generation");
                }
                MdGenerator.generate(testClass, this.docsPath, mdDirectoryName + entry.getKey() + ".md");
            }
            catch (IOException | ClassNotFoundException ex) {
                this.getLog().warn((CharSequence)String.format("Cannot load %s", entry.getValue()));
                this.getLog().error((Throwable)ex);
            }
        }
        MdGenerator.updateLinksInLabels(this.docsPath);
        this.getLog().info((CharSequence)"Done");
    }

    public void addJarFilesToClassPath(File directory, ClassRealm classRealm) throws MalformedURLException {
        if (!directory.isDirectory()) {
            this.getLog().warn((CharSequence)"Provided file is not a directory.");
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.addJarFilesToClassPath(file, classRealm);
                    continue;
                }
                if (!file.isFile() || !file.getName().toLowerCase(Locale.ROOT).endsWith(".jar")) continue;
                this.getLog().debug((CharSequence)("Found .jar file: " + file.getAbsolutePath()));
                classRealm.addURL(file.toURI().toURL());
            }
        }
    }
}

