/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.common;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class Utils {
    private static final Pattern REMOVE_BEFORE_PACKAGE = Pattern.compile(".*java/");

    private Utils() {
    }

    private static Map<String, String> getClassesForPackage(Map<String, String> classes, Path packagePath, boolean generateDirs) {
        block10: {
            String classPackagePath;
            if (Files.isDirectory(packagePath, new LinkOption[0])) {
                try (Stream<Path> pathStream = Files.list(packagePath);){
                    pathStream.forEach(path -> classes.putAll(Utils.getClassesForPackage(classes, path, generateDirs)));
                    break block10;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            String filename = classPackagePath = packagePath.toAbsolutePath().toString().replaceAll(REMOVE_BEFORE_PACKAGE.toString(), "").replace(".java", "");
            if (!generateDirs) {
                filename = filename.replaceAll("/", ".");
            }
            classes.put(filename, classPackagePath.replaceAll("/", "."));
        }
        return classes;
    }

    public static Map<String, String> getTestClassesWithTheirPath(String filePath, boolean generateDirs) {
        HashMap<String, String> classes = new HashMap<String, String>();
        try (Stream<Path> pathStream = Files.list(Paths.get(filePath, new String[0]));){
            pathStream.forEach(path -> classes.putAll(Utils.getClassesForPackage(classes, path, generateDirs)));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return classes;
    }

    public static PrintWriter createFilesForTestClass(String classFilePath) throws IOException {
        String fileName = classFilePath.substring(classFilePath.lastIndexOf(47) + 1);
        String parentPath = classFilePath.replace(fileName, "");
        File parent = new File(parentPath);
        if (!parent.exists()) {
            parent.mkdirs();
        }
        File classFile = new File(parent, fileName);
        classFile.createNewFile();
        FileWriter write = new FileWriter(classFile);
        return new PrintWriter(write);
    }
}

