/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.skodjob.testframe.LoggerUtils;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.clients.KubeClient;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.clients.cmdClient.Kubectl;
import io.skodjob.testframe.clients.cmdClient.Oc;
import io.skodjob.testframe.interfaces.NamespacedResourceType;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.ResourceCondition;
import io.skodjob.testframe.resources.ResourceItem;
import io.skodjob.testframe.wait.Wait;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;

public class KubeResourceManager {
    private static final Logger LOGGER = LogManager.getLogger(KubeResourceManager.class);
    private static KubeResourceManager instance;
    private static KubeClient client;
    private static KubeCmdClient<?> kubeCmdClient;
    private ResourceType<?>[] resourceTypes;
    private final List<Consumer<HasMetadata>> createCallbacks = new LinkedList<Consumer<HasMetadata>>();
    private final List<Consumer<HasMetadata>> deleteCallbacks = new LinkedList<Consumer<HasMetadata>>();
    private static final ThreadLocal<ExtensionContext> TEST_CONTEXT;
    private static final Map<String, Stack<ResourceItem<?>>> STORED_RESOURCES;

    private KubeResourceManager() {
    }

    public static synchronized KubeResourceManager getInstance() {
        if (instance == null) {
            instance = new KubeResourceManager();
            KubeResourceManager.instance.resourceTypes = new ResourceType[0];
            client = new KubeClient();
            kubeCmdClient = TestFrameEnv.CLIENT_TYPE.equals("kubectl") ? new Kubectl(client.getKubeconfigPath()) : new Oc(client.getKubeconfigPath());
        }
        return instance;
    }

    public static KubeClient getKubeClient() {
        return client;
    }

    public static KubeCmdClient<?> getKubeCmdClient() {
        return kubeCmdClient;
    }

    public static void setTestContext(ExtensionContext context) {
        TEST_CONTEXT.set(context);
    }

    public static ExtensionContext getTestContext() {
        return TEST_CONTEXT.get();
    }

    public final void setResourceTypes(ResourceType<?> ... types) {
        this.resourceTypes = types;
    }

    public final void addCreateCallback(Consumer<HasMetadata> callback) {
        this.createCallbacks.add(callback);
    }

    public final void addDeleteCallback(Consumer<HasMetadata> callback) {
        this.deleteCallbacks.add(callback);
    }

    public List<HasMetadata> readResourcesFromFile(Path file) throws IOException {
        return client.readResourcesFromFile(file);
    }

    public List<HasMetadata> readResourcesFromFile(InputStream is) throws IOException {
        return client.readResourcesFromFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToStack(ResourceItem<?> item) {
        KubeResourceManager kubeResourceManager = this;
        synchronized (kubeResourceManager) {
            STORED_RESOURCES.computeIfAbsent(KubeResourceManager.getTestContext().getDisplayName(), k -> new Stack());
            STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends HasMetadata> void pushToStack(T resource) {
        KubeResourceManager kubeResourceManager = this;
        synchronized (kubeResourceManager) {
            STORED_RESOURCES.computeIfAbsent(KubeResourceManager.getTestContext().getDisplayName(), k -> new Stack());
            STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).push(new ResourceItem<T>(() -> this.deleteResource(new HasMetadata[]{resource}), resource));
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithWait(T ... resources) {
        this.createOrUpdateResource(true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithWait(T ... resources) {
        this.createOrUpdateResource(true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    private <T extends HasMetadata> void createOrUpdateResource(boolean waitReady, boolean allowUpdate, T ... resources) {
        for (Object resource : resources) {
            ResourceType<T> type = this.findResourceType(resource);
            this.pushToStack(resource);
            if (type == null) {
                if (allowUpdate && client.getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    client.getClient().resource(resource).update();
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    client.getClient().resource(resource).create();
                }
                if (waitReady) {
                    Assertions.assertTrue((boolean)this.waitResourceCondition(resource, new ResourceCondition<HasMetadata>(p -> {
                        if (this.isResourceWithReadiness(resource)) {
                            return client.getClient().resource(resource).isReady();
                        }
                        return client.getClient().resource(resource) != null;
                    }, "ready")), (String)String.format("Timed out waiting for %s/%s in %s to be ready", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()));
                }
            } else {
                if (allowUpdate && client.getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    type.update(resource);
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    type.create(resource);
                }
                if (waitReady) {
                    Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.readiness(type)), (String)String.format("Timed out waiting for %s/%s in %s to be ready", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()));
                }
            }
            this.createCallbacks.forEach(callback -> callback.accept(resource));
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResource(T ... resources) {
        for (Object resource : resources) {
            ResourceType<T> type = this.findResourceType(resource);
            LoggerUtils.logResource("Deleting", resource);
            try {
                if (type == null) {
                    client.getClient().resource(resource).delete();
                    Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.deletion()), (String)String.format("Timed out deleting %s/%s in %s", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()));
                } else {
                    if (type instanceof NamespacedResourceType) {
                        ((NamespacedResourceType)type).deleteFromNamespace(resource.getMetadata().getNamespace(), resource.getMetadata().getName());
                    } else {
                        type.delete(resource.getMetadata().getName());
                    }
                    Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.deletion()), (String)String.format("Timed out deleting %s/%s in %s", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()));
                }
            }
            catch (Exception e) {
                if (resource.getMetadata().getNamespace() == null) {
                    LOGGER.error("{} {}/{}", (Object)"Deleting", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)e);
                }
                LOGGER.error("{} {}/{} in {}", (Object)"Deleting", (Object)resource.getKind(), (Object)resource.getMetadata().getName(), (Object)resource.getMetadata().getNamespace(), (Object)e);
            }
            this.deleteCallbacks.forEach(callback -> callback.accept(resource));
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void updateResource(T ... resources) {
        for (T resource : resources) {
            LoggerUtils.logResource("Updating", resource);
            ResourceType<T> type = this.findResourceType(resource);
            if (type != null) {
                if (type instanceof NamespacedResourceType) {
                    ((NamespacedResourceType)type).updateInNamespace(resource.getMetadata().getNamespace(), resource);
                    continue;
                }
                type.update(resource);
                continue;
            }
            client.getClient().resource(resource).update();
        }
    }

    public final <T extends HasMetadata> boolean waitResourceCondition(T resource, ResourceCondition<T> condition) {
        Assertions.assertNotNull(resource);
        Assertions.assertNotNull((Object)resource.getMetadata());
        Assertions.assertNotNull((Object)resource.getMetadata().getName());
        ResourceType type = this.findResourceType(resource);
        boolean[] resourceReady = new boolean[1];
        Wait.until(String.format("Resource condition: %s to be fulfilled for resource %s/%s", condition.conditionName(), resource.getKind(), resource.getMetadata().getName()), TestFrameConstants.GLOBAL_POLL_INTERVAL_MEDIUM, TestFrameConstants.GLOBAL_TIMEOUT, () -> {
            HasMetadata res = (HasMetadata)KubeResourceManager.getKubeClient().getClient().resource(resource).get();
            resourceReady[0] = condition.predicate().test(res);
            return resourceReady[0];
        }, () -> {
            HasMetadata res = (HasMetadata)KubeResourceManager.getKubeClient().getClient().resource(resource).get();
            if (type == null) {
                client.getClient().resource(resource).delete();
            } else {
                type.delete(res.getMetadata().getName());
            }
        });
        return resourceReady[0];
    }

    public void deleteResources() {
        AtomicInteger numberOfResources;
        LoggerUtils.logSeparator();
        if (!STORED_RESOURCES.containsKey(KubeResourceManager.getTestContext().getDisplayName()) || STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).isEmpty()) {
            LOGGER.info("In context {} is everything deleted", (Object)KubeResourceManager.getTestContext().getDisplayName());
        } else {
            LOGGER.info("Deleting all resources for {}", (Object)KubeResourceManager.getTestContext().getDisplayName());
        }
        AtomicInteger atomicInteger = numberOfResources = STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()) != null ? new AtomicInteger(STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).size()) : new AtomicInteger(0);
        while (STORED_RESOURCES.containsKey(KubeResourceManager.getTestContext().getDisplayName()) && numberOfResources.get() > 0) {
            Stack<ResourceItem<?>> s = STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName());
            while (!s.isEmpty()) {
                ResourceItem<?> resourceItem = s.pop();
                try {
                    resourceItem.throwableRunner().run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                numberOfResources.decrementAndGet();
                this.deleteCallbacks.forEach(callback -> {
                    if (resourceItem.resource() != null) {
                        callback.accept(resourceItem.resource());
                    }
                });
            }
        }
        STORED_RESOURCES.remove(KubeResourceManager.getTestContext().getDisplayName());
        LoggerUtils.logSeparator();
    }

    private <T extends HasMetadata> ResourceType<T> findResourceType(T resource) {
        for (ResourceType<?> type : this.resourceTypes) {
            if (!type.getKind().equals(resource.getKind())) continue;
            return type;
        }
        return null;
    }

    private <T extends HasMetadata> boolean isResourceWithReadiness(T resource) {
        return resource instanceof Deployment || resource instanceof io.fabric8.kubernetes.api.model.extensions.Deployment || resource instanceof ReplicaSet || resource instanceof Pod || resource instanceof ReplicationController || resource instanceof Endpoints || resource instanceof Node || resource instanceof StatefulSet;
    }

    static {
        TEST_CONTEXT = new ThreadLocal();
        STORED_RESOURCES = new LinkedHashMap();
    }
}

