/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ImageUtils {
    private static final Logger LOGGER = LogManager.getLogger(ImageUtils.class);
    private static final Pattern IMAGE_PATTERN_FULL_PATH = Pattern.compile("^(?<registry>[^/]*)/(?<org>[^/]*)/(?<image>[^:]*):(?<tag>.*)$");
    private static final Pattern IMAGE_PATTERN = Pattern.compile("^(?<org>[^/]*)/(?<image>[^:]*):(?<tag>.*)$");

    private ImageUtils() {
    }

    public static String changeRegistry(String image, String newRegistry) {
        return ImageUtils.changeRegistryOrgAndTag(image, newRegistry, null, null);
    }

    public static String changeRegistryAndOrg(String image, String newRegistry, String newOrg) {
        return ImageUtils.changeRegistryOrgAndTag(image, newRegistry, newOrg, null);
    }

    public static String changeRegistryAndTag(String image, String newRegistry, String newTag) {
        return ImageUtils.changeRegistryOrgAndTag(image, newRegistry, null, newTag);
    }

    public static String changeOrg(String image, String newOrg) {
        return ImageUtils.changeRegistryOrgAndTag(image, null, newOrg, null);
    }

    public static String changeOrgAndTag(String image, String newOrg, String newTag) {
        return ImageUtils.changeRegistryOrgAndTag(image, null, newOrg, newTag);
    }

    public static String changeTag(String image, String newTag) {
        return ImageUtils.changeRegistryOrgAndTag(image, null, null, newTag);
    }

    public static String changeRegistryOrgAndTag(String image, String newRegistry, String newOrg, String newTag) {
        Matcher m = IMAGE_PATTERN_FULL_PATH.matcher(image);
        if (m.find()) {
            String registry = ImageUtils.setImagePropertiesIfNeeded(m.group("registry"), newRegistry);
            String org = ImageUtils.setImagePropertiesIfNeeded(m.group("org"), newOrg);
            String tag = ImageUtils.setImagePropertiesIfNeeded(m.group("tag"), newTag);
            String newImage = registry + "/" + org + "/" + m.group("image") + ":" + tag;
            LOGGER.info("Updating container image to {}", (Object)newImage);
            return newImage;
        }
        m = IMAGE_PATTERN.matcher(image);
        if (m.find()) {
            Object registry = newRegistry != null ? newRegistry + "/" : "";
            String org = ImageUtils.setImagePropertiesIfNeeded(m.group("org"), newOrg);
            String tag = ImageUtils.setImagePropertiesIfNeeded(m.group("tag"), newTag);
            String newImage = (String)registry + org + "/" + m.group("image") + ":" + tag;
            LOGGER.info("Updating container image to {}", (Object)newImage);
            return newImage;
        }
        return image;
    }

    private static String setImagePropertiesIfNeeded(String currentValue, String newValue) {
        if (newValue != null && !newValue.isEmpty() && !currentValue.equals(newValue)) {
            return newValue;
        }
        return currentValue;
    }
}

