/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients.cmdClient;

import io.skodjob.testframe.clients.cmdClient.BaseCmdKubeClient;
import io.skodjob.testframe.executor.Exec;

public class Kubectl
extends BaseCmdKubeClient<Kubectl> {
    public static final String KUBECTL = "kubectl";

    public Kubectl() {
        this(null);
    }

    public Kubectl(String config) {
        super(config);
    }

    private Kubectl(String futureNamespace, String config) {
        super(config);
        this.namespace = futureNamespace;
    }

    public Kubectl inNamespace(String namespace) {
        return new Kubectl(namespace, this.config);
    }

    @Override
    public String getCurrentNamespace() {
        return this.namespace;
    }

    @Override
    public String defaultOlmNamespace() {
        return "operators";
    }

    @Override
    public String cmd() {
        return KUBECTL;
    }

    @Override
    public String getUsername() {
        return Exec.exec(this.cmd(), "auth", "whoami", "-o", "jsonpath='{.status.userInfo.username}'").out();
    }

    @Override
    public void cordon(String nodeName) {
        Exec.exec(this.cmd(), "cordon", nodeName);
    }

    @Override
    public void uncordon(String nodeName) {
        Exec.exec(this.cmd(), "uncordon", nodeName);
    }

    @Override
    public void drain(String nodeName, boolean ignoreDaemonSets, boolean disableEviction, long timeoutInSeconds) {
        Exec.exec(this.cmd(), "drain", nodeName, "--ignore-daemonsets", String.valueOf(ignoreDaemonSets), "--disable-eviction", String.valueOf(disableEviction), "--timeout", timeoutInSeconds + "s");
    }
}

