/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.clients.KubeClient;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.clients.cmdClient.Kubectl;
import io.skodjob.testframe.clients.cmdClient.Oc;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.ResourceCondition;
import io.skodjob.testframe.resources.ResourceItem;
import io.skodjob.testframe.utils.LoggerUtils;
import io.skodjob.testframe.wait.Wait;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class KubeResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeResourceManager.class);
    private static KubeResourceManager instance;
    private static KubeClient client;
    private static KubeCmdClient<?> kubeCmdClient;
    private ResourceType<?>[] resourceTypes;
    private final List<Consumer<HasMetadata>> createCallbacks = new LinkedList<Consumer<HasMetadata>>();
    private final List<Consumer<HasMetadata>> deleteCallbacks = new LinkedList<Consumer<HasMetadata>>();
    private static final ThreadLocal<ExtensionContext> TEST_CONTEXT;
    private static final Map<String, Stack<ResourceItem<?>>> STORED_RESOURCES;
    private String storeYamlPath = null;

    private KubeResourceManager() {
    }

    @Deprecated
    public static synchronized KubeResourceManager getInstance() {
        return KubeResourceManager.get();
    }

    public static synchronized KubeResourceManager get() {
        if (instance == null) {
            instance = new KubeResourceManager();
            KubeResourceManager.instance.resourceTypes = new ResourceType[0];
            client = new KubeClient();
            kubeCmdClient = TestFrameEnv.CLIENT_TYPE.equals("kubectl") ? new Kubectl(client.getKubeconfigPath()) : new Oc(client.getKubeconfigPath());
        }
        return instance;
    }

    public KubeClient kubeClient() {
        return client;
    }

    public KubeCmdClient<?> kubeCmdClient() {
        return kubeCmdClient;
    }

    public void setTestContext(ExtensionContext context) {
        TEST_CONTEXT.set(context);
    }

    public ExtensionContext getTestContext() {
        return TEST_CONTEXT.get();
    }

    public final void setResourceTypes(ResourceType<?> ... types) {
        this.resourceTypes = types;
    }

    public final void addCreateCallback(Consumer<HasMetadata> callback) {
        this.createCallbacks.add(callback);
    }

    public final void addDeleteCallback(Consumer<HasMetadata> callback) {
        this.deleteCallbacks.add(callback);
    }

    public void setStoreYamlPath(String path) {
        this.storeYamlPath = path;
    }

    public String getStoreYamlPath() {
        return this.storeYamlPath;
    }

    public List<HasMetadata> readResourcesFromFile(Path file) throws IOException {
        return client.readResourcesFromFile(file);
    }

    public List<HasMetadata> readResourcesFromFile(InputStream is) throws IOException {
        return client.readResourcesFromFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToStack(ResourceItem<?> item) {
        KubeResourceManager kubeResourceManager = this;
        synchronized (kubeResourceManager) {
            STORED_RESOURCES.computeIfAbsent(this.getTestContext().getDisplayName(), k -> new Stack());
            STORED_RESOURCES.get(this.getTestContext().getDisplayName()).push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends HasMetadata> void pushToStack(T resource) {
        KubeResourceManager kubeResourceManager = this;
        synchronized (kubeResourceManager) {
            STORED_RESOURCES.computeIfAbsent(this.getTestContext().getDisplayName(), k -> new Stack());
            STORED_RESOURCES.get(this.getTestContext().getDisplayName()).push(new ResourceItem<T>(() -> this.deleteResource(new HasMetadata[]{resource}), resource));
        }
    }

    public void printAllResources(Level logLevel) {
        LOGGER.atLevel(logLevel).log("Printing all managed resources from all test contexts");
        STORED_RESOURCES.forEach((testName, resources) -> {
            LOGGER.atLevel(logLevel).log("Context: {}", testName);
            resources.forEach(resourceItem -> {
                if (resourceItem.resource() != null) {
                    LoggerUtils.logResource("Managed resource:", logLevel, resourceItem.resource());
                }
            });
        });
    }

    public void printCurrentResources(Level logLevel) {
        LOGGER.atLevel(logLevel).log("Printing all managed resources from current test context");
        STORED_RESOURCES.get(this.getTestContext().getDisplayName()).forEach((Consumer<ResourceItem<?>>)((Consumer<ResourceItem>)resourceItem -> {
            if (resourceItem.resource() != null) {
                LoggerUtils.logResource("Managed resource:", logLevel, resourceItem.resource());
            }
        }));
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithWait(T ... resources) {
        this.createOrUpdateResource(false, true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithWait(T ... resources) {
        this.createOrUpdateResource(false, true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceAsyncWait(T ... resources) {
        this.createOrUpdateResource(true, true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceAsyncWait(T ... resources) {
        this.createOrUpdateResource(true, true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    private <T extends HasMetadata> void createOrUpdateResource(boolean async, boolean waitReady, boolean allowUpdate, T ... resources) {
        LinkedList<CompletableFuture<Void>> waitExecutors = new LinkedList<CompletableFuture<Void>>();
        for (Object resource : resources) {
            ResourceType type = this.findResourceType(resource);
            this.pushToStack(resource);
            if (this.storeYamlPath != null) {
                this.writeResourceAsYaml((HasMetadata)resource);
            }
            if (type == null) {
                if (allowUpdate && client.getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    client.getClient().resource(resource).update();
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    client.getClient().resource(resource).create();
                }
                if (waitReady) {
                    CompletableFuture<Void> c = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition((T)resource, new ResourceCondition<HasMetadata>(p -> {
                        if (this.isResourceWithReadiness(resource)) {
                            return client.getClient().resource(resource).isReady();
                        }
                        return client.getClient().resource(resource) != null;
                    }, "ready")), (String)String.format("Timed out waiting for %s/%s in %s to be ready", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace())));
                    if (async) {
                        waitExecutors.add(c);
                    } else {
                        CompletableFuture.allOf(c).join();
                    }
                }
            } else {
                if (allowUpdate && client.getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    type.update(resource);
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    type.create(resource);
                }
                if (waitReady) {
                    long resourceTimeout = Objects.requireNonNullElse(type.getTimeoutForResourceReadiness(), TestFrameConstants.GLOBAL_TIMEOUT_MEDIUM);
                    CompletableFuture<Void> c = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.readiness(type), resourceTimeout), (String)String.format("Timed out waiting for %s/%s in %s to be ready", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace())));
                    if (async) {
                        waitExecutors.add(c);
                    } else {
                        CompletableFuture.allOf(c).join();
                    }
                }
            }
            this.createCallbacks.forEach(callback -> callback.accept(resource));
        }
        if (!waitExecutors.isEmpty()) {
            CompletableFuture.allOf(waitExecutors.toArray(new CompletableFuture[0])).join();
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResource(T ... resources) {
        this.deleteResource(true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResource(boolean async, T ... resources) {
        LinkedList<CompletableFuture<Void>> waitExecutors = new LinkedList<CompletableFuture<Void>>();
        for (Object resource : resources) {
            ResourceType<T> type = this.findResourceType(resource);
            LoggerUtils.logResource("Deleting", resource);
            try {
                if (type == null) {
                    client.getClient().resource(resource).delete();
                    this.decideDeleteWaitAsync((List<CompletableFuture<Void>>)waitExecutors, async, resource);
                } else {
                    type.delete(resource);
                    this.decideDeleteWaitAsync((List<CompletableFuture<Void>>)waitExecutors, async, resource);
                }
            }
            catch (Exception e) {
                if (resource.getMetadata().getNamespace() == null) {
                    LOGGER.error("{} {}/{}", new Object[]{"Deleting", resource.getKind(), resource.getMetadata().getName(), e});
                }
                LOGGER.error("{} {}/{} in {}", new Object[]{"Deleting", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace(), e});
            }
            if (!waitExecutors.isEmpty()) {
                CompletableFuture.allOf(waitExecutors.toArray(new CompletableFuture[0])).join();
            }
            this.deleteCallbacks.forEach(callback -> callback.accept(resource));
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void updateResource(T ... resources) {
        for (T resource : resources) {
            LoggerUtils.logResource("Updating", resource);
            ResourceType<T> type = this.findResourceType(resource);
            if (type != null) {
                type.update(resource);
                continue;
            }
            client.getClient().resource(resource).update();
        }
    }

    public final <T extends HasMetadata> boolean waitResourceCondition(T resource, ResourceCondition<T> condition) {
        return this.waitResourceCondition(resource, condition, TestFrameConstants.GLOBAL_TIMEOUT);
    }

    public final <T extends HasMetadata> boolean waitResourceCondition(T resource, ResourceCondition<T> condition, long resourceTimeout) {
        Assertions.assertNotNull(resource);
        Assertions.assertNotNull((Object)resource.getMetadata());
        Assertions.assertNotNull((Object)resource.getMetadata().getName());
        boolean[] resourceReady = new boolean[1];
        Wait.until(String.format("Resource condition: %s to be fulfilled for resource %s/%s", condition.conditionName(), resource.getKind(), resource.getMetadata().getName()), TestFrameConstants.GLOBAL_POLL_INTERVAL_MEDIUM, resourceTimeout, () -> {
            HasMetadata res = (HasMetadata)this.kubeClient().getClient().resource(resource).get();
            resourceReady[0] = condition.predicate().test(res);
            return resourceReady[0];
        });
        return resourceReady[0];
    }

    public void deleteResources() {
        this.deleteResources(true);
    }

    public void deleteResources(boolean async) {
        AtomicInteger numberOfResources;
        LoggerUtils.logSeparator();
        if (!STORED_RESOURCES.containsKey(this.getTestContext().getDisplayName()) || STORED_RESOURCES.get(this.getTestContext().getDisplayName()).isEmpty()) {
            LOGGER.info("In context {} is everything deleted", (Object)this.getTestContext().getDisplayName());
        } else {
            LOGGER.info("Deleting all resources for {}", (Object)this.getTestContext().getDisplayName());
        }
        AtomicInteger atomicInteger = numberOfResources = STORED_RESOURCES.get(this.getTestContext().getDisplayName()) != null ? new AtomicInteger(STORED_RESOURCES.get(this.getTestContext().getDisplayName()).size()) : new AtomicInteger(0);
        while (STORED_RESOURCES.containsKey(this.getTestContext().getDisplayName()) && numberOfResources.get() > 0) {
            Stack<ResourceItem<?>> s = STORED_RESOURCES.get(this.getTestContext().getDisplayName());
            LinkedList<CompletableFuture<Void>> waitExecutors = new LinkedList<CompletableFuture<Void>>();
            while (!s.isEmpty()) {
                ResourceItem<?> resourceItem = s.pop();
                try {
                    CompletableFuture<Void> c = CompletableFuture.runAsync(() -> {
                        try {
                            resourceItem.throwableRunner().run();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                    if (async) {
                        waitExecutors.add(c);
                    } else {
                        CompletableFuture.allOf(c).join();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                numberOfResources.decrementAndGet();
                this.deleteCallbacks.forEach(callback -> {
                    if (resourceItem.resource() != null) {
                        callback.accept(resourceItem.resource());
                    }
                });
            }
            if (waitExecutors.isEmpty()) continue;
            CompletableFuture.allOf(waitExecutors.toArray(new CompletableFuture[0])).join();
        }
        STORED_RESOURCES.remove(this.getTestContext().getDisplayName());
        LoggerUtils.logSeparator();
    }

    private <T extends HasMetadata> ResourceType<T> findResourceType(T resource) {
        for (ResourceType<?> type : this.resourceTypes) {
            if (!type.getKind().equals(resource.getKind())) continue;
            return type;
        }
        return null;
    }

    private <T extends HasMetadata> boolean isResourceWithReadiness(T resource) {
        return resource instanceof Deployment || resource instanceof io.fabric8.kubernetes.api.model.extensions.Deployment || resource instanceof ReplicaSet || resource instanceof Pod || resource instanceof ReplicationController || resource instanceof Endpoints || resource instanceof Node || resource instanceof StatefulSet;
    }

    private void writeResourceAsYaml(HasMetadata resource) {
        File logDir = Paths.get(this.storeYamlPath, new String[0]).resolve("test-files").resolve(this.getTestContext().getRequiredTestClass().getName()).toFile();
        if (this.getTestContext().getTestMethod().isPresent()) {
            logDir = logDir.toPath().resolve(this.getTestContext().getRequiredTestMethod().getName()).toFile();
        }
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new RuntimeException(String.format("Failed to create root log directories on path: %s", logDir.getAbsolutePath()));
        }
        String r = Serialization.asYaml((Object)resource);
        try {
            Files.writeString(logDir.toPath().resolve(resource.getKind() + "-" + (String)(resource.getMetadata().getNamespace() == null ? "" : resource.getMetadata().getNamespace() + "-") + resource.getMetadata().getName() + ".yaml"), (CharSequence)r, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private <T extends HasMetadata> void decideDeleteWaitAsync(List<CompletableFuture<Void>> waitExecutors, boolean async, T resource) {
        CompletableFuture<Void> c = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.deletion()), (String)String.format("Timed out deleting %s/%s in %s", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace())));
        if (async) {
            waitExecutors.add(c);
        } else {
            CompletableFuture.allOf(c).join();
        }
    }

    static {
        TEST_CONTEXT = new ThreadLocal();
        STORED_RESOURCES = new LinkedHashMap();
    }
}

