/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlan;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanBuilder;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanFluent;
import io.fabric8.openshift.api.model.operatorhub.v1alpha1.InstallPlanList;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.resources.KubeResourceManager;
import io.skodjob.testframe.wait.Wait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubeUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeUtils.class);

    private KubeUtils() {
    }

    public static void approveInstallPlan(String namespaceName, String installPlanName) {
        LOGGER.debug("Approving InstallPlan {}", (Object)installPlanName);
        Wait.until("InstallPlan approval", TestFrameConstants.GLOBAL_POLL_INTERVAL_SHORT, 15000L, () -> {
            try {
                InstallPlan installPlan = ((InstallPlanBuilder)((InstallPlanFluent.SpecNested)new InstallPlanBuilder((InstallPlan)((Resource)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().installPlans().inNamespace(namespaceName)).withName(installPlanName)).get()).editSpec().withApproved()).endSpec()).build();
                ((Resource)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().installPlans().inNamespace(namespaceName)).withName(installPlanName)).patch((Object)installPlan);
                return true;
            }
            catch (Exception ex) {
                LOGGER.error(String.valueOf(ex));
                return false;
            }
        });
    }

    public static InstallPlan getNonApprovedInstallPlan(String namespaceName, String csvPrefix) {
        return ((InstallPlanList)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getOpenShiftClient().operatorHub().installPlans().inNamespace(namespaceName)).list()).getItems().stream().filter(installPlan -> installPlan.getSpec().getApproved() == false && installPlan.getSpec().getClusterServiceVersionNames().toString().contains(csvPrefix)).findFirst().get();
    }

    public static void labelNamespace(String namespace, String key, String value) {
        if (KubeResourceManager.get().kubeClient().namespaceExists(namespace)) {
            Wait.until(String.format("Namespace %s has label: %s", namespace, key), TestFrameConstants.GLOBAL_POLL_INTERVAL_1_SEC, TestFrameConstants.GLOBAL_STABILITY_TIME, () -> {
                try {
                    ((Resource)KubeResourceManager.get().kubeClient().getClient().namespaces().withName(namespace)).edit(n -> ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder(n).editMetadata().addToLabels(key, value)).endMetadata()).build());
                }
                catch (Exception ex) {
                    return false;
                }
                Namespace n2 = (Namespace)((Resource)KubeResourceManager.get().kubeClient().getClient().namespaces().withName(namespace)).get();
                if (n2 != null) {
                    return n2.getMetadata().getLabels().get(key) != null;
                }
                return false;
            });
        }
    }

    public static boolean isOcp() {
        return KubeResourceManager.get().kubeCmdClient().exec(false, false, "api-versions").out().contains("openshift.io");
    }

    public static boolean isMultinode() {
        return ((NodeList)KubeResourceManager.get().kubeClient().getClient().nodes().list()).getItems().size() > 1;
    }
}

