/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.environment;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.skodjob.testframe.utils.LoggerUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEnvironmentVariables {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestEnvironmentVariables.class);
    private final Map<String, String> envMap;
    private final Map<String, String> values = new HashMap<String, String>();
    private Map<String, Object> yamlData = new HashMap<String, Object>();
    private final String configFilePath;
    private static final String CONFIG_FILE_PATH_ENV = "ENV_FILE";

    public TestEnvironmentVariables() {
        this(System.getenv());
    }

    public TestEnvironmentVariables(Map<String, String> envMap) {
        this.envMap = envMap;
        this.configFilePath = envMap.getOrDefault(CONFIG_FILE_PATH_ENV, Paths.get(System.getProperty("user.dir"), "config.yaml").toAbsolutePath().toString());
        this.yamlData = this.loadConfigurationFile();
    }

    public String getOrDefault(String envVarName, String defaultValue) {
        return this.getOrDefault(envVarName, String::toString, defaultValue);
    }

    public <T> T getOrDefault(String envVarName, Function<String, T> converter, T defaultValue) {
        String value = this.envMap.get(envVarName) != null ? this.envMap.get(envVarName) : (Objects.requireNonNull(this.yamlData).get(envVarName) != null ? this.yamlData.get(envVarName).toString() : null);
        T returnValue = defaultValue;
        if (value != null) {
            returnValue = converter.apply(value);
        }
        this.values.put(envVarName, String.valueOf(returnValue));
        return returnValue;
    }

    protected Map<String, Object> loadConfigurationFile() {
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        try {
            File yamlFile = new File(this.configFilePath).getAbsoluteFile();
            return (Map)mapper.readValue(new File(yamlFile.getAbsoluteFile().toString()), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        }
        catch (IOException ex) {
            LOGGER.info("Yaml configuration not provider or not exists");
            return Collections.emptyMap();
        }
    }

    public void saveConfigurationFile(String testLogDir) throws IOException {
        Path logPath = Path.of(testLogDir, new String[0]);
        Files.createDirectories(logPath, new FileAttribute[0]);
        LinkedHashMap<String, String> toSave = new LinkedHashMap<String, String>(this.values);
        ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        mapper.writerWithDefaultPrettyPrinter().writeValue(logPath.resolve("config.yaml").toFile(), toSave);
    }

    public void logEnvironmentVariables() {
        String debugFormat = "{}: {}";
        LoggerUtils.logSeparator("-", 30);
        LOGGER.info("Used environment variables:");
        this.values.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            if (!Objects.equals(entry.getValue(), "null")) {
                LOGGER.info(debugFormat, entry.getKey(), entry.getValue());
            }
        });
        LoggerUtils.logSeparator("-", 30);
    }

    public Map<String, ClusterConfig> discoverClusterConfigs() {
        HashMap<String, ClusterConfig> out = new HashMap<String, ClusterConfig>();
        String defKC = this.getOrDefault("KUBECONFIG", null);
        String defURL = this.getOrDefault("KUBE_URL", null);
        String defTok = this.getOrDefault("KUBE_TOKEN", null);
        if (defKC != null) {
            out.put("default", new ClusterConfig(null, null, defKC));
        } else if (defURL != null && defTok != null) {
            out.put("default", new ClusterConfig(defURL, defTok, null));
        } else {
            out.put("default", new ClusterConfig(null, null, null));
        }
        HashSet<String> keySource = new HashSet<String>(this.envMap.keySet());
        if (this.yamlData != null) {
            keySource.addAll(this.yamlData.keySet());
        }
        keySource.stream().filter(k -> k.startsWith("KUBECONFIG_") || k.startsWith("KUBE_URL_") || k.startsWith("KUBE_TOKEN_")).map(k -> k.substring(k.lastIndexOf(95) + 1).toLowerCase()).distinct().forEach(id -> {
            String kc = this.getOrDefault("KUBECONFIG_" + id.toUpperCase(), null);
            String url = this.getOrDefault("KUBE_URL_" + id.toUpperCase(), null);
            String tok = this.getOrDefault("KUBE_TOKEN_" + id.toUpperCase(), null);
            if (kc != null) {
                out.put((String)id, new ClusterConfig(null, null, kc));
            } else if (url != null && tok != null) {
                out.put((String)id, new ClusterConfig(url, tok, null));
            }
        });
        return Collections.unmodifiableMap(out);
    }

    public record ClusterConfig(String url, String token, String kubeconfigPath) {
    }
}

