/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.listeners;

import io.skodjob.testframe.annotations.TestVisualSeparator;
import io.skodjob.testframe.utils.LoggerUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestVisualSeparatorExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestVisualSeparatorExtension.class);

    private TestVisualSeparatorExtension() {
    }

    public void beforeAll(ExtensionContext extensionContext) {
        this.logSeparator(extensionContext);
        LOGGER.info("TestClass {} STARTED", (Object)extensionContext.getRequiredTestClass().getName());
    }

    public void afterAll(ExtensionContext extensionContext) {
        LOGGER.info("TestClass {} FINISHED", (Object)extensionContext.getRequiredTestClass().getName());
        this.logSeparator(extensionContext);
    }

    public void beforeEach(ExtensionContext extensionContext) {
        this.logSeparator(extensionContext);
        LOGGER.info("Test {}.{} STARTED", (Object)extensionContext.getRequiredTestClass().getName(), (Object)extensionContext.getDisplayName().replace("()", ""));
    }

    public void afterEach(ExtensionContext extensionContext) {
        String state = "SUCCEEDED";
        if (extensionContext.getExecutionException().isPresent()) {
            state = "FAILED";
        }
        LOGGER.info("Test {}.{} {}", new Object[]{extensionContext.getRequiredTestClass().getName(), extensionContext.getDisplayName().replace("()", ""), state});
        this.logSeparator(extensionContext);
    }

    private void logSeparator(ExtensionContext extensionContext) {
        Optional annotation = AnnotationSupport.findAnnotation((AnnotatedElement)extensionContext.getRequiredTestClass(), TestVisualSeparator.class);
        if (annotation.isPresent()) {
            LoggerUtils.logSeparator(((TestVisualSeparator)annotation.get()).separator(), ((TestVisualSeparator)annotation.get()).lineLength());
        } else {
            LoggerUtils.logSeparator();
        }
    }
}

