/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.clients.KubeClient;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.clients.cmdClient.Kubectl;
import io.skodjob.testframe.clients.cmdClient.Oc;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.ResourceCondition;
import io.skodjob.testframe.resources.ResourceItem;
import io.skodjob.testframe.utils.LoggerUtils;
import io.skodjob.testframe.wait.Wait;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class KubeResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeResourceManager.class);
    private static KubeResourceManager instance;
    private static KubeClient client;
    private static KubeCmdClient<?> kubeCmdClient;
    private ResourceType<?>[] resourceTypes;
    private final List<Consumer<HasMetadata>> createCallbacks = new LinkedList<Consumer<HasMetadata>>();
    private final List<Consumer<HasMetadata>> deleteCallbacks = new LinkedList<Consumer<HasMetadata>>();
    private static final ThreadLocal<ExtensionContext> TEST_CONTEXT;
    private static final Map<String, Stack<ResourceItem<?>>> STORED_RESOURCES;
    private static String storeYamlPath;

    private KubeResourceManager() {
    }

    public static synchronized KubeResourceManager getInstance() {
        if (instance == null) {
            instance = new KubeResourceManager();
            KubeResourceManager.instance.resourceTypes = new ResourceType[0];
            client = new KubeClient();
            kubeCmdClient = TestFrameEnv.CLIENT_TYPE.equals("kubectl") ? new Kubectl(client.getKubeconfigPath()) : new Oc(client.getKubeconfigPath());
        }
        return instance;
    }

    public static KubeClient getKubeClient() {
        return client;
    }

    public static KubeCmdClient<?> getKubeCmdClient() {
        return kubeCmdClient;
    }

    public static void setTestContext(ExtensionContext context) {
        TEST_CONTEXT.set(context);
    }

    public static ExtensionContext getTestContext() {
        return TEST_CONTEXT.get();
    }

    public final void setResourceTypes(ResourceType<?> ... types) {
        this.resourceTypes = types;
    }

    public final void addCreateCallback(Consumer<HasMetadata> callback) {
        this.createCallbacks.add(callback);
    }

    public final void addDeleteCallback(Consumer<HasMetadata> callback) {
        this.deleteCallbacks.add(callback);
    }

    public static void setStoreYamlPath(String path) {
        storeYamlPath = path;
    }

    public static String getStoreYamlPath() {
        return storeYamlPath;
    }

    public List<HasMetadata> readResourcesFromFile(Path file) throws IOException {
        return client.readResourcesFromFile(file);
    }

    public List<HasMetadata> readResourcesFromFile(InputStream is) throws IOException {
        return client.readResourcesFromFile(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void pushToStack(ResourceItem<?> item) {
        KubeResourceManager kubeResourceManager = this;
        synchronized (kubeResourceManager) {
            STORED_RESOURCES.computeIfAbsent(KubeResourceManager.getTestContext().getDisplayName(), k -> new Stack());
            STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).push(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T extends HasMetadata> void pushToStack(T resource) {
        KubeResourceManager kubeResourceManager = this;
        synchronized (kubeResourceManager) {
            STORED_RESOURCES.computeIfAbsent(KubeResourceManager.getTestContext().getDisplayName(), k -> new Stack());
            STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).push(new ResourceItem<T>(() -> this.deleteResource(new HasMetadata[]{resource}), resource));
        }
    }

    public void printAllResources(Level logLevel) {
        LOGGER.atLevel(logLevel).log("Printing all managed resources from all test contexts");
        STORED_RESOURCES.forEach((testName, resources) -> {
            LOGGER.atLevel(logLevel).log("Context: {}", testName);
            resources.forEach(resourceItem -> {
                if (resourceItem.resource() != null) {
                    LoggerUtils.logResource("Managed resource:", logLevel, resourceItem.resource());
                }
            });
        });
    }

    public void printCurrentResources(Level logLevel) {
        LOGGER.atLevel(logLevel).log("Printing all managed resources from current test context");
        STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).forEach((Consumer<ResourceItem<?>>)((Consumer<ResourceItem>)resourceItem -> {
            if (resourceItem.resource() != null) {
                LoggerUtils.logResource("Managed resource:", logLevel, resourceItem.resource());
            }
        }));
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithWait(T ... resources) {
        this.createOrUpdateResource(false, true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithWait(T ... resources) {
        this.createOrUpdateResource(false, true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceAsyncWait(T ... resources) {
        this.createOrUpdateResource(true, true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceAsyncWait(T ... resources) {
        this.createOrUpdateResource(true, true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    private <T extends HasMetadata> void createOrUpdateResource(boolean async, boolean waitReady, boolean allowUpdate, T ... resources) {
        LinkedList<CompletableFuture<Void>> waitExecutors = new LinkedList<CompletableFuture<Void>>();
        for (Object resource : resources) {
            ResourceType type = this.findResourceType(resource);
            this.pushToStack(resource);
            if (storeYamlPath != null) {
                this.writeResourceAsYaml((HasMetadata)resource);
            }
            if (type == null) {
                if (allowUpdate && client.getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    client.getClient().resource(resource).update();
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    client.getClient().resource(resource).create();
                }
                if (waitReady) {
                    c = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition((T)resource, new ResourceCondition<HasMetadata>(p -> {
                        if (this.isResourceWithReadiness(resource)) {
                            return client.getClient().resource(resource).isReady();
                        }
                        return client.getClient().resource(resource) != null;
                    }, "ready")), (String)String.format("Timed out waiting for %s/%s in %s to be ready", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace())));
                    if (async) {
                        waitExecutors.add(c);
                    } else {
                        CompletableFuture.allOf(c).join();
                    }
                }
            } else {
                if (allowUpdate && client.getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    type.update(resource);
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    type.create(resource);
                }
                if (waitReady) {
                    c = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.readiness(type)), (String)String.format("Timed out waiting for %s/%s in %s to be ready", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace())));
                    if (async) {
                        waitExecutors.add(c);
                    } else {
                        CompletableFuture.allOf(c).join();
                    }
                }
            }
            this.createCallbacks.forEach(callback -> callback.accept(resource));
        }
        if (!waitExecutors.isEmpty()) {
            CompletableFuture.allOf(waitExecutors.toArray(new CompletableFuture[0])).join();
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResource(T ... resources) {
        LinkedList<CompletableFuture<Void>> waitExecutors = new LinkedList<CompletableFuture<Void>>();
        for (Object resource : resources) {
            ResourceType<T> type = this.findResourceType(resource);
            LoggerUtils.logResource("Deleting", resource);
            try {
                if (type == null) {
                    client.getClient().resource(resource).delete();
                    waitExecutors.add(CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.deletion()), (String)String.format("Timed out deleting %s/%s in %s", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()))));
                } else {
                    type.delete(resource);
                    waitExecutors.add(CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.deletion()), (String)String.format("Timed out deleting %s/%s in %s", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace()))));
                }
            }
            catch (Exception e) {
                if (resource.getMetadata().getNamespace() == null) {
                    LOGGER.error("{} {}/{}", new Object[]{"Deleting", resource.getKind(), resource.getMetadata().getName(), e});
                }
                LOGGER.error("{} {}/{} in {}", new Object[]{"Deleting", resource.getKind(), resource.getMetadata().getName(), resource.getMetadata().getNamespace(), e});
            }
            if (!waitExecutors.isEmpty()) {
                CompletableFuture.allOf(waitExecutors.toArray(new CompletableFuture[0])).join();
            }
            this.deleteCallbacks.forEach(callback -> callback.accept(resource));
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void updateResource(T ... resources) {
        for (T resource : resources) {
            LoggerUtils.logResource("Updating", resource);
            ResourceType<T> type = this.findResourceType(resource);
            if (type != null) {
                type.update(resource);
                continue;
            }
            client.getClient().resource(resource).update();
        }
    }

    public final <T extends HasMetadata> boolean waitResourceCondition(T resource, ResourceCondition<T> condition) {
        Assertions.assertNotNull(resource);
        Assertions.assertNotNull((Object)resource.getMetadata());
        Assertions.assertNotNull((Object)resource.getMetadata().getName());
        ResourceType type = this.findResourceType(resource);
        boolean[] resourceReady = new boolean[1];
        Wait.until(String.format("Resource condition: %s to be fulfilled for resource %s/%s", condition.conditionName(), resource.getKind(), resource.getMetadata().getName()), TestFrameConstants.GLOBAL_POLL_INTERVAL_MEDIUM, TestFrameConstants.GLOBAL_TIMEOUT, () -> {
            HasMetadata res = (HasMetadata)KubeResourceManager.getKubeClient().getClient().resource(resource).get();
            resourceReady[0] = condition.predicate().test(res);
            return resourceReady[0];
        }, () -> {
            HasMetadata res = (HasMetadata)KubeResourceManager.getKubeClient().getClient().resource(resource).get();
            if (type == null) {
                client.getClient().resource(resource).delete();
            } else {
                type.delete(res);
            }
        });
        return resourceReady[0];
    }

    public void deleteResources() {
        AtomicInteger numberOfResources;
        LoggerUtils.logSeparator();
        if (!STORED_RESOURCES.containsKey(KubeResourceManager.getTestContext().getDisplayName()) || STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).isEmpty()) {
            LOGGER.info("In context {} is everything deleted", (Object)KubeResourceManager.getTestContext().getDisplayName());
        } else {
            LOGGER.info("Deleting all resources for {}", (Object)KubeResourceManager.getTestContext().getDisplayName());
        }
        AtomicInteger atomicInteger = numberOfResources = STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()) != null ? new AtomicInteger(STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName()).size()) : new AtomicInteger(0);
        while (STORED_RESOURCES.containsKey(KubeResourceManager.getTestContext().getDisplayName()) && numberOfResources.get() > 0) {
            Stack<ResourceItem<?>> s = STORED_RESOURCES.get(KubeResourceManager.getTestContext().getDisplayName());
            LinkedList<CompletableFuture<Void>> waitExecutors = new LinkedList<CompletableFuture<Void>>();
            while (!s.isEmpty()) {
                ResourceItem<?> resourceItem = s.pop();
                try {
                    waitExecutors.add(CompletableFuture.runAsync(() -> {
                        try {
                            resourceItem.throwableRunner().run();
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }));
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
                numberOfResources.decrementAndGet();
                this.deleteCallbacks.forEach(callback -> {
                    if (resourceItem.resource() != null) {
                        callback.accept(resourceItem.resource());
                    }
                });
            }
            if (waitExecutors.isEmpty()) continue;
            CompletableFuture.allOf(waitExecutors.toArray(new CompletableFuture[0])).join();
        }
        STORED_RESOURCES.remove(KubeResourceManager.getTestContext().getDisplayName());
        LoggerUtils.logSeparator();
    }

    private <T extends HasMetadata> ResourceType<T> findResourceType(T resource) {
        for (ResourceType<?> type : this.resourceTypes) {
            if (!type.getKind().equals(resource.getKind())) continue;
            return type;
        }
        return null;
    }

    private <T extends HasMetadata> boolean isResourceWithReadiness(T resource) {
        return resource instanceof Deployment || resource instanceof io.fabric8.kubernetes.api.model.extensions.Deployment || resource instanceof ReplicaSet || resource instanceof Pod || resource instanceof ReplicationController || resource instanceof Endpoints || resource instanceof Node || resource instanceof StatefulSet;
    }

    private void writeResourceAsYaml(HasMetadata resource) {
        File logDir = Paths.get(storeYamlPath, new String[0]).resolve("test-files").resolve(KubeResourceManager.getTestContext().getRequiredTestClass().getName()).toFile();
        if (KubeResourceManager.getTestContext().getTestMethod().isPresent()) {
            logDir = logDir.toPath().resolve(KubeResourceManager.getTestContext().getRequiredTestMethod().getName()).toFile();
        }
        if (!logDir.exists() && !logDir.mkdirs()) {
            throw new RuntimeException(String.format("Failed to create root log directories on path: %s", logDir.getAbsolutePath()));
        }
        String r = Serialization.asYaml((Object)resource);
        try {
            Files.writeString(logDir.toPath().resolve(resource.getKind() + "-" + (String)(resource.getMetadata().getNamespace() == null ? "" : resource.getMetadata().getNamespace() + "-") + resource.getMetadata().getName() + ".yaml"), (CharSequence)r, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        TEST_CONTEXT = new ThreadLocal();
        STORED_RESOURCES = new LinkedHashMap();
        storeYamlPath = null;
    }
}

