/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.security;

import io.skodjob.testframe.security.CertAndKey;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.asn1.x509.KeyUsage;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class CertAndKeyBuilder {
    public static final int KEY_SIZE = 2048;
    public static final String KEY_PAIR_ALGORITHM = "RSA";
    public static final String SIGNATURE_ALGORITHM = "SHA256WithRSA";
    public static final Duration CERTIFICATE_VALIDITY_PERIOD = Duration.ofDays(30L);
    private final KeyPair keyPair;
    private final CertAndKey caCert;
    private final List<Extension> extensions;
    private X500Name issuer;
    private X500Name subject;

    private CertAndKeyBuilder(KeyPair keyPair, CertAndKey caCert, List<Extension> extensions) {
        this.keyPair = keyPair;
        this.caCert = caCert;
        if (caCert != null) {
            try {
                this.issuer = new JcaX509CertificateHolder(caCert.getCertificate()).getSubject();
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        this.extensions = new ArrayList<Extension>(extensions);
    }

    public static CertAndKeyBuilder rootCaCertBuilder() {
        KeyPair keyPair = CertAndKeyBuilder.generateKeyPair();
        return new CertAndKeyBuilder(keyPair, null, Arrays.asList(new Extension(Extension.keyUsage, true, CertAndKeyBuilder.keyUsage(6)), new Extension(Extension.basicConstraints, true, CertAndKeyBuilder.ca()), new Extension(Extension.subjectKeyIdentifier, false, CertAndKeyBuilder.createSubjectKeyIdentifier(keyPair.getPublic()))));
    }

    public static CertAndKeyBuilder intermediateCaCertBuilder(CertAndKey caCert) {
        KeyPair keyPair = CertAndKeyBuilder.generateKeyPair();
        return new CertAndKeyBuilder(keyPair, caCert, Arrays.asList(new Extension(Extension.keyUsage, true, CertAndKeyBuilder.keyUsage(4)), new Extension(Extension.basicConstraints, true, CertAndKeyBuilder.ca()), new Extension(Extension.subjectKeyIdentifier, false, CertAndKeyBuilder.createSubjectKeyIdentifier(keyPair.getPublic())), new Extension(Extension.authorityKeyIdentifier, false, CertAndKeyBuilder.createAuthorityKeyIdentifier(caCert.getPublicKey()))));
    }

    public static CertAndKeyBuilder appCaCertBuilder(CertAndKey caCert) {
        KeyPair keyPair = CertAndKeyBuilder.generateKeyPair();
        return new CertAndKeyBuilder(keyPair, caCert, Arrays.asList(new Extension(Extension.basicConstraints, true, CertAndKeyBuilder.ca()), new Extension(Extension.subjectKeyIdentifier, false, CertAndKeyBuilder.createSubjectKeyIdentifier(keyPair.getPublic())), new Extension(Extension.authorityKeyIdentifier, false, CertAndKeyBuilder.createAuthorityKeyIdentifier(caCert.getPublicKey()))));
    }

    public static CertAndKeyBuilder endEntityCertBuilder(CertAndKey caCert) {
        KeyPair keyPair = CertAndKeyBuilder.generateKeyPair();
        return new CertAndKeyBuilder(keyPair, caCert, Arrays.asList(new Extension(Extension.keyUsage, true, CertAndKeyBuilder.keyUsage(160)), new Extension(Extension.extendedKeyUsage, false, CertAndKeyBuilder.extendedKeyUsage(KeyPurposeId.id_kp_serverAuth, KeyPurposeId.id_kp_clientAuth)), new Extension(Extension.basicConstraints, true, CertAndKeyBuilder.notCa()), new Extension(Extension.subjectKeyIdentifier, false, CertAndKeyBuilder.createSubjectKeyIdentifier(keyPair.getPublic())), new Extension(Extension.authorityKeyIdentifier, false, CertAndKeyBuilder.createAuthorityKeyIdentifier(caCert.getPublicKey()))));
    }

    public CertAndKeyBuilder withIssuerDn(String issuerDn) {
        this.issuer = new X500Name(issuerDn);
        return this;
    }

    public CertAndKeyBuilder withSubjectDn(String subjectDn) {
        this.subject = new X500Name(subjectDn);
        return this;
    }

    public CertAndKeyBuilder withSanDnsName(String hostName) {
        GeneralName dnsName = new GeneralName(2, hostName);
        byte[] subjectAltName = CertAndKeyBuilder.encode((ASN1Object)GeneralNames.getInstance((Object)new DERSequence((ASN1Encodable)dnsName)));
        this.extensions.add(new Extension(Extension.subjectAlternativeName, false, subjectAltName));
        return this;
    }

    public CertAndKeyBuilder withSanDnsNames(ASN1Encodable[] sanDnsNames) {
        DERSequence subjectAlternativeNames = new DERSequence(sanDnsNames);
        byte[] subjectAltName = CertAndKeyBuilder.encode((ASN1Object)GeneralNames.getInstance((Object)subjectAlternativeNames));
        this.extensions.add(new Extension(Extension.subjectAlternativeName, false, subjectAltName));
        return this;
    }

    public CertAndKey build() {
        try {
            BigInteger certSerialNumber = BigInteger.valueOf(System.currentTimeMillis());
            ContentSigner contentSigner = this.createContentSigner();
            Instant startDate = Instant.now().minus(1L, ChronoUnit.DAYS);
            Instant endDate = startDate.plus(CERTIFICATE_VALIDITY_PERIOD);
            JcaX509v3CertificateBuilder certBuilder = new JcaX509v3CertificateBuilder(this.issuer, certSerialNumber, Date.from(startDate), Date.from(endDate), this.subject, this.keyPair.getPublic());
            for (Extension extension : this.extensions) {
                certBuilder.addExtension(extension);
            }
            X509Certificate certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(certBuilder.build(contentSigner));
            return new CertAndKey(certificate, this.keyPair.getPrivate());
        }
        catch (CertificateException | CertIOException | OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    private ContentSigner createContentSigner() throws OperatorCreationException {
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM);
        if (this.caCert == null) {
            return builder.build(this.keyPair.getPrivate());
        }
        return builder.build(this.caCert.getPrivateKey());
    }

    private static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_PAIR_ALGORITHM, "BC");
            keyPairGenerator.initialize(2048);
            return keyPairGenerator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] keyUsage(int usage) {
        return CertAndKeyBuilder.encode((ASN1Object)new KeyUsage(usage));
    }

    private static byte[] extendedKeyUsage(KeyPurposeId ... usages) {
        return CertAndKeyBuilder.encode((ASN1Object)new ExtendedKeyUsage(usages));
    }

    private static byte[] notCa() {
        return CertAndKeyBuilder.encode((ASN1Object)new BasicConstraints(false));
    }

    private static byte[] ca() {
        return CertAndKeyBuilder.encode((ASN1Object)new BasicConstraints(true));
    }

    private static byte[] createSubjectKeyIdentifier(PublicKey publicKey) {
        JcaX509ExtensionUtils extensionUtils = CertAndKeyBuilder.createExtensionUtils();
        return CertAndKeyBuilder.encode((ASN1Object)extensionUtils.createSubjectKeyIdentifier(publicKey));
    }

    private static byte[] createAuthorityKeyIdentifier(PublicKey publicKey) {
        JcaX509ExtensionUtils extensionUtils = CertAndKeyBuilder.createExtensionUtils();
        return CertAndKeyBuilder.encode((ASN1Object)extensionUtils.createAuthorityKeyIdentifier(publicKey));
    }

    private static byte[] encode(ASN1Object object) {
        try {
            return object.getEncoded();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static JcaX509ExtensionUtils createExtensionUtils() {
        try {
            return new JcaX509ExtensionUtils();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

