/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.security;

import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.wait.Wait;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSsl {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenSsl.class);

    private OpenSsl() {
    }

    public static File generatePrivateKey() {
        return OpenSsl.generatePrivateKey(2048);
    }

    public static File generatePrivateKey(int keyLengthBits) {
        try {
            LOGGER.info("Creating client RSA private key with size of {} bits", (Object)keyLengthBits);
            File privateKey = Files.createTempFile("private-key-", ".pem", new FileAttribute[0]).toFile();
            new OpenSslCommand("genpkey").withOptionAndArgument("-algorithm", "RSA").withOptionAndArgument("-pkeyopt", "rsa_keygen_bits:" + keyLengthBits).withOptionAndArgument("-out", privateKey).execute();
            return privateKey;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File generateCertSigningRequest(File privateKey, String subject) {
        try {
            LOGGER.info("Creating Certificate Signing Request file");
            File csr = Files.createTempFile("csr-", ".pem", new FileAttribute[0]).toFile();
            new OpenSslCommand("req").withOption("-new").withOptionAndArgument("-key", privateKey).withOptionAndArgument("-out", csr).withOptionAndArgument("-subj", subject).execute();
            return csr;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static File generateSignedCert(File csr, File caCrt, File caKey) {
        try {
            LOGGER.info("Creating signed certificate file");
            File cert = Files.createTempFile("signed-cert-", ".pem", new FileAttribute[0]).toFile();
            new OpenSslCommand("x509").withOption("-req").withOptionAndArgument("-in", csr).withOptionAndArgument("-CA", caCrt).withOptionAndArgument("-CAkey", caKey).withOptionAndArgument("-out", cert).withOption("-CAcreateserial").execute();
            OpenSsl.waitForCertIsInValidDateRange(cert);
            return cert;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitForCertIsInValidDateRange(File certificate) {
        String dates = new OpenSslCommand("x509").withOption("-noout").withOption("-dates").withOptionAndArgument("-in", certificate).executeAndReturn().trim().replace("  ", " ");
        String startDate = dates.split("\n")[0].replace("notBefore=", "");
        String endDate = dates.split("\n")[1].replace("notAfter=", "");
        ZoneId gmtZone = ZoneId.of("GMT");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("MMM d[d] HH:mm:ss yyyy z");
        ZonedDateTime notBefore = ZonedDateTime.of(LocalDateTime.parse(startDate, formatter), gmtZone);
        ZonedDateTime notAfter = ZonedDateTime.of(LocalDateTime.parse(endDate, formatter), gmtZone);
        Wait.until("certificate to be in valid date range", TestFrameConstants.POLL_INTERVAL_FOR_RESOURCE_READINESS, TestFrameConstants.GLOBAL_POLL_INTERVAL_LONG, () -> {
            ZonedDateTime now = ZonedDateTime.now(gmtZone);
            return now.isAfter(notBefore.plusSeconds(10L)) && now.isBefore(notAfter.minusSeconds(10L));
        });
    }

    private static class OpenSslCommand {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);

        OpenSslCommand(String command) {
            this("openssl", command);
        }

        OpenSslCommand(String binary, String command) {
            this.pb.command().add(binary);
            this.pb.command().add(command);
        }

        public OpenSslCommand withOption(String option) {
            this.pb.command().add(option);
            return this;
        }

        public OpenSslCommand withOptionAndArgument(String option, File argument) {
            this.pb.command().add(option);
            this.pb.command().add(argument.getAbsolutePath());
            return this;
        }

        public OpenSslCommand withOptionAndArgument(String option, String argument) {
            this.pb.command().add(option);
            this.pb.command().add(argument);
            return this;
        }

        public void execute() {
            this.executeAndReturnOnSuccess(true);
        }

        public String executeAndReturn() {
            return this.executeAndReturnOnSuccess(true);
        }

        public String executeAndReturnOnSuccess(boolean failOnNonZeroOutput) {
            String string;
            Path commandOutput = null;
            try {
                commandOutput = Files.createTempFile("openssl-command-output-", ".txt", new FileAttribute[0]);
                this.pb.redirectErrorStream(true).redirectOutput(commandOutput.toFile());
                LOGGER.debug("Running command: {}", this.pb.command());
                Process process = this.pb.start();
                OutputStream outputStream = process.getOutputStream();
                outputStream.close();
                int exitCode = process.waitFor();
                String outputText = Files.readString(commandOutput, StandardCharsets.UTF_8);
                if (exitCode != 0 && failOnNonZeroOutput) {
                    throw new RuntimeException("Openssl command failed. " + outputText);
                }
                string = outputText;
            }
            catch (IOException | InterruptedException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    OpenSslCommand.removeFile(commandOutput);
                    throw throwable;
                }
            }
            OpenSslCommand.removeFile(commandOutput);
            return string;
        }

        static void removeFile(Path fileToRemove) {
            if (fileToRemove != null && Files.exists(fileToRemove, new LinkOption[0])) {
                try {
                    Files.delete(fileToRemove);
                }
                catch (IOException e) {
                    LOGGER.debug("File could not be removed: {}", (Object)fileToRemove);
                }
            }
        }
    }
}

