/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.apps.StatefulSet;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.clients.KubeClient;
import io.skodjob.testframe.clients.cmdClient.KubeCmdClient;
import io.skodjob.testframe.clients.cmdClient.Kubectl;
import io.skodjob.testframe.clients.cmdClient.Oc;
import io.skodjob.testframe.environment.TestEnvironmentVariables;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.ResourceCondition;
import io.skodjob.testframe.resources.ResourceItem;
import io.skodjob.testframe.utils.LoggerUtils;
import io.skodjob.testframe.wait.Wait;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class KubeResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeResourceManager.class);
    private static final Map<String, TestEnvironmentVariables.ClusterConfig> CLUSTER_CONFIGS = TestFrameEnv.CLUSTER_CONFIGS;
    private String storeYamlPath;
    private final Map<String, ClusterContext<? extends KubeCmdClient<?>>> clientCache = new ConcurrentHashMap();
    private static final ThreadLocal<String> CURRENT_CLUSTER_CONTEXT = ThreadLocal.withInitial(() -> "default");
    private static final ThreadLocal<ExtensionContext> TEST_CONTEXT = new ThreadLocal();
    private static final KubeResourceManager INSTANCE = new KubeResourceManager();
    private ResourceType<?>[] resourceTypes = new ResourceType[0];
    private final List<Consumer<HasMetadata>> createCallbacks = new CopyOnWriteArrayList<Consumer<HasMetadata>>();
    private final List<Consumer<HasMetadata>> deleteCallbacks = new CopyOnWriteArrayList<Consumer<HasMetadata>>();
    private static final Map<String, Map<String, Stack<ResourceItem<?>>>> STORED_RESOURCES = new ConcurrentHashMap();

    private KubeResourceManager() {
    }

    public static KubeResourceManager get() {
        return INSTANCE;
    }

    @Deprecated(since="0.9.0")
    public static KubeResourceManager getInstance() {
        return KubeResourceManager.get();
    }

    public AutoCloseable useContext(String id) {
        String ctxId = Optional.ofNullable(id).orElse("default").toLowerCase();
        if (!CLUSTER_CONFIGS.containsKey(ctxId)) {
            throw new IllegalArgumentException("Unknown context '" + ctxId + "'. Define env vars [KUBE_URL|KUBE_TOKEN|KUBECONFIG]_" + ctxId.toUpperCase());
        }
        LOGGER.info("Switching to context {}", (Object)ctxId);
        String prev = CURRENT_CLUSTER_CONTEXT.get();
        CURRENT_CLUSTER_CONTEXT.set(ctxId);
        return () -> {
            LOGGER.info("Closing context {}", (Object)ctxId);
            CURRENT_CLUSTER_CONTEXT.set(prev);
        };
    }

    private ClusterContext<? extends KubeCmdClient<?>> clusterContext(String id) {
        return this.clientCache.computeIfAbsent(id, cid -> {
            TestEnvironmentVariables.ClusterConfig c = CLUSTER_CONFIGS.get(cid);
            if (c == null) {
                throw new IllegalStateException("Credentials missing for context " + cid);
            }
            KubeClient kube = c.kubeconfigPath() != null ? new KubeClient(c.kubeconfigPath()) : (c.url() != null && c.token() != null ? KubeClient.fromUrlAndToken(c.url(), c.token()) : new KubeClient());
            if (TestFrameEnv.CLIENT_TYPE.equals("kubectl")) {
                Kubectl kubectl = new Kubectl(kube.getKubeconfigPath());
                return new ClusterContext<Kubectl>(kube, kubectl);
            }
            Oc oc = new Oc(kube.getKubeconfigPath());
            return new ClusterContext<Oc>(kube, oc);
        });
    }

    private ClusterContext<? extends KubeCmdClient<?>> clusterContext() {
        return this.clusterContext(CURRENT_CLUSTER_CONTEXT.get());
    }

    public KubeClient kubeClient() {
        return this.clusterContext().kubeClient;
    }

    public <K extends KubeCmdClient<K>> K kubeCmdClient() {
        return this.clusterContext().cmdClient;
    }

    public void setStoreYamlPath(String path) {
        this.storeYamlPath = path;
    }

    public String getStoreYamlPath() {
        return this.storeYamlPath;
    }

    public void setResourceTypes(ResourceType<?> ... types) {
        this.resourceTypes = types;
    }

    public void addCreateCallback(Consumer<HasMetadata> cb) {
        this.createCallbacks.add(cb);
    }

    public void addDeleteCallback(Consumer<HasMetadata> cb) {
        this.deleteCallbacks.add(cb);
    }

    public void setTestContext(ExtensionContext ctx) {
        TEST_CONTEXT.set(ctx);
    }

    public ExtensionContext getTestContext() {
        return TEST_CONTEXT.get();
    }

    public void cleanTestContext() {
        TEST_CONTEXT.remove();
    }

    public void cleanClusterContext() {
        CURRENT_CLUSTER_CONTEXT.remove();
    }

    public <T extends HasMetadata> void pushToStack(T resource) {
        STORED_RESOURCES.computeIfAbsent(CURRENT_CLUSTER_CONTEXT.get(), c -> new ConcurrentHashMap()).computeIfAbsent(this.getTestContext().getDisplayName(), t -> new Stack()).push(new ResourceItem<T>(() -> this.deleteResourceWithWait(new HasMetadata[]{resource}), resource));
    }

    public void pushToStack(ResourceItem<?> item) {
        STORED_RESOURCES.computeIfAbsent(CURRENT_CLUSTER_CONTEXT.get(), c -> new ConcurrentHashMap()).computeIfAbsent(this.getTestContext().getDisplayName(), t -> new Stack()).push(item);
    }

    public List<HasMetadata> readResourcesFromFile(Path file) throws IOException {
        return this.kubeClient().readResourcesFromFile(file);
    }

    public List<HasMetadata> readResourcesFromFile(InputStream is) throws IOException {
        return this.kubeClient().readResourcesFromFile(is);
    }

    public void printAllResources(Level logLevel) {
        LOGGER.atLevel(logLevel).log("Printing all managed resources across all contexts");
        STORED_RESOURCES.forEach((ctxId, byTest) -> {
            LOGGER.atLevel(logLevel).log("Context [{}]", ctxId);
            byTest.forEach((test, stack) -> {
                LOGGER.atLevel(logLevel).log("  Test: {}", test);
                stack.forEach(item -> Optional.ofNullable(item.resource()).ifPresent(r -> LoggerUtils.logResource("Managed resource:", logLevel, r)));
            });
        });
    }

    public void printCurrentResources(Level logLevel) {
        String ctxId = CURRENT_CLUSTER_CONTEXT.get();
        String test = this.getTestContext().getDisplayName();
        LOGGER.atLevel(logLevel).log("Resources in [{}]/{}", (Object)ctxId, (Object)test);
        Optional.ofNullable(STORED_RESOURCES.get(ctxId)).map(m -> (Stack)m.get(test)).ifPresent(stack -> stack.forEach(i -> Optional.ofNullable(i.resource()).ifPresent(r -> LoggerUtils.logResource("Managed resource:", logLevel, r))));
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceWithWait(T ... resources) {
        this.createOrUpdateResource(false, true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithWait(T ... resources) {
        this.createOrUpdateResource(false, true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceWithoutWait(T ... resources) {
        this.createOrUpdateResource(false, false, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createResourceAsyncWait(T ... resources) {
        this.createOrUpdateResource(true, true, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void createOrUpdateResourceAsyncWait(T ... resources) {
        this.createOrUpdateResource(true, true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    private <T extends HasMetadata> void createOrUpdateResource(boolean async, boolean waitReady, boolean allowUpdate, T ... resources) {
        ArrayList<CompletableFuture<Void>> waiters = new ArrayList<CompletableFuture<Void>>();
        for (Object resource : resources) {
            ResourceType type = this.findResourceType(resource);
            this.pushToStack(resource);
            if (this.storeYamlPath != null) {
                this.writeResourceAsYaml((HasMetadata)resource);
            }
            if (type == null) {
                if (allowUpdate && this.kubeClient().getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    this.kubeClient().getClient().resource(resource).update();
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    this.kubeClient().getClient().resource(resource).create();
                }
                if (waitReady) {
                    CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition((T)resource, new ResourceCondition<HasMetadata>(p -> {
                        if (this.isResourceWithReadiness(resource)) {
                            return this.kubeClient().getClient().resource(resource).isReady();
                        }
                        return this.kubeClient().getClient().resource(resource) != null;
                    }, "ready")), (String)("Timed out waiting for " + resource.getKind() + "/" + resource.getMetadata().getName())));
                    if (async) {
                        waiters.add(cf);
                    } else {
                        cf.join();
                    }
                }
            } else {
                if (allowUpdate && this.kubeClient().getClient().resource(resource).get() != null) {
                    LoggerUtils.logResource("Updating", resource);
                    type.update(resource);
                } else {
                    LoggerUtils.logResource("Creating", resource);
                    type.create(resource);
                }
                if (waitReady) {
                    long timeout = Objects.requireNonNullElse(type.getTimeoutForResourceReadiness(), TestFrameConstants.GLOBAL_TIMEOUT_MEDIUM);
                    CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(resource, ResourceCondition.readiness(type), timeout), (String)("Timed out waiting for " + resource.getKind() + "/" + resource.getMetadata().getName())));
                    if (async) {
                        waiters.add(cf);
                    } else {
                        cf.join();
                    }
                }
            }
            this.createCallbacks.forEach(cb -> cb.accept(resource));
        }
        if (!waiters.isEmpty()) {
            CompletableFuture.allOf(waiters.toArray(new CompletableFuture[0])).join();
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResourceAsyncWait(T ... resources) {
        this.deleteResource(true, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResourceWithWait(T ... resources) {
        this.deleteResource(false, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    public final <T extends HasMetadata> void deleteResourceWithoutWait(T ... resources) {
        this.deleteResource(false, false, (HasMetadata[])resources);
    }

    @SafeVarargs
    @Deprecated(since="0.13.0")
    public final <T extends HasMetadata> void deleteResource(T ... resources) {
        this.deleteResource(true, (HasMetadata[])resources);
    }

    @SafeVarargs
    @Deprecated(since="0.13.0")
    public final <T extends HasMetadata> void deleteResource(boolean async, T ... resources) {
        this.deleteResource(async, true, (HasMetadata[])resources);
    }

    @SafeVarargs
    private <T extends HasMetadata> void deleteResource(boolean async, boolean waitForDeletion, T ... resources) {
        ArrayList<CompletableFuture<Void>> waiters = new ArrayList<CompletableFuture<Void>>();
        for (Object resource : resources) {
            ResourceType<T> type = this.findResourceType(resource);
            LoggerUtils.logResource("Deleting", resource);
            try {
                if (type == null) {
                    this.kubeClient().getClient().resource(resource).delete();
                } else {
                    type.delete(resource);
                }
                if (waitForDeletion) {
                    this.decideDeleteWaitAsync((List<CompletableFuture<Void>>)waiters, async, resource);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.deleteCallbacks.forEach(cb -> cb.accept(resource));
        }
        if (!waiters.isEmpty()) {
            CompletableFuture.allOf(waiters.toArray(new CompletableFuture[0])).join();
        }
    }

    @SafeVarargs
    public final <T extends HasMetadata> void updateResource(T ... resources) {
        for (T resource : resources) {
            LoggerUtils.logResource("Updating", resource);
            ResourceType<T> type = this.findResourceType(resource);
            if (type != null) {
                type.update(resource);
                continue;
            }
            this.kubeClient().getClient().resource(resource).update();
        }
    }

    public <T extends HasMetadata> void replaceResourceWithRetries(T resource, Consumer<T> editor) {
        this.replaceResourceWithRetries(resource, editor, 3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T extends HasMetadata> void replaceResourceWithRetries(T resource, Consumer<T> editor, int retries) {
        int attempt = 0;
        while (true) {
            try {
                this.replaceResource(resource, editor);
                return;
            }
            catch (CompletionException ce) {
                RuntimeException re;
                Throwable cause = ce.getCause();
                if (KubeResourceManager.isConflict(cause) && ++attempt < retries) continue;
                throw cause instanceof RuntimeException ? (re = (RuntimeException)cause) : new RuntimeException(cause);
            }
            catch (KubernetesClientException kce) {
                if (!KubeResourceManager.isConflict(kce) || ++attempt >= retries) throw kce;
                continue;
            }
            break;
        }
    }

    private static boolean isConflict(Throwable t) {
        KubernetesClientException kce;
        return t instanceof KubernetesClientException && (kce = (KubernetesClientException)t).getCode() == 409;
    }

    public <T extends HasMetadata> void replaceResource(T resource, Consumer<T> editor) {
        ResourceType<T> type = this.findResourceType(resource);
        if (type != null) {
            type.replace(resource, editor);
        } else {
            HasMetadata current = (HasMetadata)this.kubeClient().getClient().resource(resource).get();
            editor.accept(current);
            this.kubeClient().getClient().resource(current).update();
        }
    }

    public <T extends HasMetadata> boolean waitResourceCondition(T resource, ResourceCondition<T> condition) {
        return this.waitResourceCondition(resource, condition, TestFrameConstants.GLOBAL_TIMEOUT);
    }

    public <T extends HasMetadata> boolean waitResourceCondition(T resource, ResourceCondition<T> condition, long resourceTimeout) {
        Assertions.assertNotNull(resource);
        Assertions.assertNotNull((Object)resource.getMetadata());
        Assertions.assertNotNull((Object)resource.getMetadata().getName());
        boolean[] ready = new boolean[1];
        Wait.until(String.format("Resource condition: %s to be fulfilled for resource %s/%s", condition.conditionName(), resource.getKind(), resource.getMetadata().getName()), TestFrameConstants.GLOBAL_POLL_INTERVAL_MEDIUM, resourceTimeout, () -> {
            HasMetadata r = (HasMetadata)this.kubeClient().getClient().resource(resource).get();
            ready[0] = condition.predicate().test(r);
            return ready[0];
        });
        return ready[0];
    }

    public void deleteResources() {
        this.deleteResources(true);
    }

    public void deleteResources(boolean async) {
        LoggerUtils.logSeparator();
        String ctxId = CURRENT_CLUSTER_CONTEXT.get();
        String testName = this.getTestContext().getDisplayName();
        Map<String, Stack<ResourceItem<?>>> byTest = STORED_RESOURCES.get(ctxId);
        if (byTest == null || byTest.get(testName) == null || byTest.get(testName).isEmpty()) {
            LOGGER.info("No resources to delete for [{}]/{}", (Object)ctxId, (Object)testName);
            return;
        }
        LOGGER.info("Deleting all resources for [{}]/{}", (Object)ctxId, (Object)testName);
        Stack<ResourceItem<?>> stack = byTest.get(testName);
        AtomicInteger count = new AtomicInteger(stack.size());
        ArrayList<CompletableFuture<Void>> waiters = new ArrayList<CompletableFuture<Void>>();
        while (!stack.isEmpty()) {
            ResourceItem<?> item = stack.pop();
            CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> {
                try {
                    item.throwableRunner().run();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            if (async) {
                waiters.add(cf);
            } else {
                cf.join();
            }
            count.decrementAndGet();
            this.deleteCallbacks.forEach(cb -> Optional.ofNullable(item.resource()).ifPresent(cb));
        }
        if (!waiters.isEmpty()) {
            CompletableFuture.allOf(waiters.toArray(new CompletableFuture[0])).join();
        }
        byTest.remove(testName);
        if (byTest.isEmpty()) {
            STORED_RESOURCES.remove(ctxId);
        }
        LoggerUtils.logSeparator();
    }

    private <T extends HasMetadata> ResourceType<T> findResourceType(T resource) {
        for (ResourceType<?> rt : this.resourceTypes) {
            if (!rt.getKind().equals(resource.getKind())) continue;
            return rt;
        }
        return null;
    }

    private <T extends HasMetadata> boolean isResourceWithReadiness(T resource) {
        return resource instanceof Deployment || resource instanceof io.fabric8.kubernetes.api.model.extensions.Deployment || resource instanceof ReplicaSet || resource instanceof Pod || resource instanceof ReplicationController || resource instanceof Endpoints || resource instanceof Node || resource instanceof StatefulSet;
    }

    private void writeResourceAsYaml(HasMetadata res) {
        File dir = Paths.get(this.storeYamlPath, new String[0]).resolve(CURRENT_CLUSTER_CONTEXT.get()).resolve("test-files").resolve(this.getTestContext().getRequiredTestClass().getName()).toFile();
        if (this.getTestContext().getTestMethod().isPresent()) {
            dir = dir.toPath().resolve(this.getTestContext().getRequiredTestMethod().getName()).toFile();
        }
        if (!dir.exists() && !dir.mkdirs()) {
            throw new RuntimeException("Cannot create dir " + String.valueOf(dir));
        }
        String yaml = Serialization.asYaml((Object)res);
        try {
            Files.writeString(dir.toPath().resolve(res.getKind() + "-" + (String)(res.getMetadata().getNamespace() == null ? "" : res.getMetadata().getNamespace() + "-") + res.getMetadata().getName() + ".yaml"), (CharSequence)yaml, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    <T extends HasMetadata> void decideDeleteWaitAsync(List<CompletableFuture<Void>> waiters, boolean async, T res) {
        CompletableFuture<Void> cf = CompletableFuture.runAsync(() -> Assertions.assertTrue((boolean)this.waitResourceCondition(res, ResourceCondition.deletion()), (String)("Timed out deleting " + res.getKind() + "/" + res.getMetadata().getName())));
        if (async) {
            waiters.add(cf);
        } else {
            cf.join();
        }
    }

    private record ClusterContext<K extends KubeCmdClient<K>>(KubeClient kubeClient, K cmdClient) {
    }
}

