/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.batch.v1.Job;
import io.fabric8.kubernetes.api.model.batch.v1.JobCondition;
import io.fabric8.kubernetes.api.model.batch.v1.JobList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ScalableResource;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.resources.KubeResourceManager;
import io.skodjob.testframe.wait.Wait;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JobUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobUtils.class);

    private JobUtils() {
    }

    public static void waitForJobContainingLogMessage(String namespace, String jobName, String logMessage) {
        String jobPodName = KubeResourceManager.get().kubeClient().listPodsByPrefixInName(namespace, jobName).get(0).getMetadata().getName();
        Wait.until("Job contains log message: " + logMessage, TestFrameConstants.GLOBAL_POLL_INTERVAL_LONG, TestFrameConstants.GLOBAL_TIMEOUT, () -> KubeResourceManager.get().kubeClient().getLogsFromPod(namespace, jobPodName).contains(logMessage));
    }

    public static void removeAllJobs(String namespace) {
        ((JobList)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().batch().v1().jobs().inNamespace(namespace)).list()).getItems().forEach(job -> JobUtils.deleteJobWithWait(namespace, job.getMetadata().getName()));
    }

    public static void waitForJobDeletion(String namespace, String jobName) {
        LOGGER.debug("Waiting for Job: {}/{} deletion", (Object)namespace, (Object)jobName);
        Wait.until("deletion of Job: " + namespace + "/" + jobName, TestFrameConstants.GLOBAL_POLL_INTERVAL_1_SEC, TestFrameConstants.GLOBAL_TIMEOUT_MEDIUM, () -> KubeResourceManager.get().kubeClient().listPodsByPrefixInName(namespace, jobName).isEmpty());
        LOGGER.debug("Job: {}/{} was deleted", (Object)namespace, (Object)jobName);
    }

    public static void deleteJobWithWait(String namespace, String jobName) {
        ((ScalableResource)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().batch().v1().jobs().inNamespace(namespace)).withName(jobName)).delete();
        JobUtils.waitForJobDeletion(namespace, jobName);
    }

    public static void waitForJobSuccess(String namespace, String jobName, long timeout) {
        LOGGER.info("Waiting for Job: {}/{} to success", (Object)namespace, (Object)jobName);
        Wait.until("success of Job: " + namespace + "/" + jobName, TestFrameConstants.GLOBAL_POLL_INTERVAL_1_SEC, timeout, () -> ((Job)((ScalableResource)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().batch().v1().jobs().inNamespace(namespace)).withName(jobName)).get()).getStatus().getSucceeded() != null);
    }

    public static void waitForJobFailure(String namespace, String jobName, long timeout) {
        LOGGER.info("Waiting for Job: {}/{} to fail", (Object)namespace, (Object)jobName);
        Wait.until("failure of Job: " + namespace + "/" + jobName, TestFrameConstants.GLOBAL_POLL_INTERVAL_1_SEC, timeout, () -> ((Job)((ScalableResource)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().batch().v1().jobs().inNamespace(namespace)).withName(jobName)).get()).getStatus().getFailed() != null);
    }

    public static void logCurrentJobStatus(String namespace, String jobName) {
        Job currentJob = (Job)((ScalableResource)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().batch().v1().jobs().inNamespace(namespace)).withName(jobName)).get();
        if (currentJob != null && currentJob.getStatus() != null) {
            ArrayList<String> log = new ArrayList<String>(Arrays.asList("job", " status:\n"));
            List conditions = currentJob.getStatus().getConditions();
            log.add("\tActive: " + currentJob.getStatus().getActive());
            log.add("\n\tFailed: " + currentJob.getStatus().getFailed());
            log.add("\n\tReady: " + currentJob.getStatus().getReady());
            log.add("\n\tSucceeded: " + currentJob.getStatus().getSucceeded());
            if (conditions != null) {
                ArrayList<CallSite> conditionList = new ArrayList<CallSite>();
                for (JobCondition condition : conditions) {
                    if (condition.getMessage() == null) continue;
                    conditionList.add((CallSite)((Object)("\t\tType: " + condition.getType() + "\n")));
                    conditionList.add((CallSite)((Object)("\t\tMessage: " + condition.getMessage() + "\n")));
                }
                if (!conditionList.isEmpty()) {
                    log.add("\n\tConditions:\n");
                    log.addAll(conditionList);
                }
            }
            log.add("\n\nPods with conditions and messages:\n\n");
            for (Pod pod : KubeResourceManager.get().kubeClient().listPodsByPrefixInName(namespace, jobName)) {
                log.add(pod.getMetadata().getName() + ":");
                ArrayList<CallSite> podConditions = new ArrayList<CallSite>();
                for (PodCondition podCondition : pod.getStatus().getConditions()) {
                    if (podCondition.getMessage() == null) continue;
                    podConditions.add((CallSite)((Object)("\n\tType: " + podCondition.getType() + "\n")));
                    podConditions.add((CallSite)((Object)("\tMessage: " + podCondition.getMessage() + "\n")));
                }
                if (podConditions.isEmpty()) {
                    log.add("\n\t<EMPTY>");
                } else {
                    log.addAll(podConditions);
                }
                log.add("\n\n");
            }
            LOGGER.info("{}", (Object)String.join((CharSequence)"", log).strip());
        }
    }
}

