/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.apps.Deployment;
import io.fabric8.kubernetes.api.model.apps.DeploymentList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.openshift.client.OpenShiftClient;
import io.skodjob.testframe.TestFrameEnv;
import io.skodjob.testframe.executor.Exec;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubeClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(KubeClient.class);
    private KubernetesClient client;
    private String kubeconfigPath;

    public KubeClient() {
        Config cfg = Config.autoConfigure(null);
        this.client = new KubernetesClientBuilder().withConfig(cfg).build();
    }

    public KubeClient(String kubeconfigPath) {
        this.kubeconfigPath = kubeconfigPath;
        Config cfg = Config.fromKubeconfig((String)KubeClient.readFile(kubeconfigPath));
        this.client = new KubernetesClientBuilder().withConfig(cfg).build();
    }

    public KubeClient(String apiUrl, String token) {
        Config cfg = ((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(apiUrl)).withOauthToken(token)).withTrustCerts(true)).withDisableHostnameVerification(true)).build();
        this.client = new KubernetesClientBuilder().withConfig(cfg).build();
        this.kubeconfigPath = this.generateTempKubeconfig(apiUrl, token);
    }

    public static KubeClient fromUrlAndToken(String apiUrl, String token) {
        return new KubeClient(apiUrl, token);
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    void testReconnect(Config config) {
        this.client = new KubernetesClientBuilder().withConfig(config).build();
    }

    public OpenShiftClient getOpenShiftClient() {
        return (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
    }

    public String getKubeconfigPath() {
        return this.kubeconfigPath;
    }

    public List<HasMetadata> readResourcesFromFile(Path file) throws IOException {
        return this.readResourcesFromFile(Files.newInputStream(file, new OpenOption[0]));
    }

    public List<HasMetadata> readResourcesFromFile(InputStream is) throws IOException {
        try (InputStream inputStream = is;){
            List list = this.client.load(is).items();
            return list;
        }
    }

    public boolean namespaceExists(String namespace) {
        return ((NamespaceList)this.client.namespaces().list()).getItems().stream().anyMatch(n -> n.getMetadata().getName().equals(namespace));
    }

    public void create(List<HasMetadata> resources, UnaryOperator<HasMetadata> modifier) {
        this.create(null, resources, modifier);
    }

    public void update(List<HasMetadata> resources, UnaryOperator<HasMetadata> modifier) {
        this.update(null, resources, modifier);
    }

    public void create(String namespace, List<HasMetadata> resources, UnaryOperator<HasMetadata> modifier) {
        resources.forEach(res -> {
            HasMetadata h = (HasMetadata)modifier.apply((HasMetadata)res);
            LOGGER.debug("{} {}/{} in {}", new Object[]{"Creating", h.getKind(), h.getMetadata().getName(), namespace});
            if (namespace == null) {
                this.client.resource(h).create();
            } else {
                this.client.resource(h).inNamespace(namespace).create();
            }
        });
    }

    public void update(String namespace, List<HasMetadata> resources, UnaryOperator<HasMetadata> modifier) {
        resources.forEach(res -> {
            HasMetadata h = (HasMetadata)modifier.apply((HasMetadata)res);
            LOGGER.debug("{} {}/{} in {}", new Object[]{"Updating", h.getKind(), h.getMetadata().getName(), namespace});
            if (namespace == null) {
                this.client.resource(h).update();
            } else {
                this.client.resource(h).inNamespace(namespace).update();
            }
        });
    }

    public void createOrUpdate(List<HasMetadata> resources, UnaryOperator<HasMetadata> modifier) {
        this.createOrUpdate(null, resources, modifier);
    }

    public void createOrUpdate(String ns, List<HasMetadata> resources, UnaryOperator<HasMetadata> modifier) {
        resources.forEach(i -> {
            HasMetadata h = (HasMetadata)modifier.apply((HasMetadata)i);
            if (h != null) {
                if (this.client.resource(h).get() == null) {
                    LOGGER.debug("{} {}/{} in {}", new Object[]{"Creating", h.getKind(), h.getMetadata().getName(), h.getMetadata().getNamespace()});
                    if (ns == null) {
                        this.client.resource(h).create();
                    } else {
                        this.client.resource(h).inNamespace(ns).create();
                    }
                } else {
                    LOGGER.debug("{} {}/{} in {}", new Object[]{"Updating", h.getKind(), h.getMetadata().getName(), h.getMetadata().getNamespace()});
                    if (ns == null) {
                        this.client.resource(h).update();
                    } else {
                        this.client.resource(h).inNamespace(ns).update();
                    }
                }
            }
        });
    }

    public void delete(List<HasMetadata> resources) {
        resources.forEach(h -> {
            if (h != null && this.client.resource(h).get() != null) {
                LOGGER.debug("{} {}/{} in {}", new Object[]{"Deleting", h.getKind(), h.getMetadata().getName(), h.getMetadata().getNamespace()});
                this.client.resource(h).delete();
            }
        });
    }

    public void delete(List<HasMetadata> resources, String namespace) {
        resources.forEach(h -> {
            if (h != null && this.client.resource(h).inNamespace(namespace).get() != null) {
                LOGGER.debug("{} {}/{} in {}", new Object[]{"Deleting", h.getKind(), h.getMetadata().getName(), namespace});
                this.client.resource(h).inNamespace(namespace).delete();
            }
        });
    }

    public List<Pod> listPods(String namespaceName) {
        return ((PodList)((NonNamespaceOperation)this.client.pods().inNamespace(namespaceName)).list()).getItems();
    }

    public List<Pod> listPods(String namespaceName, LabelSelector selector) {
        return ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)this.client.pods().inNamespace(namespaceName)).withLabelSelector(selector)).list()).getItems();
    }

    public List<Pod> listPodsByPrefixInName(String namespaceName, String podNamePrefix) {
        return this.listPods(namespaceName).stream().filter(p -> p.getMetadata().getName().startsWith(podNamePrefix)).collect(Collectors.toList());
    }

    public String getLogsFromPod(String namespaceName, String podName) {
        return ((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespaceName)).withName(podName)).getLog();
    }

    public String getLogsFromContainer(String namespaceName, String podName, String containerName) {
        return ((ContainerResource)((PodResource)((NonNamespaceOperation)this.client.pods().inNamespace(namespaceName)).withName(podName)).inContainer((Object)containerName)).getLog();
    }

    public String getDeploymentNameByPrefix(String namespace, String namePrefix) {
        List<Deployment> prefixDeployments = ((DeploymentList)((NonNamespaceOperation)this.client.apps().deployments().inNamespace(namespace)).list()).getItems().stream().filter(rs -> rs.getMetadata().getName().startsWith(namePrefix)).toList();
        if (!prefixDeployments.isEmpty()) {
            return prefixDeployments.get(0).getMetadata().getName();
        }
        return null;
    }

    private static String readFile(String path) {
        try {
            return Files.readString(Path.of(path, new String[0]), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot read " + path, e);
        }
    }

    private String generateTempKubeconfig(String url, String token) {
        try {
            String host = URI.create(url).getHost().replaceAll("[^\\w]", "-");
            String suffix = Integer.toHexString((host + token).hashCode()).substring(0, 6);
            String path = Path.of(TestFrameEnv.USER_PATH, "test-" + host + "-" + suffix + ".kubeconfig").toString();
            Exec.exec(null, Arrays.asList("kubectl", "config", "set-credentials", "tf-user-" + suffix, "--token", token, "--kubeconfig", path), 0, false, true);
            Exec.exec(null, Arrays.asList("kubectl", "config", "set-cluster", "tf-cluster-" + suffix, "--insecure-skip-tls-verify=true", "--server", url, "--kubeconfig", path), 0, false, true);
            Exec.exec(null, Arrays.asList("kubectl", "config", "set-context", "tf-context-" + suffix, "--user", "tf-user-" + suffix, "--cluster", "tf-cluster-" + suffix, "--namespace", "default", "--kubeconfig", path), 0, false, true);
            Exec.exec(null, Arrays.asList("kubectl", "config", "use-context", "tf-context-" + suffix, "--kubeconfig", path), 0, false, true);
            return path;
        }
        catch (Exception ex) {
            LOGGER.warn("Could not generate temp kubeconfig: {}", (Object)ex.getMessage());
            return null;
        }
    }
}

