/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients.cmdClient;

import io.skodjob.testframe.clients.cmdClient.BaseCmdKubeClient;
import io.skodjob.testframe.executor.Exec;

public class Kubectl
extends BaseCmdKubeClient<Kubectl> {
    public static final String KUBECTL = "kubectl";

    public Kubectl() {
        this(null);
    }

    public Kubectl(String config) {
        super(config, 0);
    }

    private Kubectl(String futureNamespace, String config, int timeout) {
        super(config, timeout);
        this.namespace = futureNamespace;
    }

    public Kubectl inNamespace(String namespace) {
        return new Kubectl(namespace, this.config, this.timeout);
    }

    public Kubectl withTimeout(int timeout) {
        return new Kubectl(this.namespace, this.config, timeout);
    }

    public Kubectl withTimeout(long timeout) {
        return new Kubectl(this.namespace, this.config, (int)timeout);
    }

    @Override
    public String getCurrentNamespace() {
        return this.namespace;
    }

    @Override
    public String defaultOlmNamespace() {
        return "operators";
    }

    @Override
    public String cmd() {
        return KUBECTL;
    }

    @Override
    public String getUsername() {
        return Exec.exec(this.command("auth", "whoami", "-o", "jsonpath='{.status.userInfo.username}'"), this.timeout).out();
    }

    @Override
    public void cordon(String nodeName) {
        Exec.exec(this.command("cordon", nodeName), this.timeout);
    }

    @Override
    public void uncordon(String nodeName) {
        Exec.exec(this.command("uncordon", nodeName), this.timeout);
    }

    @Override
    public void drain(String nodeName, boolean ignoreDaemonSets, boolean disableEviction, long timeoutInSeconds) {
        Exec.exec(this.command("drain", nodeName, "--ignore-daemonsets", String.valueOf(ignoreDaemonSets), "--disable-eviction", String.valueOf(disableEviction), "--timeout", timeoutInSeconds + "s"), this.timeout);
    }
}

