/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.clients.cmdClient;

import io.skodjob.testframe.clients.cmdClient.BaseCmdKubeClient;
import io.skodjob.testframe.executor.Exec;
import java.util.List;
import java.util.Map;

public class Oc
extends BaseCmdKubeClient<Oc> {
    private static final String OC = "oc";

    public Oc() {
        this(null);
    }

    public Oc(String config) {
        super(config, 0);
    }

    private Oc(String futureNamespace, String config, int timeout) {
        super(config, timeout);
        this.namespace = futureNamespace;
    }

    @Override
    public String defaultOlmNamespace() {
        return "openshift-marketplace";
    }

    public Oc inNamespace(String namespace) {
        return new Oc(namespace, this.config, this.timeout);
    }

    public Oc withTimeout(int timeout) {
        return new Oc(this.namespace, this.config, timeout);
    }

    public Oc withTimeout(long timeout) {
        return new Oc(this.namespace, this.config, (int)timeout);
    }

    @Override
    public String getCurrentNamespace() {
        return this.namespace;
    }

    @Override
    public Oc createNamespace(String name) {
        try (BaseCmdKubeClient.Context context = this.defaultContext();){
            Exec.exec(this.timeout, this.cmd(), "new-project", name);
        }
        return this;
    }

    public Oc newApp(String template, Map<String, String> params) {
        List<String> cmd = this.command("new-app", template);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            cmd.add("-p");
            cmd.add(entry.getKey() + "=" + entry.getValue());
        }
        Exec.exec(cmd, this.timeout);
        return this;
    }

    @Override
    public String cmd() {
        return OC;
    }

    @Override
    public String getUsername() {
        return Exec.exec(this.command("whoami"), this.timeout).out();
    }

    @Override
    public void cordon(String nodeName) {
        Exec.exec(this.command("adm", "cordon", nodeName), this.timeout);
    }

    @Override
    public void uncordon(String nodeName) {
        Exec.exec(this.command("adm", "uncordon", nodeName), this.timeout);
    }

    @Override
    public void drain(String nodeName, boolean ignoreDaemonSets, boolean disableEviction, long timeoutInSeconds) {
        Exec.exec(this.command("adm", "drain", nodeName, "--ignore-daemonsets", String.valueOf(ignoreDaemonSets), "--disable-eviction", String.valueOf(disableEviction), "--timeout", timeoutInSeconds + "s"), this.timeout);
    }
}

