/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.utils;

import io.fabric8.kubernetes.api.model.ContainerStatus;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.readiness.Readiness;
import io.skodjob.testframe.TestFrameConstants;
import io.skodjob.testframe.resources.KubeResourceManager;
import io.skodjob.testframe.wait.Wait;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PodUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(PodUtils.class);
    private static final long READINESS_TIMEOUT = Duration.ofMinutes(10L).toMillis();

    private PodUtils() {
    }

    public static void waitForPodsReady(String namespaceName, boolean containersReady, Runnable onTimeout) {
        Wait.until("readiness of all Pods in namespace " + namespaceName, TestFrameConstants.GLOBAL_POLL_INTERVAL_MEDIUM, READINESS_TIMEOUT, () -> {
            List pods = ((PodList)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().pods().inNamespace(namespaceName)).list()).getItems();
            if (pods.isEmpty()) {
                LOGGER.debug("There are no existing Pods in Namespace {}", (Object)namespaceName);
                return false;
            }
            for (Pod pod : pods) {
                if (!Readiness.isPodReady((Pod)pod) && !Readiness.isPodSucceeded((Pod)pod)) {
                    LOGGER.debug("There is not ready Pod {}/{}", (Object)namespaceName, (Object)pod.getMetadata().getName());
                    return false;
                }
                if (!containersReady) continue;
                for (ContainerStatus cs : pod.getStatus().getContainerStatuses()) {
                    if (Boolean.TRUE.equals(cs.getReady()) || cs.getState().getTerminated().getReason().equals("Completed")) continue;
                    LOGGER.debug("Container {} of Pod {}/{} is not ready", new Object[]{cs.getName(), namespaceName, pod.getMetadata().getName()});
                    return false;
                }
            }
            LOGGER.info("All Pods in Namespace {} are ready", (Object)namespaceName);
            return true;
        }, onTimeout);
    }

    public static void waitForPodsReady(String namespaceName, LabelSelector selector, int expectPodsCount, boolean containers, Runnable onTimeout) {
        Wait.until("readiness of all Pods matching " + String.valueOf(selector) + " in Namespace " + namespaceName, TestFrameConstants.GLOBAL_POLL_INTERVAL_MEDIUM, READINESS_TIMEOUT, () -> {
            List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().pods().inNamespace(namespaceName)).withLabelSelector(selector)).list()).getItems();
            if (pods.isEmpty() && expectPodsCount == 0) {
                LOGGER.debug("All expected Pods {} in Namespace {} are ready", (Object)selector, (Object)namespaceName);
                return true;
            }
            if (pods.isEmpty()) {
                LOGGER.debug("Pods matching {}/{} are not ready", (Object)namespaceName, (Object)selector);
                return false;
            }
            if (pods.size() != expectPodsCount) {
                LOGGER.debug("Expected Pods {}/{} are not ready", (Object)namespaceName, (Object)selector);
                return false;
            }
            for (Pod pod : pods) {
                if (!Readiness.isPodReady((Pod)pod) && !Readiness.isPodSucceeded((Pod)pod)) {
                    LOGGER.debug("Pod is not ready: {}/{}", (Object)namespaceName, (Object)pod.getMetadata().getName());
                    return false;
                }
                if (!containers) continue;
                for (ContainerStatus cs : pod.getStatus().getContainerStatuses()) {
                    if (Boolean.TRUE.equals(cs.getReady()) || cs.getState().getTerminated().getReason().equals("Completed")) continue;
                    LOGGER.debug("Container {} of Pod {}/{} not ready", new Object[]{cs.getName(), namespaceName, pod.getMetadata().getName()});
                    return false;
                }
            }
            LOGGER.info("Pods matching {}/{} are ready", (Object)namespaceName, (Object)selector);
            return true;
        }, onTimeout);
    }

    public static void waitForPodsReadyWithRestart(String namespaceName, LabelSelector selector, int expectedPodsCount, boolean containersReady) {
        try {
            PodUtils.waitForPodsReady(namespaceName, selector, expectedPodsCount, containersReady, () -> {});
        }
        catch (Exception ex) {
            LOGGER.warn("Pods {}/{} are not ready. Going to restart them", (Object)namespaceName, (Object)selector);
            ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().pods().inNamespace(namespaceName)).withLabelSelector(selector)).list()).getItems().forEach(p -> KubeResourceManager.get().kubeClient().getClient().resource((HasMetadata)p).delete());
            PodUtils.waitForPodsReady(namespaceName, selector, expectedPodsCount, containersReady, () -> {});
        }
    }

    public static Map<String, String> podSnapshot(String namespaceName, LabelSelector selector) {
        List pods = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().pods().inNamespace(namespaceName)).withLabelSelector(selector)).list()).getItems();
        return pods.stream().collect(Collectors.toMap(pod -> pod.getMetadata().getName(), pod -> pod.getMetadata().getUid()));
    }

    public static void verifyThatPodsAreStable(String namespaceName, LabelSelector selector) {
        int[] stabilityCounter = new int[]{0};
        String phase = "Running";
        Wait.until(String.format("Pods in Namespace '%s' with LabelSelector %s stability in phase %s", namespaceName, selector, phase), TestFrameConstants.GLOBAL_POLL_INTERVAL_SHORT, TestFrameConstants.GLOBAL_TIMEOUT, () -> {
            List existingPod = ((PodList)((FilterWatchListDeletable)((NonNamespaceOperation)KubeResourceManager.get().kubeClient().getClient().pods().inNamespace(namespaceName)).withLabelSelector(selector)).list()).getItems();
            LOGGER.debug("Considering the following Pods {}", existingPod.stream().map(p -> p.getMetadata().getName()).toList());
            for (Pod pod : existingPod) {
                if (pod == null) continue;
                if (pod.getStatus().getPhase().equals(phase)) {
                    LOGGER.debug("Pod {}/{} is in the {} state. Remaining milliseconds for Pod to be stable {}", new Object[]{namespaceName, pod.getMetadata().getName(), pod.getStatus().getPhase(), TestFrameConstants.GLOBAL_STABILITY_TIME - TestFrameConstants.GLOBAL_POLL_INTERVAL_SHORT * (long)stabilityCounter[0]});
                    continue;
                }
                LOGGER.warn("Pod {}/{} is not stable in phase following phase {} ({}) reset the stability counter from {}ms to {}ms", new Object[]{namespaceName, pod.getMetadata().getName(), pod.getStatus().getPhase(), phase, stabilityCounter[0], 0});
                stabilityCounter[0] = 0;
                return false;
            }
            stabilityCounter[0] = stabilityCounter[0] + 1;
            if ((long)stabilityCounter[0] == TestFrameConstants.GLOBAL_STABILITY_TIME / TestFrameConstants.GLOBAL_POLL_INTERVAL_SHORT) {
                LOGGER.info("All Pods {}/{} are stable", (Object)namespaceName, (Object)existingPod.stream().map(p -> p.getMetadata().getName()).collect(Collectors.joining(" ,")));
                return true;
            }
            return false;
        });
    }
}

