/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.wait;

import io.skodjob.testframe.wait.WaitException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BooleanSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wait {
    private static final Logger LOGGER = LoggerFactory.getLogger(Wait.class);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        final ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread result = this.defaultThreadFactory.newThread(r);
            result.setDaemon(true);
            return result;
        }
    });

    private Wait() {
    }

    public static void until(String description, long pollIntervalMs, long timeoutMs, BooleanSupplier ready) {
        Wait.until(description, pollIntervalMs, timeoutMs, ready, () -> {});
    }

    public static void until(String description, long pollIntervalMs, long timeoutMs, BooleanSupplier ready, Runnable onTimeout) {
        LOGGER.info("Waiting for: {}", (Object)description);
        long deadline = System.currentTimeMillis() + timeoutMs;
        String exceptionMessage = null;
        String previousExceptionMessage = null;
        int exceptionAppearanceCount = Duration.ofMillis(pollIntervalMs).toMinutes() > 0L ? 2 : Math.max((int)(timeoutMs / pollIntervalMs) / 4, 2);
        int exceptionCount = 0;
        int newExceptionAppearance = 0;
        StringWriter stackTraceError = new StringWriter();
        while (true) {
            boolean result;
            try {
                result = ready.getAsBoolean();
            }
            catch (Exception e) {
                exceptionMessage = e.getMessage();
                if (++exceptionCount == exceptionAppearanceCount && exceptionMessage != null && exceptionMessage.equals(previousExceptionMessage)) {
                    if (e.getCause() instanceof TimeoutException) {
                        LOGGER.warn("While waiting for: {} exception occurred: {}", (Object)description, (Object)e.getCause().getClass().getCanonicalName());
                        exceptionMessage = e.getCause().getClass().getCanonicalName();
                    } else {
                        LOGGER.warn("While waiting for: {} exception occurred: {}/{}", new Object[]{description, e.getCause().getClass().getCanonicalName(), exceptionMessage});
                    }
                    e.printStackTrace(new PrintWriter(stackTraceError));
                } else if (exceptionMessage != null && !exceptionMessage.equals(previousExceptionMessage) && ++newExceptionAppearance == 2) {
                    previousExceptionMessage = exceptionMessage;
                }
                result = false;
            }
            long timeLeft = deadline - System.currentTimeMillis();
            if (result) {
                return;
            }
            if (timeLeft <= 0L) {
                if (exceptionCount > 1) {
                    if (exceptionMessage.equals("null")) {
                        LOGGER.error("Latest exception while waiting for: {} was: {}", (Object)description, (Object)exceptionMessage);
                    } else {
                        LOGGER.error("Latest exception while waiting for: {} had message: {}", (Object)description, (Object)exceptionMessage);
                    }
                    if (!stackTraceError.toString().isEmpty()) {
                        LOGGER.error(String.valueOf(stackTraceError));
                    }
                }
                onTimeout.run();
                WaitException waitException = new WaitException("Timeout after " + timeoutMs + " ms waiting for " + description);
                LOGGER.error(waitException.getMessage(), (Throwable)waitException);
                throw waitException;
            }
            long sleepTime = Math.min(pollIntervalMs, timeLeft);
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public static CompletableFuture<Void> untilAsync(final String description, long pollIntervalMs, final long timeoutMs, final BooleanSupplier ready) {
        LOGGER.info("Waiting for {}", (Object)description);
        final long deadline = System.currentTimeMillis() + timeoutMs;
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        final Executor delayed = CompletableFuture.delayedExecutor(pollIntervalMs, TimeUnit.MILLISECONDS, EXECUTOR);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean result;
                try {
                    result = ready.getAsBoolean();
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                    return;
                }
                long timeLeft = deadline - System.currentTimeMillis();
                if (!future.isDone()) {
                    if (!result) {
                        if (timeLeft >= 0L) {
                            if (LOGGER.isTraceEnabled()) {
                                LOGGER.trace("{} not ready, will try again ({}ms till timeout)", (Object)description, (Object)timeLeft);
                            }
                            delayed.execute(this);
                        } else {
                            future.completeExceptionally(new TimeoutException(String.format("Waiting for %s timeout %s exceeded", description, timeoutMs)));
                        }
                    } else {
                        future.complete(null);
                    }
                }
            }
        };
        r.run();
        return future;
    }
}

