/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.rbac.ClusterRole;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleList;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class ClusterRoleType
implements ResourceType<ClusterRole> {
    private final NonNamespaceOperation<ClusterRole, ClusterRoleList, Resource<ClusterRole>> client = KubeResourceManager.get().kubeClient().getClient().rbac().clusterRoles();

    public String getKind() {
        return "ClusterRole";
    }

    public NonNamespaceOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(ClusterRole resource) {
        ((Resource)this.client.resource((Object)resource)).create();
    }

    public void update(ClusterRole resource) {
        ((Resource)this.client.resource((Object)resource)).update();
    }

    public void delete(ClusterRole resource) {
        ((Resource)this.client.withName(resource.getMetadata().getName())).delete();
    }

    public void replace(ClusterRole resource, Consumer<ClusterRole> editor) {
        ClusterRole toBeUpdated = (ClusterRole)((Resource)this.client.withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(ClusterRole resource) {
        return resource != null;
    }

    public boolean isDeleted(ClusterRole resource) {
        return resource == null;
    }
}

