/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.ConfigMap;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class ConfigMapType
implements ResourceType<ConfigMap> {
    private final MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> client = KubeResourceManager.get().kubeClient().getClient().configMaps();

    public String getKind() {
        return "ConfigMap";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(ConfigMap resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(ConfigMap resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void replace(ConfigMap resource, Consumer<ConfigMap> editor) {
        ConfigMap toBeUpdated = (ConfigMap)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public void delete(ConfigMap resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public boolean isReady(ConfigMap resource) {
        return resource != null;
    }

    public boolean isDeleted(ConfigMap resource) {
        return resource == null;
    }
}

