/*
 * Decompiled with CFR 0.152.
 */
package io.skodjob.testframe.resources;

import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicy;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyList;
import io.fabric8.kubernetes.client.dsl.MixedOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.skodjob.testframe.interfaces.ResourceType;
import io.skodjob.testframe.resources.KubeResourceManager;
import java.util.function.Consumer;

public class NetworkPolicyType
implements ResourceType<NetworkPolicy> {
    private final MixedOperation<NetworkPolicy, NetworkPolicyList, Resource<NetworkPolicy>> client = KubeResourceManager.get().kubeClient().getClient().network().networkPolicies();

    public String getKind() {
        return "NetworkPolicy";
    }

    public MixedOperation<?, ?, ?> getClient() {
        return this.client;
    }

    public void create(NetworkPolicy resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).create();
    }

    public void update(NetworkPolicy resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).resource((Object)resource)).update();
    }

    public void delete(NetworkPolicy resource) {
        ((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).delete();
    }

    public void replace(NetworkPolicy resource, Consumer<NetworkPolicy> editor) {
        NetworkPolicy toBeUpdated = (NetworkPolicy)((Resource)((NonNamespaceOperation)this.client.inNamespace(resource.getMetadata().getNamespace())).withName(resource.getMetadata().getName())).get();
        editor.accept(toBeUpdated);
        this.update(toBeUpdated);
    }

    public boolean isReady(NetworkPolicy resource) {
        return resource != null;
    }

    public boolean isDeleted(NetworkPolicy resource) {
        return resource == null;
    }
}

